/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import solutions.onesight.ossEasyMqtt.license.OssEasyMqttLicense;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65541, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="routeFromBrokerValid", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="targetSlotName", type="String", defaultValue="routeFromBroker", flags=4), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="debugDataEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="resolveTargetLink"), @NiagaraAction(name="routeToBroker", parameterType="BString", defaultValue="BString.DEFAULT", flags=8)})
public class BOssMqttRouter
extends BComponent {
    public static final Property enabled = BOssMqttRouter.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssMqttRouter.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssMqttRouter.newProperty((int)67, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property lastUpdate = BOssMqttRouter.newProperty((int)65541, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property routeFromBrokerValid = BOssMqttRouter.newProperty((int)65, (boolean)false, null);
    public static final Property targetSlotName = BOssMqttRouter.newProperty((int)4, (String)"routeFromBroker", null);
    public static final Property debugEnabled = BOssMqttRouter.newProperty((int)4, (boolean)false, null);
    public static final Property debugDataEnabled = BOssMqttRouter.newProperty((int)4, (boolean)false, null);
    public static final Action resolveTargetLink = BOssMqttRouter.newAction((int)0, null);
    public static final Action routeToBroker = BOssMqttRouter.newAction((int)8, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BOssMqttRouter.class);
    private BOssMqttBroker broker = null;
    private MqttRouterTask routerTask;
    private volatile boolean abortRouterTask = false;
    private long droppedIncomingMessageCount = 0L;
    private BLink routeLink = null;
    private BComponent linkComponent = null;
    private String logPrefix = "null";
    private final LinkedBlockingQueue<String> incomingQueue = new LinkedBlockingQueue(10000);
    private final MqttSubscriptionCallbackHandler callbackHandler = new MqttSubscriptionCallbackHandler();
    private final HashSet<String> subscriptionSet = new HashSet();
    public static final int INCOMING_MESSAGE_QUEUE_SIZE = 10000;
    private static final Logger log = OssEasyMqttLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public boolean getRouteFromBrokerValid() {
        return this.getBoolean(routeFromBrokerValid);
    }

    public void setRouteFromBrokerValid(boolean v) {
        this.setBoolean(routeFromBrokerValid, v, null);
    }

    public String getTargetSlotName() {
        return this.getString(targetSlotName);
    }

    public void setTargetSlotName(String v) {
        this.setString(targetSlotName, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public boolean getDebugDataEnabled() {
        return this.getBoolean(debugDataEnabled);
    }

    public void setDebugDataEnabled(boolean v) {
        this.setBoolean(debugDataEnabled, v, null);
    }

    public void resolveTargetLink() {
        this.invoke(resolveTargetLink, null, null);
    }

    public void routeToBroker(BString parameter) {
        this.invoke(routeToBroker, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.broker = BOssMqttBroker.findBroker(this);
        if (this.broker == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid parent");
            log.severe("MqttRouter [" + this.getSlotPath() + "] should be placed in a MqttBroker");
            throw new BajaRuntimeException("Invalid parent");
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
        this.logPrefix = this.broker.getLogPrefix();
        this.startRouterTask();
    }

    public void stopped() {
        this.stopRouterTask();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (this.broker == null) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.make((int)(this.getStatus().getBits() & 0xFFFFFFFE)));
                this.startRouterTask();
            } else {
                this.setStatus(BStatus.make((int)(this.getStatus().getBits() | 1)));
                this.stopRouterTask();
            }
        }
    }

    public void added(Property prop, Context context) {
        BLink newLink;
        if (!this.isRunning()) {
            return;
        }
        if (prop.getType().is(BLink.TYPE) && (newLink = (BLink)this.get(prop)).isActive() && newLink.getTargetComponent().equals((Object)this) && newLink.getTargetSlot().equals((Object)routeToBroker)) {
            this.assignRouteFromBroker();
        }
    }

    public void checkRemove(Property prop, Context cxt) {
        BLink newLink;
        if (!this.isRunning()) {
            return;
        }
        if (prop.getType().is(BLink.TYPE) && (newLink = (BLink)this.get(prop)).isActive() && newLink.getTargetComponent().equals((Object)this) && newLink.getTargetSlot().equals((Object)routeToBroker) && this.linkComponent != null) {
            this.linkComponent.invoke(this.linkComponent.getAction(this.getTargetSlotName()), (BValue)BString.make((String)"{\"op\":\"shutdown\"}"), null);
        }
    }

    public void removed(Property prop, BValue oldValue, Context cxt) {
        BLink oldLink;
        if (!this.isRunning()) {
            return;
        }
        if (this.routeLink != null && prop.getType().is(BLink.TYPE) && (oldLink = (BLink)this.get(prop)).equals((Object)this.routeLink)) {
            this.linkComponent = null;
            this.routeLink = null;
            this.setRouteFromBrokerValid(false);
        }
    }

    public void doResolveTargetLink() {
        this.assignRouteFromBroker();
    }

    public void doRouteToBroker(BString mqttMessage) {
        this.processMqttMessageIn(mqttMessage.getString());
    }

    public void assignRouteFromBroker() {
        this.linkComponent = null;
        this.routeLink = null;
        boolean validRouteFromBrokerLink = false;
        BLink[] localLinks = this.getLinks((Slot)routeToBroker);
        if (localLinks.length < 1) {
            this.setRouteFromBrokerValid(false);
            this.errorMsg("No route from broker link found [" + this.getSlotPath() + "]");
            return;
        }
        BComponent tmpLinkSource = localLinks[0].getSourceComponent();
        if (tmpLinkSource == null) {
            this.setRouteFromBrokerValid(false);
            this.errorMsg("No route from broker link found [" + this.getSlotPath() + "]");
            return;
        }
        Action linkAction = tmpLinkSource.getAction(this.getTargetSlotName());
        if (linkAction != null) {
            this.linkComponent = tmpLinkSource;
            this.routeLink = localLinks[0];
            validRouteFromBrokerLink = true;
            this.debugMsg("Route from broker link [" + this.getSlotPath() + "] to: " + this.linkComponent.getSlotPath());
        } else {
            this.errorMsg("Route link target has no receiving slot");
        }
        this.setRouteFromBrokerValid(validRouteFromBrokerLink);
    }

    public void routeMqttMessageOut(String mqttMessage) {
        if (!this.getEnabled()) {
            return;
        }
        if (this.linkComponent == null) {
            this.setRouteFromBrokerValid(false);
            this.debugMsg("No route from broker link defined");
            return;
        }
        try {
            this.linkComponent.invoke(this.linkComponent.getAction(this.getTargetSlotName()), (BValue)BString.make((String)mqttMessage), null);
        }
        catch (Exception routeException) {
            this.errorMsg("Exception routing MQTT: " + routeException);
            routeException.printStackTrace();
        }
    }

    public void processMqttMessageIn(String mqttMessage) {
        if (!this.getEnabled()) {
            return;
        }
        try {
            if (!this.incomingQueue.offer(mqttMessage)) {
                ++this.droppedIncomingMessageCount;
            }
        }
        catch (Exception routeException) {
            this.errorMsg("Exception routing MQTT: " + routeException);
            routeException.printStackTrace();
        }
    }

    public void processSubscribe(String topic, int qos) {
        if (this.broker.getConnected()) {
            IMqttToken subscribeToken = this.broker.subscribe(topic, qos, this.callbackHandler, this.callbackHandler);
            if (subscribeToken != null) {
                this.debugMsg("Router subscribed: " + topic);
            } else {
                this.errorMsg("Router subscription failed: " + topic);
            }
        }
    }

    public void processUnsubscribe(String topic, int qos) {
        if (this.broker.getConnected()) {
            this.broker.unsubscribe(topic);
            this.debugMsg("Router unsubscribed: " + topic);
        }
    }

    public void subscribeAllTopics() {
        this.debugMsg("Router subscribing all topics (" + this.subscriptionSet.size() + ")");
        Iterator<String> subsIterator = this.subscriptionSet.iterator();
        while (subsIterator.hasNext()) {
            this.processSubscribe(subsIterator.next(), 0);
        }
    }

    public synchronized void startRouterTask() {
        if (!OssEasyMqttLicense.isLicensed()) {
            this.errorMsg("ossEasyMqtt not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.debugMsg("Router disabled");
            return;
        }
        if (this.routerTask == null || !this.routerTask.isAlive()) {
            this.abortRouterTask = false;
            this.routerTask = new MqttRouterTask();
            this.routerTask.start();
        }
    }

    public synchronized void stopRouterTask() {
        this.abortRouterTask = true;
        if (this.routerTask != null) {
            this.routerTask.interrupt();
        }
        this.routerTask = null;
    }

    public void debugMsg(String messageText) {
        if (this.getDebugEnabled()) {
            log.finest(this.logPrefix + "[" + this.getName() + "] " + messageText);
        }
    }

    public void errorMsg(String messageText) {
        log.severe(this.logPrefix + "[" + this.getName() + "] " + messageText);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/gear.png");
    }

    private class MqttRouterTask
    extends Thread {
        private MqttRouterTask() {
        }

        @Override
        public void run() {
            BOssMqttRouter.this.abortRouterTask = false;
            this.setName("OSS-MqttRouterTask");
            if (!OssEasyMqttLicense.isLicensed()) {
                BOssMqttRouter.this.errorMsg("ossEasyMqtt not licensed");
                return;
            }
            if (!BOssMqttRouter.this.getEnabled()) {
                BOssMqttRouter.this.debugMsg("Router disabled");
                return;
            }
            BOssMqttRouter.this.debugMsg("Router task started");
            BOssMqttRouter.this.assignRouteFromBroker();
            BOssMqttRouter.this.setStatus(BStatus.ok);
            BOssMqttRouter.this.setFaultCause("");
            try {
                while (!BOssMqttRouter.this.abortRouterTask) {
                    this.consumeEntry((String)BOssMqttRouter.this.incomingQueue.take());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception routerException) {
                BOssMqttRouter.this.errorMsg("Message router exception: " + routerException);
                routerException.printStackTrace();
            }
            BOssMqttRouter.this.debugMsg("Router task terminated");
        }

        void consumeEntry(String mqttMessageStr) {
            block16: {
                try {
                    JsonElement mqttJsonElement = null;
                    try {
                        Gson gson = new Gson();
                        mqttJsonElement = gson.fromJson(mqttMessageStr, JsonElement.class);
                    }
                    catch (JsonSyntaxException invalidJsonException) {
                        BOssMqttRouter.this.errorMsg("Router received invalid MQTT JSON");
                    }
                    if (mqttJsonElement != null && mqttJsonElement.isJsonObject()) {
                        JsonObject mqttMessage = mqttJsonElement.getAsJsonObject();
                        if (mqttMessage.has("op") && mqttMessage.has("topic")) {
                            JsonElement opElement = mqttMessage.get("op");
                            if (opElement.isJsonPrimitive()) {
                                String mqttOp = opElement.getAsString().trim();
                                if (mqttOp.startsWith("pub")) {
                                    this.mqttPublish(mqttMessage);
                                } else if (mqttOp.startsWith("sub")) {
                                    this.mqttSubscribe(mqttMessage);
                                } else if (mqttOp.startsWith("unsub")) {
                                    this.mqttUnsubscribe(mqttMessage);
                                } else {
                                    BOssMqttRouter.this.debugMsg("Router invalid MQTT message operation: " + mqttOp);
                                }
                            } else {
                                BOssMqttRouter.this.debugMsg("Router invalid broker message operation type");
                            }
                        } else {
                            BOssMqttRouter.this.debugMsg("Router invalid broker message contents");
                        }
                    } else {
                        BOssMqttRouter.this.debugMsg("Router invalid broker message JSON: " + mqttMessageStr);
                    }
                }
                catch (Exception jsonException) {
                    BOssMqttRouter.this.errorMsg("Router MQTT JSON exception: " + jsonException);
                    if (!BOssMqttRouter.this.getDebugEnabled()) break block16;
                    jsonException.printStackTrace();
                }
            }
        }

        void mqttSubscribe(JsonObject mqttMessage) {
            JsonElement topicElement = mqttMessage.get("topic");
            if (topicElement.isJsonPrimitive()) {
                JsonPrimitive qosPrimitive;
                String mqttTopic = topicElement.getAsString().trim();
                int mqttQos = 0;
                JsonElement qosElement = mqttMessage.get("qos");
                if (qosElement != null && qosElement.isJsonPrimitive() && (qosPrimitive = qosElement.getAsJsonPrimitive()).isNumber()) {
                    mqttQos = qosPrimitive.getAsInt();
                }
                BOssMqttRouter.this.subscriptionSet.add(mqttTopic);
                BOssMqttRouter.this.processSubscribe(mqttTopic, mqttQos);
            }
        }

        void mqttUnsubscribe(JsonObject mqttMessage) {
            JsonElement topicElement = mqttMessage.get("topic");
            if (topicElement.isJsonPrimitive()) {
                JsonPrimitive qosPrimitive;
                String mqttTopic = topicElement.getAsString().trim();
                int mqttQos = 0;
                JsonElement qosElement = mqttMessage.get("qos");
                if (qosElement != null && qosElement.isJsonPrimitive() && (qosPrimitive = qosElement.getAsJsonPrimitive()).isNumber()) {
                    mqttQos = qosPrimitive.getAsInt();
                }
                BOssMqttRouter.this.subscriptionSet.remove(mqttTopic);
                BOssMqttRouter.this.processUnsubscribe(mqttTopic, mqttQos);
            }
        }

        void mqttPublish(JsonObject mqttMessage) {
            if (mqttMessage.has("topic") && mqttMessage.has("payload")) {
                JsonElement topicElement = mqttMessage.get("topic");
                JsonElement payloadElement = mqttMessage.get("payload");
                if (topicElement.isJsonPrimitive() && payloadElement.isJsonObject()) {
                    JsonPrimitive retainedPrimitive;
                    JsonElement retainedElement;
                    JsonElement qosElement;
                    String topicStr = topicElement.getAsString();
                    String payloadStr = payloadElement.toString();
                    MqttMessage publishMessage = new MqttMessage(payloadStr.getBytes());
                    if (mqttMessage.has("qos") && (qosElement = mqttMessage.get("qos")).isJsonPrimitive()) {
                        switch (qosElement.toString()) {
                            case "2": {
                                publishMessage.setQos(2);
                                break;
                            }
                            case "1": {
                                publishMessage.setQos(1);
                                break;
                            }
                            default: {
                                publishMessage.setQos(0);
                            }
                        }
                    }
                    if (mqttMessage.has("retained") && (retainedElement = mqttMessage.get("retained")).isJsonPrimitive() && (retainedPrimitive = retainedElement.getAsJsonPrimitive()).isBoolean()) {
                        publishMessage.setRetained(retainedPrimitive.getAsBoolean());
                    }
                    BOssMqttRouter.this.broker.publish(topicStr, publishMessage, null);
                    if (BOssMqttRouter.this.getDebugDataEnabled()) {
                        BOssMqttRouter.this.debugMsg("Router out [" + topicStr + "] " + payloadStr);
                    }
                } else {
                    BOssMqttRouter.this.debugMsg("Router invalid publish message types");
                }
            } else {
                BOssMqttRouter.this.debugMsg("Router invalid publish message contents");
            }
        }
    }

    private class MqttSubscriptionCallbackHandler
    implements IMqttActionListener,
    IMqttMessageListener {
        private MqttSubscriptionCallbackHandler() {
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            BOssMqttRouter.this.errorMsg("Router subscribe failed: " + exception.getCause());
            if (BOssMqttRouter.this.getDebugEnabled()) {
                exception.printStackTrace();
            }
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) {
            if (BOssMqttRouter.this.getEnabled() && topic != null && message != null) {
                try {
                    String payloadText = new String(message.getPayload());
                    String incomingMessage = "{\"op\":\"receive\",\"topic\":\"" + topic + "\",\"payload\":" + this.normalisePayload(payloadText) + ",\"qos\":" + message.getQos() + ",\"retained\":" + message.isRetained() + "}";
                    BOssMqttRouter.this.routeMqttMessageOut(incomingMessage);
                    if (BOssMqttRouter.this.getDebugDataEnabled()) {
                        BOssMqttRouter.this.debugMsg("Router received message: [" + topic + "] " + payloadText);
                    }
                }
                catch (Exception queueException) {
                    queueException.printStackTrace();
                }
            }
        }

        private String normalisePayload(String srcPayloadText) {
            String normalisedPayload;
            JsonElement payloadJsonElement;
            try {
                Gson gson = new Gson();
                payloadJsonElement = gson.fromJson(srcPayloadText, JsonElement.class);
            }
            catch (JsonSyntaxException invalidJsonException) {
                payloadJsonElement = null;
            }
            if (payloadJsonElement == null || payloadJsonElement.isJsonPrimitive()) {
                srcPayloadText = srcPayloadText.replace("\\", "\\\\");
                srcPayloadText = srcPayloadText.replace("\"", "\\\"");
                normalisedPayload = "\"" + srcPayloadText + "\"";
            } else {
                normalisedPayload = payloadJsonElement.toString();
            }
            return normalisedPayload;
        }
    }
}

