/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BMqttQos;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;
import solutions.onesight.ossEasyMqtt.mqtt.BPublishStatistics;
import solutions.onesight.ossEasyMqtt.mqtt.MqttMessageCallback;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="description", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="topic", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="qos", type="BMqttQos", defaultValue="BMqttQos.AtMostOnce"), @NiagaraProperty(name="messageIn", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make( 70 )")}), @NiagaraProperty(name="retained", type="boolean", defaultValue="false"), @NiagaraProperty(name="lastPublished", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65545, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="messageSize", type="int", defaultValue="0", flags=65537), @NiagaraProperty(name="publishOnChange", type="boolean", defaultValue="true"), @NiagaraProperty(name="ignoreEmptyMessages", type="boolean", defaultValue="false"), @NiagaraProperty(name="minPublishInterval", type="long", defaultValue="0", flags=4, facets={@Facet(value="BFacets.make( BFacets.UNITS, UnitDatabase.getUnit( \"millisecond\" ) )")}), @NiagaraProperty(name="statistics", type="BPublishStatistics", defaultValue="new BPublishStatistics()", flags=65541), @NiagaraProperty(name="summaryFormat", type="BFormat", defaultValue="BFormat.make( \"%topic%\" )", flags=4), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="debugDataEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="publish"), @NiagaraAction(name="reset")})
@NiagaraTopic(name="publishComplete", eventType="BBoolean")
public class BOssMqttPublisher
extends BComponent {
    public static final Property enabled = BOssMqttPublisher.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssMqttPublisher.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssMqttPublisher.newProperty((int)67, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property description = BOssMqttPublisher.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property topic = BOssMqttPublisher.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property qos = BOssMqttPublisher.newProperty((int)0, (BValue)BMqttQos.AtMostOnce, null);
    public static final Property messageIn = BOssMqttPublisher.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property retained = BOssMqttPublisher.newProperty((int)0, (boolean)false, null);
    public static final Property lastPublished = BOssMqttPublisher.newProperty((int)65545, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property messageSize = BOssMqttPublisher.newProperty((int)65537, (int)0, null);
    public static final Property publishOnChange = BOssMqttPublisher.newProperty((int)0, (boolean)true, null);
    public static final Property ignoreEmptyMessages = BOssMqttPublisher.newProperty((int)0, (boolean)false, null);
    public static final Property minPublishInterval = BOssMqttPublisher.newProperty((int)4, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property statistics = BOssMqttPublisher.newProperty((int)65541, (BValue)new BPublishStatistics(), null);
    public static final Property summaryFormat = BOssMqttPublisher.newProperty((int)4, (BValue)BFormat.make((String)"%topic%"), null);
    public static final Property debugEnabled = BOssMqttPublisher.newProperty((int)4, (boolean)false, null);
    public static final Property debugDataEnabled = BOssMqttPublisher.newProperty((int)4, (boolean)false, null);
    public static final Action publish = BOssMqttPublisher.newAction((int)0, null);
    public static final Action reset = BOssMqttPublisher.newAction((int)0, null);
    public static final Topic publishComplete = BOssMqttPublisher.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssMqttPublisher.class);
    private BOssMqttBroker broker = null;
    private final MqttMessageCallback callbackHandler = new MqttPublishCallbackHandler();
    private long lastPublishTime = 0L;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public String getTopic() {
        return this.getString(topic);
    }

    public void setTopic(String v) {
        this.setString(topic, v, null);
    }

    public BMqttQos getQos() {
        return (BMqttQos)this.get(qos);
    }

    public void setQos(BMqttQos v) {
        this.set(qos, (BValue)v, null);
    }

    public String getMessageIn() {
        return this.getString(messageIn);
    }

    public void setMessageIn(String v) {
        this.setString(messageIn, v, null);
    }

    public boolean getRetained() {
        return this.getBoolean(retained);
    }

    public void setRetained(boolean v) {
        this.setBoolean(retained, v, null);
    }

    public BAbsTime getLastPublished() {
        return (BAbsTime)this.get(lastPublished);
    }

    public void setLastPublished(BAbsTime v) {
        this.set(lastPublished, (BValue)v, null);
    }

    public int getMessageSize() {
        return this.getInt(messageSize);
    }

    public void setMessageSize(int v) {
        this.setInt(messageSize, v, null);
    }

    public boolean getPublishOnChange() {
        return this.getBoolean(publishOnChange);
    }

    public void setPublishOnChange(boolean v) {
        this.setBoolean(publishOnChange, v, null);
    }

    public boolean getIgnoreEmptyMessages() {
        return this.getBoolean(ignoreEmptyMessages);
    }

    public void setIgnoreEmptyMessages(boolean v) {
        this.setBoolean(ignoreEmptyMessages, v, null);
    }

    public long getMinPublishInterval() {
        return this.getLong(minPublishInterval);
    }

    public void setMinPublishInterval(long v) {
        this.setLong(minPublishInterval, v, null);
    }

    public BPublishStatistics getStatistics() {
        return (BPublishStatistics)this.get(statistics);
    }

    public void setStatistics(BPublishStatistics v) {
        this.set(statistics, (BValue)v, null);
    }

    public BFormat getSummaryFormat() {
        return (BFormat)this.get(summaryFormat);
    }

    public void setSummaryFormat(BFormat v) {
        this.set(summaryFormat, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public boolean getDebugDataEnabled() {
        return this.getBoolean(debugDataEnabled);
    }

    public void setDebugDataEnabled(boolean v) {
        this.setBoolean(debugDataEnabled, v, null);
    }

    public void publish() {
        this.invoke(publish, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void firePublishComplete(BBoolean event) {
        this.fire(publishComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.broker = BOssMqttBroker.findBroker(this);
        if (this.broker == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid parent");
            OssEasyMqttLog.error("MqttPublisher [" + this.getSlotPath() + "] should be placed in a MqttBroker");
            throw new BajaRuntimeException("Invalid parent");
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (this.broker == null) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.make((int)(this.getStatus().getBits() & 0xFFFFFFFE)));
            } else {
                this.setStatus(BStatus.make((int)(this.getStatus().getBits() | 1)));
            }
        } else if (property == messageIn && this.getPublishOnChange()) {
            this.publishMessage();
        }
    }

    public void doPublish() {
        this.publishMessage();
    }

    public void doReset() {
        this.setMessageIn("");
        this.setLastPublished(BAbsTime.NULL);
        this.setMessageSize(0);
    }

    public void publishMessage() {
        String messageText = this.getMessageIn();
        if (this.broker != null && this.getEnabled() && !(this.getIgnoreEmptyMessages() && messageText.isEmpty()) && System.currentTimeMillis() > this.lastPublishTime + this.getMinPublishInterval() && this.isPublishTopicValid(this.getTopic())) {
            MqttMessage publishMessage = new MqttMessage(messageText.getBytes());
            publishMessage.setQos(this.getQos().getOrdinal());
            publishMessage.setRetained(this.getRetained());
            this.broker.publish(this.getTopic(), publishMessage, this.callbackHandler);
            this.lastPublishTime = System.currentTimeMillis();
            int size = messageText.length();
            this.setMessageSize(size);
            if (this.broker.getConnected()) {
                this.getStatistics().newPublishMessage(publishMessage);
            }
            if (this.getDebugDataEnabled()) {
                OssEasyMqttLog.debug(this.getLogPrefix() + "Publish [" + this.getTopic() + "]: " + size + " bytes");
            }
        }
    }

    public boolean isPublishTopicValid(String topicStr) {
        if (topicStr.isEmpty()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid blank topic");
            OssEasyMqttLog.error(this.getLogPrefix() + "Publish has invalid blank topic");
            return false;
        }
        if (topicStr.matches(".*//.*")) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid null topic level");
            OssEasyMqttLog.error(this.getLogPrefix() + "Publish has invalid blank topic level");
            return false;
        }
        if (topicStr.matches(".*#.*")) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid topic wildcard (#)");
            OssEasyMqttLog.error(this.getLogPrefix() + "Publish has invalid use of topic multi-level wildcard (#)");
            return false;
        }
        if (topicStr.matches(".*\\+.*")) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid topic wildcard (+)");
            OssEasyMqttLog.error(this.getLogPrefix() + "Publish has invalid use of topic single-level wildcard (+)");
            return false;
        }
        return true;
    }

    public String getLogPrefix() {
        if (this.broker == null) {
            return "[null] ";
        }
        return "[" + this.broker.getName() + "] ";
    }

    public String toString(Context cxt) {
        return this.getSummaryFormat().format((Object)this);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/publisher.png");
    }

    private class MqttPublishCallbackHandler
    implements MqttMessageCallback {
        private MqttPublishCallbackHandler() {
        }

        @Override
        public void onSuccess() {
            BOssMqttPublisher.this.setStatus(BStatus.ok);
            BOssMqttPublisher.this.firePublishComplete(BBoolean.TRUE);
            BOssMqttPublisher.this.setFaultCause("");
            BOssMqttPublisher.this.setLastPublished(BAbsTime.now());
        }

        @Override
        public void onFailure(Throwable exception) {
            BOssMqttPublisher.this.setStatus(BStatus.makeFault((BStatus)BOssMqttPublisher.this.getStatus(), (boolean)true));
            BOssMqttPublisher.this.setFaultCause("Publish failed: " + exception.getCause());
            if (BOssMqttPublisher.this.getDebugEnabled()) {
                exception.printStackTrace();
            }
        }
    }
}

