/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import com.tridium.platcrypto.core.BCertManagerService;
import java.io.EOFException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.SocketFactory;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import solutions.onesight.ossEasyMqtt.license.OssEasyMqttLicense;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BBrokerAlarm;
import solutions.onesight.ossEasyMqtt.mqtt.BBrokerConnectionConfig;
import solutions.onesight.ossEasyMqtt.mqtt.BBrokerStatistics;
import solutions.onesight.ossEasyMqtt.mqtt.BLastWillAndTestament;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttFolder;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttPublisher;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttRouter;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttService;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttSubscriber;
import solutions.onesight.ossEasyMqtt.mqtt.EndpointExporter;
import solutions.onesight.ossEasyMqtt.mqtt.EndpointImporter;
import solutions.onesight.ossEasyMqtt.mqtt.MqttConnectionTask;
import solutions.onesight.ossEasyMqtt.mqtt.MqttMessageCallback;
import solutions.onesight.ossEasyMqtt.mqtt.MqttPublisherTask;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="alarm", type="BBrokerAlarm", defaultValue="new BBrokerAlarm()"), @NiagaraProperty(name="currentState", type="String", defaultValue="Idle", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="connected", type="boolean", defaultValue="false", flags=67), @NiagaraProperty(name="lastConnectTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastDisconnectTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="description", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="connection", type="BBrokerConnectionConfig", defaultValue="new BBrokerConnectionConfig()", flags=1), @NiagaraProperty(name="enableLWT", type="boolean", defaultValue="false"), @NiagaraProperty(name="LWT", type="BLastWillAndTestament", defaultValue="new BLastWillAndTestament()", flags=5), @NiagaraProperty(name="statistics", type="BBrokerStatistics", defaultValue="new BBrokerStatistics()", flags=5), @NiagaraProperty(name="publishQueueSize", type="int", defaultValue="5000", flags=4), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="connect"), @NiagaraAction(name="disconnect"), @NiagaraAction(name="addFolder"), @NiagaraAction(name="addSubscriber"), @NiagaraAction(name="addPublisher"), @NiagaraAction(name="addRouter"), @NiagaraAction(name="importEndpoints", parameterType="BOrd", defaultValue="BOrd.NULL", flags=4), @NiagaraAction(name="exportEndpoints", flags=4)})
public class BOssMqttBroker
extends BComponent {
    public static final Property enabled = BOssMqttBroker.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssMqttBroker.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssMqttBroker.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property alarm = BOssMqttBroker.newProperty((int)0, (BValue)new BBrokerAlarm(), null);
    public static final Property currentState = BOssMqttBroker.newProperty((int)67, (String)"Idle", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property connected = BOssMqttBroker.newProperty((int)67, (boolean)false, null);
    public static final Property lastConnectTime = BOssMqttBroker.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastDisconnectTime = BOssMqttBroker.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property description = BOssMqttBroker.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property connection = BOssMqttBroker.newProperty((int)1, (BValue)new BBrokerConnectionConfig(), null);
    public static final Property enableLWT = BOssMqttBroker.newProperty((int)0, (boolean)false, null);
    public static final Property LWT = BOssMqttBroker.newProperty((int)5, (BValue)new BLastWillAndTestament(), null);
    public static final Property statistics = BOssMqttBroker.newProperty((int)5, (BValue)new BBrokerStatistics(), null);
    public static final Property publishQueueSize = BOssMqttBroker.newProperty((int)4, (int)5000, null);
    public static final Property debugEnabled = BOssMqttBroker.newProperty((int)4, (boolean)false, null);
    public static final Action connect = BOssMqttBroker.newAction((int)0, null);
    public static final Action disconnect = BOssMqttBroker.newAction((int)0, null);
    public static final Action addFolder = BOssMqttBroker.newAction((int)0, null);
    public static final Action addSubscriber = BOssMqttBroker.newAction((int)0, null);
    public static final Action addPublisher = BOssMqttBroker.newAction((int)0, null);
    public static final Action addRouter = BOssMqttBroker.newAction((int)0, null);
    public static final Action importEndpoints = BOssMqttBroker.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action exportEndpoints = BOssMqttBroker.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOssMqttBroker.class);
    private boolean serviceValid = false;
    private MqttAsyncClient client = null;
    private final MqttConnectionCallbackHandler callbackHandler = new MqttConnectionCallbackHandler();
    private boolean brokerLicenseLimitExceeded = false;
    private MqttConnectionTask connectionTask;
    private MqttPublisherTask publisherTask;
    private static int brokerCount = 0;
    private static final Logger log = OssEasyMqttLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BBrokerAlarm getAlarm() {
        return (BBrokerAlarm)this.get(alarm);
    }

    public void setAlarm(BBrokerAlarm v) {
        this.set(alarm, (BValue)v, null);
    }

    public String getCurrentState() {
        return this.getString(currentState);
    }

    public void setCurrentState(String v) {
        this.setString(currentState, v, null);
    }

    public boolean getConnected() {
        return this.getBoolean(connected);
    }

    public void setConnected(boolean v) {
        this.setBoolean(connected, v, null);
    }

    public BAbsTime getLastConnectTime() {
        return (BAbsTime)this.get(lastConnectTime);
    }

    public void setLastConnectTime(BAbsTime v) {
        this.set(lastConnectTime, (BValue)v, null);
    }

    public BAbsTime getLastDisconnectTime() {
        return (BAbsTime)this.get(lastDisconnectTime);
    }

    public void setLastDisconnectTime(BAbsTime v) {
        this.set(lastDisconnectTime, (BValue)v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BBrokerConnectionConfig getConnection() {
        return (BBrokerConnectionConfig)this.get(connection);
    }

    public void setConnection(BBrokerConnectionConfig v) {
        this.set(connection, (BValue)v, null);
    }

    public boolean getEnableLWT() {
        return this.getBoolean(enableLWT);
    }

    public void setEnableLWT(boolean v) {
        this.setBoolean(enableLWT, v, null);
    }

    public BLastWillAndTestament getLWT() {
        return (BLastWillAndTestament)this.get(LWT);
    }

    public void setLWT(BLastWillAndTestament v) {
        this.set(LWT, (BValue)v, null);
    }

    public BBrokerStatistics getStatistics() {
        return (BBrokerStatistics)this.get(statistics);
    }

    public void setStatistics(BBrokerStatistics v) {
        this.set(statistics, (BValue)v, null);
    }

    public int getPublishQueueSize() {
        return this.getInt(publishQueueSize);
    }

    public void setPublishQueueSize(int v) {
        this.setInt(publishQueueSize, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void addFolder() {
        this.invoke(addFolder, null, null);
    }

    public void addSubscriber() {
        this.invoke(addSubscriber, null, null);
    }

    public void addPublisher() {
        this.invoke(addPublisher, null, null);
    }

    public void addRouter() {
        this.invoke(addRouter, null, null);
    }

    public void importEndpoints(BOrd parameter) {
        this.invoke(importEndpoints, (BValue)parameter, null);
    }

    public void exportEndpoints() {
        this.invoke(exportEndpoints, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.serviceValid = false;
        this.brokerLicenseLimitExceeded = false;
        ++brokerCount;
        this.connectionTask = null;
        this.publisherTask = null;
        this.getAlarm().setSource(this);
        if (!OssEasyMqttLicense.isLicensed()) {
            log.severe(this.getLogPrefix() + "ossEasyMqtt is not licensed");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("ossEasyMqtt is not licensed");
            this.setCurrentState("ossEasyMqtt is not licensed");
            return;
        }
        if (!(this.getParent() instanceof BOssMqttService)) {
            log.severe(this.getLogPrefix() + "Broker should be placed in a OssMqttService");
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid parent");
            this.setCurrentState("Invalid parent");
            throw new BajaRuntimeException("Invalid MqttBroker parent");
        }
        this.serviceValid = ((BOssMqttService)this.getParent()).isServiceValid();
        if (!this.serviceValid) {
            log.severe(this.getLogPrefix() + "Broker parent service is invalid");
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid service");
            this.setCurrentState("Invalid service");
            return;
        }
        if (!OssEasyMqttLicense.getBrokerUnlimited() && brokerCount > OssEasyMqttLicense.getBrokerLimit()) {
            this.brokerLicenseLimitExceeded = true;
            log.severe(this.getLogPrefix() + "Broker license limit exceeded");
            this.setStatus(BStatus.fault);
            this.setFaultCause("Broker license limit exceeded");
            this.setCurrentState("Broker license limit exceeded");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
        this.setCurrentState("Idle");
    }

    public void stopped() {
        --brokerCount;
        this.brokerDisconnect();
        this.stopPublisherTask();
        this.stopConnectionTask();
        if (this.client != null) {
            try {
                this.client.close(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client = null;
        }
    }

    public void atSteadyState() {
        if (this.getEnabled() && this.getConnection().configValid() && this.getConnection().getConnectAtStartup()) {
            this.brokerConnect();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                if (this.getConnection().configValid()) {
                    this.brokerConnect();
                }
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.brokerDisconnect();
            }
        } else if (property == enableLWT) {
            if (this.getEnableLWT()) {
                this.setFlags((Slot)LWT, 0);
            } else {
                this.setFlags((Slot)LWT, 4);
            }
        }
    }

    public void doConnect() {
        this.brokerConnect();
    }

    public void doDisconnect() {
        this.brokerDisconnect();
    }

    public void doAddFolder() {
        this.add("Folder1?", (BValue)new BOssMqttFolder());
    }

    public void doAddSubscriber() {
        this.add("Subscriber1?", (BValue)new BOssMqttSubscriber());
    }

    public void doAddPublisher() {
        this.add("Publisher1?", (BValue)new BOssMqttPublisher());
    }

    public void doAddRouter() {
        this.add("MqttRouter?", (BValue)new BOssMqttRouter());
    }

    public void doImportEndpoints(BOrd importFile) {
        EndpointImporter exporter = new EndpointImporter(this);
        exporter.read(importFile);
    }

    public void doExportEndpoints() {
        EndpointExporter exporter = new EndpointExporter(this);
        exporter.write();
    }

    public static BOssMqttBroker findBroker(BComponent descendant) {
        BComponent parent = (BComponent)descendant.getParent();
        if (parent instanceof BOssMqttBroker) {
            return (BOssMqttBroker)parent;
        }
        if (parent == null) {
            return null;
        }
        return BOssMqttBroker.findBroker(parent);
    }

    public void brokerConnect() {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        if (this.client != null && !this.client.isConnected()) {
            try {
                this.client.close(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client = null;
        }
        if (this.client == null || !this.client.isConnected()) {
            if (!OssEasyMqttLicense.isLicensed()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("ossEasyMqtt is not licensed");
                this.setCurrentState("ossEasyMqtt is not licensed");
                log.severe(this.getLogPrefix() + "Cannot connect, ossEasyMqtt is not licensed");
                this.getAlarm().dispatch(BSourceState.fault);
                return;
            }
            if (!this.serviceValid) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("Invalid service");
                this.setCurrentState("Invalid service");
                log.severe(this.getLogPrefix() + "Cannot connect, service is invalid");
                return;
            }
            if (this.brokerLicenseLimitExceeded) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("Broker license limit exceeded");
                this.setCurrentState("Broker license limit exceeded");
                log.severe(this.getLogPrefix() + "Cannot connect, broker license limit exceeded");
                this.getAlarm().dispatch(BSourceState.fault);
                return;
            }
            if (this.getConnection().getBrokerHost().isEmpty()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("Invalid empty broker host");
                this.setCurrentState("Disconnected");
                log.severe(this.getLogPrefix() + "Cannot connect, invalid empty broker host");
                return;
            }
            if (this.getConnection().getBrokerPort() < 1 || this.getConnection().getBrokerPort() > 65534) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("Invalid broker port");
                this.setCurrentState("Disconnected");
                log.severe(this.getLogPrefix() + "Cannot connect, invalid broker port: " + this.getConnection().getBrokerPort());
                return;
            }
            this.setFaultCause("");
            this.setCurrentState("Connecting");
            if (this.getConnection().getConnectionDebug()) {
                log.finest(this.getLogPrefix() + "Setting up connection");
            }
            try {
                String protocol;
                MqttConnectOptions conOpt = new MqttConnectOptions();
                conOpt.setCleanSession(this.getConnection().getCleanSession());
                conOpt.setAutomaticReconnect(true);
                conOpt.setConnectionTimeout(this.getConnection().getConnectTimeout());
                conOpt.setKeepAliveInterval(this.getConnection().getKeepAliveInterval());
                conOpt.setMaxInflight(this.getConnection().getMaxInflight());
                int securityType = this.getConnection().getSecurity().getOrdinal();
                switch (securityType) {
                    case 1: 
                    case 3: {
                        ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                        if (cryptoManager instanceof BCertManagerService) {
                            BCertManagerService certManagerService = (BCertManagerService)cryptoManager;
                            SocketFactory socketFactory = certManagerService.getClientSocketFactory(ClientTlsParameters.DEFAULT);
                            conOpt.setSocketFactory(socketFactory);
                        }
                    }
                    case 4: 
                    case 5: {
                        protocol = "ssl";
                        break;
                    }
                    case 6: 
                    case 7: {
                        BCertManagerService certService = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
                        ClientTlsParameters clientTlsParameters = new ClientTlsParameters("tlsv1.2", this.getConnection().getCertificateAlias());
                        conOpt.setSocketFactory(certService.getClientSocketFactory(clientTlsParameters));
                        protocol = "ssl";
                        break;
                    }
                    default: {
                        protocol = "tcp";
                    }
                }
                switch (securityType) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: {
                        String username = this.getConnection().getLogin().getUsername();
                        String password = AccessController.doPrivileged(new PrivilegedAction<String>(){

                            @Override
                            public String run() {
                                return BOssMqttBroker.this.getConnection().getLogin().getPassword().getValue();
                            }
                        });
                        if (username.isEmpty()) {
                            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                            this.setFaultCause("Connect failed, username empty");
                            this.setCurrentState("Disconnected");
                            log.severe(this.getLogPrefix() + "Username is empty");
                            return;
                        }
                        if (password.isEmpty()) {
                            log.warning(this.getLogPrefix() + "Password is empty");
                        }
                        conOpt.setUserName(username);
                        conOpt.setPassword(password.toCharArray());
                    }
                }
                switch (securityType) {
                    case 4: 
                    case 5: {
                        SSLSocketFactory creds = this.getConnection().getCertificate().getSocketFactory();
                        if (creds == null) {
                            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                            this.setFaultCause("Connect failed, certificates invalid");
                            this.setCurrentState("Disconnected");
                            log.severe(this.getLogPrefix() + "Connect failed, certificates invalid");
                            return;
                        }
                        conOpt.setSocketFactory(creds);
                    }
                }
                if (this.getEnableLWT()) {
                    conOpt.setWill(this.getLWT().getTopic(), this.getLWT().getMessage().getBytes(), this.getLWT().getQos().getOrdinal(), this.getLWT().getRetained());
                }
                String conSpec = protocol + "://" + this.getConnection().getBrokerHost() + ":" + this.getConnection().getBrokerPort();
                this.client = new MqttAsyncClient(conSpec, this.getConnection().getClientIdentifier(), new MemoryPersistence());
                this.callbackHandler.setClient(this.client);
                this.client.setCallback(this.callbackHandler);
                if (this.getConnection().getConnectionDebug()) {
                    OssEasyMqttLog.info(this.getLogPrefix() + "Connecting to '" + this.getConnection().getBrokerHost() + "': " + this.getConnection().getBrokerPort());
                }
                this.client.connect(conOpt, null, this.callbackHandler);
                this.setCurrentState("Connection pending");
                this.getStatistics().update();
            }
            catch (Exception mqttException) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause("Connect failed: " + mqttException);
                this.setCurrentState("Disconnected");
                log.severe(this.getLogPrefix() + "Broker connect exception: " + mqttException);
                this.getAlarm().dispatch(BSourceState.fault);
                mqttException.printStackTrace();
                try {
                    this.client.close(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stopPublisherTask();
                this.stopConnectionTask();
                this.client = null;
            }
        } else if (this.getConnection().getConnectionDebug()) {
            log.fine(this.getLogPrefix() + "Broker already connected");
        }
    }

    public void brokerDisconnect() {
        if (this.getConnected()) {
            this.setLastDisconnectTime(BAbsTime.now());
        }
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
        this.setConnected(false);
        this.setCurrentState("Disconnected");
        this.stopPublisherTask();
        this.stopConnectionTask();
        this.client = null;
    }

    public synchronized void startConnectionTask() {
        if (this.connectionTask == null || !this.connectionTask.isAlive()) {
            this.connectionTask = new MqttConnectionTask(this);
            this.connectionTask.start();
        }
    }

    public synchronized void stopConnectionTask() {
        if (this.connectionTask != null) {
            this.connectionTask.disconnect();
            this.connectionTask = null;
        }
    }

    public synchronized void startPublisherTask() {
        if (this.publisherTask == null || !this.publisherTask.isAlive()) {
            this.publisherTask = new MqttPublisherTask(this);
            this.publisherTask.start();
        }
    }

    public synchronized void stopPublisherTask() {
        if (this.publisherTask != null) {
            this.publisherTask.terminate();
            this.publisherTask = null;
        }
    }

    public void publish(String topic, byte[] messagePayload, int messageQos, boolean messageRetained, MqttMessageCallback callback) {
        if (this.publisherTask != null && topic != null && messagePayload != null) {
            MqttMessage publishMessage = new MqttMessage(messagePayload);
            publishMessage.setQos(messageQos);
            publishMessage.setRetained(messageRetained);
            this.publish(topic, publishMessage, callback);
        }
    }

    public void publish(String topic, MqttMessage message, MqttMessageCallback callback) {
        if (this.client != null && this.publisherTask != null) {
            this.publisherTask.publish(topic, message, callback);
        }
    }

    public IMqttToken subscribe(String topic, int qos, IMqttActionListener callback, IMqttMessageListener listener) {
        IMqttToken subscribeToken = null;
        try {
            if (this.client != null && this.client.isConnected()) {
                subscribeToken = this.client.subscribe(topic, qos, null, callback, listener);
                if (this.getDebugEnabled()) {
                    log.finer(this.getLogPrefix() + "Subscribe: " + topic);
                }
            }
        }
        catch (Exception mqttException) {
            log.severe(this.getLogPrefix() + "Subscribe exception: " + mqttException);
            mqttException.printStackTrace();
        }
        return subscribeToken;
    }

    public void unsubscribe(String topic) {
        try {
            if (this.client != null && this.client.isConnected()) {
                this.client.unsubscribe(topic);
                if (this.getDebugEnabled()) {
                    log.finer(this.getLogPrefix() + "Unsubscribe: " + topic);
                }
            }
        }
        catch (Exception mqttException) {
            log.severe(this.getLogPrefix() + "Unsubscribe exception: " + mqttException);
            mqttException.printStackTrace();
        }
    }

    public void newSubscribeMessage(String topic, MqttMessage message) {
        this.getStatistics().newSubscribeMessage(message);
    }

    public MqttAsyncClient getMqttClient() {
        return this.client;
    }

    public void droppedRxMessage() {
        this.getStatistics().incrementRxDropCount();
    }

    public String getLogPrefix() {
        return "[" + this.getName() + "] ";
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/broker.png");
    }

    private class MqttConnectionCallbackHandler
    implements IMqttActionListener,
    MqttCallbackExtended {
        private MqttAsyncClient localClient;

        private MqttConnectionCallbackHandler() {
        }

        public void setClient(MqttAsyncClient newClient) {
            this.localClient = newClient;
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            String causeText;
            BOssMqttBroker.this.setStatus(BStatus.makeFault((BStatus)BOssMqttBroker.this.getStatus(), (boolean)true));
            BOssMqttBroker.this.setCurrentState("Disconnected");
            BOssMqttBroker.this.setConnected(false);
            String errorText = causeText = "Connect failure";
            Throwable causeException = exception.getCause();
            if (causeException == null) {
                errorText = causeText = "Connect failed: " + exception.getMessage();
            } else if (causeException instanceof UnknownHostException) {
                causeText = "Connect failed: Unknown Host";
                errorText = "Connect failed: Unknown Host: " + BOssMqttBroker.this.getConnection().getBrokerHost();
            } else if (causeException instanceof SSLHandshakeException) {
                errorText = causeText = "Connect failed: SSLHandshakeException: " + causeException.getMessage();
            } else if (causeException instanceof SocketException) {
                errorText = causeText = "Connect failed: SocketException: " + causeException.getMessage();
            } else if (causeException instanceof EOFException) {
                errorText = causeText = "Connection failed: EOF";
            } else {
                causeText = causeException.getMessage() != null ? "Connect failed: " + causeException.getMessage() : "Connect failed: " + exception.getMessage();
                errorText = causeText;
            }
            BOssMqttBroker.this.setFaultCause(causeText);
            log.severe(BOssMqttBroker.this.getLogPrefix() + errorText);
            BOssMqttBroker.this.getAlarm().dispatch(BSourceState.fault);
            BOssMqttBroker.this.stopPublisherTask();
            BOssMqttBroker.this.stopConnectionTask();
            BOssMqttBroker.this.client = null;
        }

        @Override
        public void connectComplete(boolean reconnect, String serverURI) {
            if (BOssMqttBroker.this.client != null) {
                boolean previousFault = BOssMqttBroker.this.getStatus().isFault();
                BOssMqttBroker.this.setStatus(BStatus.ok);
                BOssMqttBroker.this.setFaultCause("");
                BOssMqttBroker.this.setConnected(true);
                BOssMqttBroker.this.setCurrentState("Connected");
                BOssMqttBroker.this.setLastConnectTime(BAbsTime.now());
                if (BOssMqttBroker.this.getConnection().getConnectionDebug()) {
                    OssEasyMqttLog.info(BOssMqttBroker.this.getLogPrefix() + "Connected");
                }
                BOssMqttBroker.this.startPublisherTask();
                if (BOssMqttBroker.this.connectionTask == null || !BOssMqttBroker.this.connectionTask.isAlive()) {
                    BOssMqttBroker.this.connectionTask = new MqttConnectionTask(BOssMqttBroker.this);
                    BOssMqttBroker.this.connectionTask.start();
                } else {
                    try {
                        if (BOssMqttBroker.this.getConnection().getConnectionDebug()) {
                            OssEasyMqttLog.info(BOssMqttBroker.this.getLogPrefix() + "Restarting all subscriptions");
                        }
                        BOssMqttBroker.this.connectionTask.startSubscribers(BOssMqttBroker.this);
                    }
                    catch (Exception startException) {
                        log.severe(BOssMqttBroker.this.getLogPrefix() + "Exception starting subscribers: " + startException);
                        startException.printStackTrace();
                    }
                }
                if (previousFault) {
                    BOssMqttBroker.this.getAlarm().dispatch(BSourceState.normal);
                }
                if (BOssMqttBroker.this.getStatistics().getStartTime().isNull()) {
                    BOssMqttBroker.this.getStatistics().setStartTime(BAbsTime.now());
                }
            } else {
                log.finest(BOssMqttBroker.this.getLogPrefix() + "Invalid connect complete");
                if (this.localClient != null) {
                    try {
                        this.localClient.close(true);
                    }
                    catch (Exception mqttException) {
                        log.finest(BOssMqttBroker.this.getLogPrefix() + "Invalid connect complete exception: " + mqttException);
                        mqttException.printStackTrace();
                    }
                    this.localClient = null;
                }
                throw new RuntimeException("Invalid MQTT connection state");
            }
        }

        @Override
        public void connectionLost(Throwable cause) {
            if (BOssMqttBroker.this.client != null) {
                BOssMqttBroker.this.setStatus(BStatus.make((int)(BOssMqttBroker.this.getStatus().getBits() | 4 | 2)));
                BOssMqttBroker.this.setFaultCause(cause.getMessage());
                BOssMqttBroker.this.setCurrentState("Disconnected");
                BOssMqttBroker.this.setLastDisconnectTime(BAbsTime.now());
                if (BOssMqttBroker.this.getConnected()) {
                    log.severe(BOssMqttBroker.this.getLogPrefix() + "Connection lost: " + cause.getMessage());
                    BOssMqttBroker.this.getAlarm().dispatch(BSourceState.fault);
                }
            } else {
                log.finest(BOssMqttBroker.this.getLogPrefix() + "Invalid connect drop: " + cause);
                if (this.localClient != null) {
                    try {
                        this.localClient.close(true);
                    }
                    catch (Exception mqttException) {
                        log.finest(BOssMqttBroker.this.getLogPrefix() + "Invalid connect drop exception: " + mqttException);
                        mqttException.printStackTrace();
                    }
                    this.localClient = null;
                }
                throw new RuntimeException("Invalid MQTT connection state");
            }
            BOssMqttBroker.this.setConnected(false);
            BOssMqttBroker.this.stopPublisherTask();
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) {
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    }
}

