/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.security.AccessController;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.nullStatus", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="CACertificateValid", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="clientCertificateValid", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="clientPrivateKeyValid", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="CACertificateStore", type="baja:Password", defaultValue="BPassword.DEFAULT", flags=69), @NiagaraProperty(name="clientCertificateStore", type="baja:Password", defaultValue="BPassword.DEFAULT", flags=69), @NiagaraProperty(name="clientPrivateKeyStore", type="baja:Password", defaultValue="BPassword.DEFAULT", flags=69)})
@NiagaraAction(name="checkCertificates")
public class BClientCertificate
extends BComponent {
    public static final Property status = BClientCertificate.newProperty((int)73, (BValue)BStatus.nullStatus, null);
    public static final Property faultCause = BClientCertificate.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property CACertificateValid = BClientCertificate.newProperty((int)65, (boolean)false, null);
    public static final Property clientCertificateValid = BClientCertificate.newProperty((int)65, (boolean)false, null);
    public static final Property clientPrivateKeyValid = BClientCertificate.newProperty((int)65, (boolean)false, null);
    public static final Property CACertificateStore = BClientCertificate.newProperty((int)69, (BValue)BPassword.DEFAULT, null);
    public static final Property clientCertificateStore = BClientCertificate.newProperty((int)69, (BValue)BPassword.DEFAULT, null);
    public static final Property clientPrivateKeyStore = BClientCertificate.newProperty((int)69, (BValue)BPassword.DEFAULT, null);
    public static final Action checkCertificates = BClientCertificate.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BClientCertificate.class);

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getCACertificateValid() {
        return this.getBoolean(CACertificateValid);
    }

    public void setCACertificateValid(boolean v) {
        this.setBoolean(CACertificateValid, v, null);
    }

    public boolean getClientCertificateValid() {
        return this.getBoolean(clientCertificateValid);
    }

    public void setClientCertificateValid(boolean v) {
        this.setBoolean(clientCertificateValid, v, null);
    }

    public boolean getClientPrivateKeyValid() {
        return this.getBoolean(clientPrivateKeyValid);
    }

    public void setClientPrivateKeyValid(boolean v) {
        this.setBoolean(clientPrivateKeyValid, v, null);
    }

    public BPassword getCACertificateStore() {
        return (BPassword)this.get(CACertificateStore);
    }

    public void setCACertificateStore(BPassword v) {
        this.set(CACertificateStore, (BValue)v, null);
    }

    public BPassword getClientCertificateStore() {
        return (BPassword)this.get(clientCertificateStore);
    }

    public void setClientCertificateStore(BPassword v) {
        this.set(clientCertificateStore, (BValue)v, null);
    }

    public BPassword getClientPrivateKeyStore() {
        return (BPassword)this.get(clientPrivateKeyStore);
    }

    public void setClientPrivateKeyStore(BPassword v) {
        this.set(clientPrivateKeyStore, (BValue)v, null);
    }

    public void checkCertificates() {
        this.invoke(checkCertificates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static Certificate extractCertificate(String certText) {
        Certificate certObj = null;
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(certText.getBytes()));
            if (bis.available() > 0) {
                certObj = certFactory.generateCertificate(bis);
            }
        }
        catch (Exception certException) {
            OssEasyMqttLog.error("Certificate exception: " + certException.getMessage());
        }
        return certObj;
    }

    public static KeyPair extractKey(String keyText, String password) {
        KeyPair keyObj = null;
        try {
            PEMParser pemParser = new PEMParser(new StringReader(keyText));
            Object pemObject = pemParser.readObject();
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (pemObject instanceof PEMEncryptedKeyPair) {
                keyObj = converter.getKeyPair(((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decProv));
            } else if (pemObject instanceof PEMKeyPair) {
                keyObj = converter.getKeyPair((PEMKeyPair)pemObject);
            } else if (pemObject instanceof PrivateKeyInfo) {
                PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)pemObject);
                keyObj = new KeyPair(null, privateKey);
            } else if (pemObject instanceof X509CertificateHolder) {
                OssEasyMqttLog.error("Private key invalid: certificate provided instead of key");
            }
            pemParser.close();
        }
        catch (Exception keyException) {
            OssEasyMqttLog.error("Private key exception: " + keyException.getMessage());
        }
        return keyObj;
    }

    public SSLSocketFactory getSocketFactory() {
        Certificate caCert = null;
        Certificate clientCert = null;
        KeyPair clientKey = null;
        String passwordText = "";
        SSLSocketFactory result = null;
        this.setStatus(BStatus.stale);
        this.setCACertificateValid(false);
        this.setClientCertificateValid(false);
        this.setClientPrivateKeyValid(false);
        try {
            String caCertText = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    if (BClientCertificate.this.getCACertificateStore().isDefault()) {
                        return null;
                    }
                    return BClientCertificate.this.getCACertificateStore().getValue();
                }
            });
            if (caCertText == null || caCertText.isEmpty()) {
                OssEasyMqttLog.error(this.getLogPrefix() + "CA certificate blank");
            } else {
                caCert = BClientCertificate.extractCertificate(caCertText);
                if (caCert != null) {
                    this.setCACertificateValid(true);
                } else {
                    OssEasyMqttLog.error(this.getLogPrefix() + "CA certificate invalid");
                }
            }
            String clientCertText = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    if (BClientCertificate.this.getClientCertificateStore().isDefault()) {
                        return null;
                    }
                    return BClientCertificate.this.getClientCertificateStore().getValue();
                }
            });
            if (clientCertText == null || clientCertText.isEmpty()) {
                OssEasyMqttLog.error(this.getLogPrefix() + "Client certificate blank");
            } else {
                clientCert = BClientCertificate.extractCertificate(clientCertText);
                if (clientCert != null) {
                    this.setClientCertificateValid(true);
                } else {
                    OssEasyMqttLog.error(this.getLogPrefix() + "Client certificate invalid");
                }
            }
            String clientKeyText = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    if (BClientCertificate.this.getClientPrivateKeyStore().isDefault()) {
                        return null;
                    }
                    return BClientCertificate.this.getClientPrivateKeyStore().getValue();
                }
            });
            if (clientKeyText == null || clientKeyText.isEmpty()) {
                OssEasyMqttLog.error(this.getLogPrefix() + "Client private key blank");
            } else {
                clientKey = BClientCertificate.extractKey(clientKeyText, passwordText);
                if (clientKey != null) {
                    this.setClientPrivateKeyValid(true);
                } else {
                    OssEasyMqttLog.error(this.getLogPrefix() + "Client private key invalid");
                }
            }
            if (caCert != null && clientCert != null && clientKey != null) {
                result = this.getSocketFactory(caCert, clientCert, clientKey, passwordText);
            }
        }
        catch (Exception certificateException) {
            OssEasyMqttLog.error(this.getLogPrefix() + "Certificate Exception: " + certificateException);
            certificateException.printStackTrace();
        }
        if (result == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Certificates invalid");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        return result;
    }

    private SSLSocketFactory getSocketFactory(Certificate caCert, Certificate clientCert, KeyPair clientKey, String passwordText) {
        SSLSocketFactory result = null;
        try {
            KeyStore caKs = KeyStore.getInstance(KeyStore.getDefaultType());
            caKs.load(null, null);
            caKs.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(caKs);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            ks.setCertificateEntry("certificate", clientCert);
            ks.setKeyEntry("private-key", clientKey.getPrivate(), passwordText.toCharArray(), new Certificate[]{clientCert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, passwordText.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            result = context.getSocketFactory();
        }
        catch (Exception tlsException) {
            OssEasyMqttLog.error(this.getLogPrefix() + "TLS Exception: " + tlsException);
            tlsException.printStackTrace();
        }
        return result;
    }

    public void doCheckCertificates() {
        this.getSocketFactory();
        if (this.getCACertificateValid()) {
            OssEasyMqttLog.debug(this.getLogPrefix() + "CA certificate OK");
        }
        if (this.getClientCertificateValid()) {
            OssEasyMqttLog.debug(this.getLogPrefix() + "Client certificate OK");
        }
        if (this.getClientPrivateKeyValid()) {
            OssEasyMqttLog.debug(this.getLogPrefix() + "Client private key OK");
        }
    }

    public String getLogPrefix() {
        return "[" + this.getParent().getParent().getName() + "] ";
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/certificate.png");
    }
}

