/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="startTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastPublishTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="publishMessageCount", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")}), @NiagaraProperty(name="publishMessageRate", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"messageRate\", \"messages/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="publishTotalBytes", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="publishDataRate", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"dataRate\", \"bytes/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="publishMinSize", type="long", defaultValue="-1", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="publishMaxSize", type="long", defaultValue="0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="lastReceiveTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="receiveMessageCount", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")}), @NiagaraProperty(name="receiveMessageRate", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"messageRate\", \"messages/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="receiveTotalBytes", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="receiveDataRate", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"dataRate\", \"bytes/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="receiveMinSize", type="long", defaultValue="-1", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="receiveMaxSize", type="long", defaultValue="0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="maxPublishQueueSize", type="long", defaultValue="0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)")}), @NiagaraProperty(name="rxDropCount", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")}), @NiagaraProperty(name="txDropCount", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")}), @NiagaraProperty(name="txFailCount", type="double", defaultValue="0.0", flags=65541, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")})})
@NiagaraAction(name="reset")
public class BBrokerStatistics
extends BComponent {
    public static final Property startTime = BBrokerStatistics.newProperty((int)65537, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastPublishTime = BBrokerStatistics.newProperty((int)65537, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property publishMessageCount = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Property publishMessageRate = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"messageRate", (String)"messages/second", (BDimension)BDimension.NULL))));
    public static final Property publishTotalBytes = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property publishDataRate = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"dataRate", (String)"bytes/second", (BDimension)BDimension.NULL))));
    public static final Property publishMinSize = BBrokerStatistics.newProperty((int)65541, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property publishMaxSize = BBrokerStatistics.newProperty((int)65541, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property lastReceiveTime = BBrokerStatistics.newProperty((int)65537, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property receiveMessageCount = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Property receiveMessageRate = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"messageRate", (String)"messages/second", (BDimension)BDimension.NULL))));
    public static final Property receiveTotalBytes = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property receiveDataRate = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"dataRate", (String)"bytes/second", (BDimension)BDimension.NULL))));
    public static final Property receiveMinSize = BBrokerStatistics.newProperty((int)65541, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property receiveMaxSize = BBrokerStatistics.newProperty((int)65541, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property maxPublishQueueSize = BBrokerStatistics.newProperty((int)65541, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)));
    public static final Property rxDropCount = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Property txDropCount = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Property txFailCount = BBrokerStatistics.newProperty((int)65541, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Action reset = BBrokerStatistics.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BBrokerStatistics.class);
    private long latestPublishTime = 0L;
    private long latestPublishMessageCount = 0L;
    private double latestPublishTotalBytes = 0.0;
    private long latestPublishMinSize = -1L;
    private long latestPublishMaxSize = 0L;
    private long latestReceiveTime = 0L;
    private long latestReceiveMessageCount = 0L;
    private double latestReceiveTotalBytes = 0.0;
    private long latestReceiveMinSize = -1L;
    private long latestReceiveMaxSize = 0L;
    private long latestMaxPublishQueueSize = 0L;
    private long latestTxDropCount = 0L;
    private long latestTxFailCount = 0L;
    private long latestRxDropCount = 0L;
    private boolean publishUpdated = false;
    private boolean receiveUpdated = false;
    private boolean publishShown = false;
    private boolean receiveShown = false;

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getLastPublishTime() {
        return (BAbsTime)this.get(lastPublishTime);
    }

    public void setLastPublishTime(BAbsTime v) {
        this.set(lastPublishTime, (BValue)v, null);
    }

    public double getPublishMessageCount() {
        return this.getDouble(publishMessageCount);
    }

    public void setPublishMessageCount(double v) {
        this.setDouble(publishMessageCount, v, null);
    }

    public double getPublishMessageRate() {
        return this.getDouble(publishMessageRate);
    }

    public void setPublishMessageRate(double v) {
        this.setDouble(publishMessageRate, v, null);
    }

    public double getPublishTotalBytes() {
        return this.getDouble(publishTotalBytes);
    }

    public void setPublishTotalBytes(double v) {
        this.setDouble(publishTotalBytes, v, null);
    }

    public double getPublishDataRate() {
        return this.getDouble(publishDataRate);
    }

    public void setPublishDataRate(double v) {
        this.setDouble(publishDataRate, v, null);
    }

    public long getPublishMinSize() {
        return this.getLong(publishMinSize);
    }

    public void setPublishMinSize(long v) {
        this.setLong(publishMinSize, v, null);
    }

    public long getPublishMaxSize() {
        return this.getLong(publishMaxSize);
    }

    public void setPublishMaxSize(long v) {
        this.setLong(publishMaxSize, v, null);
    }

    public BAbsTime getLastReceiveTime() {
        return (BAbsTime)this.get(lastReceiveTime);
    }

    public void setLastReceiveTime(BAbsTime v) {
        this.set(lastReceiveTime, (BValue)v, null);
    }

    public double getReceiveMessageCount() {
        return this.getDouble(receiveMessageCount);
    }

    public void setReceiveMessageCount(double v) {
        this.setDouble(receiveMessageCount, v, null);
    }

    public double getReceiveMessageRate() {
        return this.getDouble(receiveMessageRate);
    }

    public void setReceiveMessageRate(double v) {
        this.setDouble(receiveMessageRate, v, null);
    }

    public double getReceiveTotalBytes() {
        return this.getDouble(receiveTotalBytes);
    }

    public void setReceiveTotalBytes(double v) {
        this.setDouble(receiveTotalBytes, v, null);
    }

    public double getReceiveDataRate() {
        return this.getDouble(receiveDataRate);
    }

    public void setReceiveDataRate(double v) {
        this.setDouble(receiveDataRate, v, null);
    }

    public long getReceiveMinSize() {
        return this.getLong(receiveMinSize);
    }

    public void setReceiveMinSize(long v) {
        this.setLong(receiveMinSize, v, null);
    }

    public long getReceiveMaxSize() {
        return this.getLong(receiveMaxSize);
    }

    public void setReceiveMaxSize(long v) {
        this.setLong(receiveMaxSize, v, null);
    }

    public long getMaxPublishQueueSize() {
        return this.getLong(maxPublishQueueSize);
    }

    public void setMaxPublishQueueSize(long v) {
        this.setLong(maxPublishQueueSize, v, null);
    }

    public double getRxDropCount() {
        return this.getDouble(rxDropCount);
    }

    public void setRxDropCount(double v) {
        this.setDouble(rxDropCount, v, null);
    }

    public double getTxDropCount() {
        return this.getDouble(txDropCount);
    }

    public void setTxDropCount(double v) {
        this.setDouble(txDropCount, v, null);
    }

    public double getTxFailCount() {
        return this.getDouble(txFailCount);
    }

    public void setTxFailCount(double v) {
        this.setDouble(txFailCount, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void newPublishMessage(MqttMessage message) {
        int size = message.getPayload().length;
        this.latestPublishTime = System.currentTimeMillis();
        ++this.latestPublishMessageCount;
        this.latestPublishTotalBytes += (double)size;
        if (this.latestPublishMinSize < 0L) {
            this.latestPublishMinSize = size;
        } else if ((long)size < this.latestPublishMinSize) {
            this.latestPublishMinSize = size;
        }
        if ((long)size > this.latestPublishMaxSize) {
            this.latestPublishMaxSize = size;
        }
        this.publishUpdated = true;
    }

    public void newSubscribeMessage(MqttMessage message) {
        int size = message.getPayload().length;
        this.latestReceiveTime = System.currentTimeMillis();
        ++this.latestReceiveMessageCount;
        this.latestReceiveTotalBytes += (double)size;
        if (this.latestReceiveMinSize < 0L) {
            this.latestReceiveMinSize = size;
        } else if ((long)size < this.latestReceiveMinSize) {
            this.latestReceiveMinSize = size;
        }
        if ((long)size > this.latestReceiveMaxSize) {
            this.latestReceiveMaxSize = size;
        }
        this.receiveUpdated = true;
    }

    public void updatePublishQueueSize(int newQueueSize) {
        if ((long)newQueueSize > this.latestMaxPublishQueueSize) {
            this.latestMaxPublishQueueSize = newQueueSize;
        }
    }

    public void incrementTxDropCount() {
        ++this.latestTxDropCount;
    }

    public void incrementTxFailCount() {
        ++this.latestTxFailCount;
    }

    public void incrementRxDropCount() {
        ++this.latestRxDropCount;
    }

    public void update() {
        double dataRate;
        double messageRate;
        long seconds = (System.currentTimeMillis() - this.getStartTime().getMillis()) / 1000L;
        if (seconds > 0L) {
            messageRate = (double)this.latestPublishMessageCount / (double)seconds;
            dataRate = this.latestPublishTotalBytes / (double)seconds;
        } else {
            messageRate = 0.0;
            dataRate = 0.0;
        }
        this.setLastPublishTime(BAbsTime.make((long)this.latestPublishTime));
        this.setPublishMessageCount(this.latestPublishMessageCount);
        this.setPublishMessageRate(messageRate);
        this.setPublishTotalBytes(this.latestPublishTotalBytes);
        this.setPublishDataRate(dataRate);
        this.setPublishMinSize(this.latestPublishMinSize);
        this.setPublishMaxSize(this.latestPublishMaxSize);
        if (!this.publishShown && this.publishUpdated) {
            this.setFlags((Slot)publishMessageCount, 1);
            this.setFlags((Slot)publishMessageRate, 1);
            this.setFlags((Slot)publishTotalBytes, 1);
            this.setFlags((Slot)publishDataRate, 1);
            this.setFlags((Slot)publishMinSize, 1);
            this.setFlags((Slot)publishMaxSize, 1);
            this.publishShown = true;
        }
        if (seconds > 0L) {
            messageRate = (double)this.latestReceiveMessageCount / (double)seconds;
            dataRate = this.latestReceiveTotalBytes / (double)seconds;
        } else {
            messageRate = 0.0;
            dataRate = 0.0;
        }
        this.setLastReceiveTime(BAbsTime.make((long)this.latestReceiveTime));
        this.setReceiveMessageCount(this.latestReceiveMessageCount);
        this.setReceiveMessageRate(messageRate);
        this.setReceiveTotalBytes(this.latestReceiveTotalBytes);
        this.setReceiveDataRate(dataRate);
        this.setReceiveMinSize(this.latestReceiveMinSize);
        this.setReceiveMaxSize(this.latestReceiveMaxSize);
        if (!this.receiveShown && this.receiveUpdated) {
            this.setFlags((Slot)receiveMessageCount, 1);
            this.setFlags((Slot)receiveMessageRate, 1);
            this.setFlags((Slot)receiveTotalBytes, 1);
            this.setFlags((Slot)receiveDataRate, 1);
            this.setFlags((Slot)receiveMinSize, 1);
            this.setFlags((Slot)receiveMaxSize, 1);
            this.receiveShown = true;
        }
        this.setMaxPublishQueueSize(this.latestMaxPublishQueueSize);
        this.setTxDropCount(this.latestTxDropCount);
        this.setTxFailCount(this.latestTxFailCount);
        this.setRxDropCount(this.latestRxDropCount);
    }

    public void doReset() {
        this.setStartTime(BAbsTime.now());
        this.latestPublishTime = 0L;
        this.latestPublishMessageCount = 0L;
        this.latestPublishTotalBytes = 0.0;
        this.latestPublishMinSize = -1L;
        this.latestPublishMaxSize = 0L;
        this.latestReceiveTime = 0L;
        this.latestReceiveMessageCount = 0L;
        this.latestReceiveTotalBytes = 0.0;
        this.latestReceiveMinSize = -1L;
        this.latestReceiveMaxSize = 0L;
        this.latestMaxPublishQueueSize = 0L;
        this.latestTxDropCount = 0L;
        this.latestTxFailCount = 0L;
        this.latestRxDropCount = 0L;
        this.setFlags((Slot)publishMessageCount, 5);
        this.setFlags((Slot)publishMessageRate, 5);
        this.setFlags((Slot)publishTotalBytes, 5);
        this.setFlags((Slot)publishDataRate, 5);
        this.setFlags((Slot)publishMinSize, 5);
        this.setFlags((Slot)publishMaxSize, 5);
        this.setFlags((Slot)receiveMessageCount, 5);
        this.setFlags((Slot)receiveMessageRate, 5);
        this.setFlags((Slot)receiveTotalBytes, 5);
        this.setFlags((Slot)receiveDataRate, 5);
        this.setFlags((Slot)receiveMinSize, 5);
        this.setFlags((Slot)receiveMaxSize, 5);
        this.publishShown = false;
        this.receiveShown = false;
        this.publishUpdated = false;
        this.receiveUpdated = false;
        this.update();
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/statistics.png");
    }
}

