/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.nio.ByteBuffer;
import java.util.Random;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import solutions.onesight.ossEasyMqtt.mqtt.BClientCertificate;
import solutions.onesight.ossEasyMqtt.mqtt.BSecurityOption;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="brokerHost", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="brokerPort", type="int", defaultValue="8883"), @NiagaraProperty(name="security", type="BSecurityOption", defaultValue="BSecurityOption.LoginOverSSL"), @NiagaraProperty(name="login", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()"), @NiagaraProperty(name="certificateAlias", type="String", defaultValue="", flags=4, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))")}), @NiagaraProperty(name="certificate", type="BClientCertificate", defaultValue="new BClientCertificate()", flags=4), @NiagaraProperty(name="clientIdentifier", type="String", defaultValue="ossinit"), @NiagaraProperty(name="cleanSession", type="boolean", defaultValue="false"), @NiagaraProperty(name="connectTimeout", type="int", defaultValue="30", facets={@Facet(value="BFacets.make( BFacets.UNITS, UnitDatabase.getUnit( \"second\" ) )")}), @NiagaraProperty(name="keepAliveInterval", type="int", defaultValue="60", facets={@Facet(value="BFacets.make( BFacets.UNITS, UnitDatabase.getUnit( \"second\" ) )")}), @NiagaraProperty(name="maxInflight", type="int", defaultValue="1000", flags=4), @NiagaraProperty(name="connectAtStartup", type="boolean", defaultValue="true"), @NiagaraProperty(name="connectionDebug", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="generateClientIdentifier")
public class BBrokerConnectionConfig
extends BComponent {
    public static final Property brokerHost = BBrokerConnectionConfig.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property brokerPort = BBrokerConnectionConfig.newProperty((int)0, (int)8883, null);
    public static final Property security = BBrokerConnectionConfig.newProperty((int)0, (BValue)BSecurityOption.LoginOverSSL, null);
    public static final Property login = BBrokerConnectionConfig.newProperty((int)0, (BValue)new BUsernameAndPassword(), null);
    public static final Property certificateAlias = BBrokerConnectionConfig.newProperty((int)4, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))));
    public static final Property certificate = BBrokerConnectionConfig.newProperty((int)4, (BValue)new BClientCertificate(), null);
    public static final Property clientIdentifier = BBrokerConnectionConfig.newProperty((int)0, (String)"ossinit", null);
    public static final Property cleanSession = BBrokerConnectionConfig.newProperty((int)0, (boolean)false, null);
    public static final Property connectTimeout = BBrokerConnectionConfig.newProperty((int)0, (int)30, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")));
    public static final Property keepAliveInterval = BBrokerConnectionConfig.newProperty((int)0, (int)60, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")));
    public static final Property maxInflight = BBrokerConnectionConfig.newProperty((int)4, (int)1000, null);
    public static final Property connectAtStartup = BBrokerConnectionConfig.newProperty((int)0, (boolean)true, null);
    public static final Property connectionDebug = BBrokerConnectionConfig.newProperty((int)4, (boolean)false, null);
    public static final Action generateClientIdentifier = BBrokerConnectionConfig.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BBrokerConnectionConfig.class);

    public String getBrokerHost() {
        return this.getString(brokerHost);
    }

    public void setBrokerHost(String v) {
        this.setString(brokerHost, v, null);
    }

    public int getBrokerPort() {
        return this.getInt(brokerPort);
    }

    public void setBrokerPort(int v) {
        this.setInt(brokerPort, v, null);
    }

    public BSecurityOption getSecurity() {
        return (BSecurityOption)this.get(security);
    }

    public void setSecurity(BSecurityOption v) {
        this.set(security, (BValue)v, null);
    }

    public BUsernameAndPassword getLogin() {
        return (BUsernameAndPassword)this.get(login);
    }

    public void setLogin(BUsernameAndPassword v) {
        this.set(login, (BValue)v, null);
    }

    public String getCertificateAlias() {
        return this.getString(certificateAlias);
    }

    public void setCertificateAlias(String v) {
        this.setString(certificateAlias, v, null);
    }

    public BClientCertificate getCertificate() {
        return (BClientCertificate)this.get(certificate);
    }

    public void setCertificate(BClientCertificate v) {
        this.set(certificate, (BValue)v, null);
    }

    public String getClientIdentifier() {
        return this.getString(clientIdentifier);
    }

    public void setClientIdentifier(String v) {
        this.setString(clientIdentifier, v, null);
    }

    public boolean getCleanSession() {
        return this.getBoolean(cleanSession);
    }

    public void setCleanSession(boolean v) {
        this.setBoolean(cleanSession, v, null);
    }

    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    public int getKeepAliveInterval() {
        return this.getInt(keepAliveInterval);
    }

    public void setKeepAliveInterval(int v) {
        this.setInt(keepAliveInterval, v, null);
    }

    public int getMaxInflight() {
        return this.getInt(maxInflight);
    }

    public void setMaxInflight(int v) {
        this.setInt(maxInflight, v, null);
    }

    public boolean getConnectAtStartup() {
        return this.getBoolean(connectAtStartup);
    }

    public void setConnectAtStartup(boolean v) {
        this.setBoolean(connectAtStartup, v, null);
    }

    public boolean getConnectionDebug() {
        return this.getBoolean(connectionDebug);
    }

    public void setConnectionDebug(boolean v) {
        this.setBoolean(connectionDebug, v, null);
    }

    public void generateClientIdentifier() {
        this.invoke(generateClientIdentifier, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getClientIdentifier().equals("ossinit")) {
            this.doGenerateClientIdentifier();
        }
    }

    public void changed(Property property, Context context) {
        if (property == security) {
            switch (this.getSecurity().getOrdinal()) {
                case 0: 
                case 1: {
                    this.setFlags((Slot)login, 4);
                    this.setFlags((Slot)certificate, 4);
                    this.setFlags((Slot)certificateAlias, 4);
                    break;
                }
                case 2: 
                case 3: {
                    this.setFlags((Slot)login, 0);
                    this.setFlags((Slot)certificate, 4);
                    this.setFlags((Slot)certificateAlias, 4);
                    break;
                }
                case 4: {
                    this.setFlags((Slot)login, 4);
                    this.setFlags((Slot)certificate, 0);
                    this.setFlags((Slot)certificateAlias, 4);
                    break;
                }
                case 5: {
                    this.setFlags((Slot)login, 0);
                    this.setFlags((Slot)certificate, 0);
                    this.setFlags((Slot)certificateAlias, 4);
                    break;
                }
                case 6: {
                    this.setFlags((Slot)login, 4);
                    this.setFlags((Slot)certificate, 4);
                    this.setFlags((Slot)certificateAlias, 0);
                    break;
                }
                case 7: {
                    this.setFlags((Slot)login, 0);
                    this.setFlags((Slot)certificate, 4);
                    this.setFlags((Slot)certificateAlias, 0);
                    break;
                }
                default: {
                    this.setSecurity(BSecurityOption.Anonymous);
                    this.setFlags((Slot)login, 4);
                    this.setFlags((Slot)certificate, 4);
                    this.setFlags((Slot)certificateAlias, 4);
                }
            }
        }
    }

    public boolean configValid() {
        if (this.getBrokerHost().isEmpty() || this.getBrokerPort() < 1 || this.getBrokerPort() > 65535) {
            return false;
        }
        return this.getSecurity().getOrdinal() != 2 || !this.getLogin().getUsername().isEmpty();
    }

    public void doGenerateClientIdentifier() {
        Random rand = new Random();
        byte[] stationName = Sys.getStation().getStationName().getBytes();
        byte[] brokerHost = this.getBrokerHost().getBytes();
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(System.currentTimeMillis());
        byte[] time = bb.array();
        byte[] genArray = new byte[8];
        rand.nextBytes(genArray);
        long genValue = 0L;
        for (int byteIndex = 0; byteIndex < 6; ++byteIndex) {
            if (stationName.length > byteIndex) {
                int n = byteIndex;
                genArray[n] = (byte)(genArray[n] ^ stationName[byteIndex]);
            }
            if (brokerHost.length > byteIndex) {
                int n = byteIndex;
                genArray[n] = (byte)(genArray[n] ^ brokerHost[byteIndex]);
            }
            if (time.length > byteIndex) {
                int n = byteIndex;
                genArray[n] = (byte)(genArray[n] ^ time[byteIndex]);
            }
            genValue |= (long)(genArray[byteIndex] & 0xFF) << byteIndex * 8;
        }
        this.setClientIdentifier("oss" + genValue);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/connection.png");
    }
}

