/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.license;

import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.sys.Sys;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;

public class OssEasyMqttLicense {
    private static boolean licensed = false;
    private static boolean licenseBrokerUnlimited = false;
    private static int licenseBrokerLimit = 0;
    private static final String LICENSE_BROKER_LIMIT = "brokerLimit";
    public static final String LICENSE_VENDOR = "OneSightSolutions";
    public static final String LICENSE_FEATURE = "ossEasyMQTT";

    public static boolean checkLicense() throws FeatureNotLicensedException {
        return OssEasyMqttLicense.checkLicense(false);
    }

    public static boolean checkLicense(boolean debugEnabled) throws FeatureNotLicensedException {
        licensed = false;
        licenseBrokerUnlimited = false;
        licenseBrokerLimit = 0;
        try {
            Feature licenseFeature = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            if (licenseFeature != null) {
                licensed = true;
                String brokerFeature = licenseFeature.get(LICENSE_BROKER_LIMIT, "");
                if (brokerFeature != null && !brokerFeature.isEmpty()) {
                    if (brokerFeature.equals("none")) {
                        licenseBrokerUnlimited = true;
                    } else {
                        licenseBrokerLimit = licenseFeature.geti(LICENSE_BROKER_LIMIT, 0);
                    }
                }
            }
        }
        catch (LicenseException licEx) {
            licensed = false;
        }
        if (!licensed) {
            OssEasyMqttLog.error("ossEasyMqtt is not licensed");
        } else if (debugEnabled) {
            if (licenseBrokerUnlimited) {
                OssEasyMqttLog.debug("Broker license unlimited");
            } else {
                OssEasyMqttLog.debug("Broker license limit: " + licenseBrokerLimit);
            }
        }
        return licensed;
    }

    public static boolean isLicensed() {
        return licensed;
    }

    public static boolean getBrokerUnlimited() {
        return licenseBrokerUnlimited;
    }

    public static int getBrokerLimit() {
        return licenseBrokerLimit;
    }
}

