/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.selection;

import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFolder;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryDiscoveryEntry;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryDiscoveryJob;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryFilterDialog;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryList;
import solutions.onesight.ossEasyHistoryExport.selection.BHistorySelection;

@NiagaraType(agent={@AgentOn(types={"ossEasyHistoryExport:HistoryList"})})
public class BHistorySelectionManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BHistorySelectionManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colPath = new CustomUnescapedColumn(BHistorySelection.historyPath);
    MgrColumn colHistoryStatus = new MgrColumn.PropPath(new Property[]{BHistorySelection.status});
    MgrColumn colHistoryFaultCause = new MgrColumn.PropPath(new Property[]{BHistorySelection.faultCause});
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colPath, this.colHistoryStatus, this.colHistoryFaultCause};
    public static final int NEW_PATH_FIELD_SIZE = 60;

    public Type getType() {
        return TYPE;
    }

    public BHistoryList getHistorySelectionNode() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BHistoryList) {
            return (BHistoryList)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cxt) {
        super.doLoadValue(obj, cxt);
        this.updateLearnData();
    }

    public void updateLearnData() {
        BHistoryDiscoveryJob learnJob = (BHistoryDiscoveryJob)this.getLearn().getJob();
        if (learnJob != null) {
            this.getLearn().updateRoots(learnJob.getHistoryPaths().getChildren(BHistoryDiscoveryEntry.class));
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    static class CustomUnescapedColumn
    extends MgrColumn.Prop {
        CustomUnescapedColumn(Property prop) {
            super(prop, 0);
        }

        CustomUnescapedColumn(Property prop, int flags) {
            super(prop, flags);
        }

        public String toDisplayString(Object row, Object value, Context cxt) {
            String cellContents = value instanceof BString ? SlotPath.unescape((String)((BString)value).getString()) : super.toDisplayString(row, value, cxt);
            return cellContents;
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new CustomUnescapedColumn(BHistoryDiscoveryEntry.historyPath)};
        }

        public void toRow(Object discovery, MgrEditRow row) {
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return null;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BHistoryDiscoveryJob) {
                BHistorySelectionManager.this.updateLearnData();
            }
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return false;
        }
    }

    class Controller
    extends FolderController {
        private final MgrController.MgrCommand findHistories;
        private final MgrController.MgrCommand setFilter;
        private final BHistorySelectionManager manager;

        Controller(BFolderManager localManager) {
            super(localManager);
            this.manager = (BHistorySelectionManager)localManager;
            this.findHistories = new FindHistoriesCommand((BWidget)this.manager);
            this.findHistories.setFlags(7);
            this.findHistories.setEnabled(true);
            this.setFilter = new SetFilterCommand((BWidget)this.manager);
            this.setFilter.setFlags(7);
            this.setFilter.setEnabled(true);
            this.match.setEnabled(false);
            this.match.setFlags(0);
            this.tagIt.setEnabled(false);
            this.tagIt.setFlags(0);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.findHistories, this.setFilter, this.cancel, this.add};
        }

        public CommandArtifact doNew(Context cxt) {
            String historyPath = BDialog.prompt((BWidget)this.getManager(), (String)"Enter history path", (String)"", (int)60);
            if (historyPath == null || historyPath.isEmpty()) {
                BDialog.error((BWidget)this.getManager(), (String)"History Path Invalid", (Object)"History path is blank");
            } else {
                BHistorySelectionManager.this.getHistorySelectionNode().add(historyPath);
            }
            return null;
        }

        public CommandArtifact doAdd(Context cxt) {
            if (BHistorySelectionManager.this.getLearn() == null) {
                return null;
            }
            for (Object discoverItem : this.getLearnTable().getSelectedObjects()) {
                BHistoryDiscoveryEntry historyItem = (BHistoryDiscoveryEntry)discoverItem;
                BHistorySelectionManager.this.getHistorySelectionNode().add(historyItem.getHistoryPath());
                this.getManager().loadValue((BObject)BHistorySelectionManager.this.getHistorySelectionNode());
            }
            return null;
        }

        class SetFilterCommand
        extends MgrController.MgrCommand {
            public SetFilterCommand(BWidget mgr) {
                super(mgr, "Set Filter");
            }

            public CommandArtifact doInvoke() {
                BHistoryFilterDialog filterDialog = new BHistoryFilterDialog(BHistorySelectionManager.this.getHistorySelectionNode().getHistoryDiscoveryFilter(), BHistorySelectionManager.this.getHistorySelectionNode().getHistoryDiscoveryFilterCaseSensitive(), BHistorySelectionManager.this.getHistorySelectionNode().getHistoryDiscoveryFilterRegex(), BHistorySelectionManager.this.getHistorySelectionNode().getHistoryDiscoveryFilterType(), true);
                int dialogResult = BDialog.open((BWidget)Controller.this.manager, (String)"Set History Filter", (Object)((Object)filterDialog), (int)3);
                if (dialogResult == 1) {
                    BHistorySelectionManager.this.getHistorySelectionNode().setHistoryDiscoveryFilter(filterDialog.getFilterString());
                    BHistorySelectionManager.this.getHistorySelectionNode().setHistoryDiscoveryFilterCaseSensitive(filterDialog.getFilterCaseSensitiveFlag());
                    BHistorySelectionManager.this.getHistorySelectionNode().setHistoryDiscoveryFilterRegex(filterDialog.getFilterRegexFlag());
                    BHistorySelectionManager.this.getHistorySelectionNode().setHistoryDiscoveryFilterType(filterDialog.getFilterHistoryType());
                }
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/filter.png")));
            }
        }

        class FindHistoriesCommand
        extends MgrController.MgrCommand {
            public FindHistoriesCommand(BWidget mgr) {
                super(mgr, "Find Histories");
            }

            public CommandArtifact doInvoke() throws Exception {
                Controller.this.learnMode.setSelected(true);
                BComponent rootNode = BHistorySelectionManager.this.getHistorySelectionNode().getComponentSpace().getRootComponent();
                BOrd ordToDiscoveryJob = BHistorySelectionManager.this.getHistorySelectionNode().doSubmitHistoryDiscoveryJob(rootNode.getNavOrd());
                BHistorySelectionManager.this.getLearn().setJob(ordToDiscoveryJob);
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/find.png")));
            }
        }
    }

    class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BHistorySelectionManager.this.cols;
        }

        public Type getFolderType() {
            return BFolder.TYPE;
        }
    }
}

