/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.selection;

import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;

@NiagaraType
public final class BHistoryFilterDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BHistoryFilterDialog.class);
    private BTextField filterValue = null;
    private BCheckBox caseValue = null;
    private BCheckBox regexValue = null;
    private BCheckBox historyTypeNumericValue = null;
    private BCheckBox historyTypeBooleanValue = null;
    private BCheckBox historyTypeEnumValue = null;
    private BCheckBox historyTypeStringValue = null;
    private static final int DEFAULT_FILTER_FIELD_SIZE = 40;

    public Type getType() {
        return TYPE;
    }

    public BHistoryFilterDialog() {
    }

    public BHistoryFilterDialog(String originalFilterString, boolean originalFilterCaseSensitiveFlag, boolean originalFilterRegexFlag, int originalFilterHistoryType, boolean showHistoryType) {
        BLabel filterLabel = new BLabel("Filter: ");
        this.filterValue = new BTextField(originalFilterString, 40, true);
        BGridPane valuePane = new BGridPane(2);
        valuePane.add(null, (BValue)filterLabel);
        valuePane.add(null, (BValue)this.filterValue);
        BLabel caseLabel = new BLabel("Case Sensitive: ");
        this.caseValue = new BCheckBox("", originalFilterCaseSensitiveFlag);
        BGridPane casePane = new BGridPane(2);
        casePane.add(null, (BValue)caseLabel);
        casePane.add(null, (BValue)this.caseValue);
        BLabel regexLabel = new BLabel("Regular Expression: ");
        this.regexValue = new BCheckBox("", originalFilterRegexFlag);
        BGridPane regexPane = new BGridPane(2);
        regexPane.add(null, (BValue)regexLabel);
        regexPane.add(null, (BValue)this.regexValue);
        BGridPane filterPane = new BGridPane(1);
        filterPane.setValign(BValign.center);
        filterPane.setHalign(BHalign.center);
        filterPane.add(null, (BValue)valuePane);
        filterPane.add(null, (BValue)casePane);
        filterPane.add(null, (BValue)regexPane);
        BBorderPane filterBorder = new BBorderPane((BWidget)filterPane, BBorder.solid);
        filterBorder.setMargin(BInsets.make((double)2.0, (double)20.0, (double)0.0, (double)20.0));
        BGridPane historyTypePane = new BGridPane(2);
        historyTypePane.setValign(BValign.center);
        historyTypePane.setHalign(BHalign.center);
        BGridPane containerPane = new BGridPane(1);
        containerPane.setValign(BValign.center);
        containerPane.setHalign(BHalign.center);
        containerPane.add(null, (BValue)filterBorder);
        if (showHistoryType) {
            BLabel historyTypeNumericLabel = new BLabel("Numeric Histories: ");
            this.historyTypeNumericValue = new BCheckBox("", (originalFilterHistoryType & 1) != 0);
            BLabel historyTypeBooleanLabel = new BLabel("Boolean Histories: ");
            this.historyTypeBooleanValue = new BCheckBox("", (originalFilterHistoryType & 2) != 0);
            BLabel historyTypeEnumLabel = new BLabel("Enum Histories: ");
            this.historyTypeEnumValue = new BCheckBox("", (originalFilterHistoryType & 4) != 0);
            BLabel historyTypeStringLabel = new BLabel("String Histories: ");
            this.historyTypeStringValue = new BCheckBox("", (originalFilterHistoryType & 8) != 0);
            historyTypePane.add(null, (BValue)historyTypeNumericLabel);
            historyTypePane.add(null, (BValue)this.historyTypeNumericValue);
            historyTypePane.add(null, (BValue)historyTypeBooleanLabel);
            historyTypePane.add(null, (BValue)this.historyTypeBooleanValue);
            historyTypePane.add(null, (BValue)historyTypeEnumLabel);
            historyTypePane.add(null, (BValue)this.historyTypeEnumValue);
            historyTypePane.add(null, (BValue)historyTypeStringLabel);
            historyTypePane.add(null, (BValue)this.historyTypeStringValue);
            BBorderPane historyTypeBorder = new BBorderPane((BWidget)historyTypePane, BBorder.solid);
            historyTypeBorder.setMargin(BInsets.make((double)2.0, (double)120.0, (double)0.0, (double)122.0));
            containerPane.add(null, (BValue)historyTypeBorder);
        }
        this.setContent((BWidget)containerPane);
    }

    public String getFilterString() {
        return this.filterValue.getText();
    }

    public boolean getFilterCaseSensitiveFlag() {
        return this.caseValue.isSelected();
    }

    public boolean getFilterRegexFlag() {
        return this.regexValue.isSelected();
    }

    public int getFilterHistoryType() {
        int historyTypeBits = 0;
        if (this.historyTypeNumericValue.isSelected()) {
            historyTypeBits |= 1;
        }
        if (this.historyTypeBooleanValue.isSelected()) {
            historyTypeBits |= 2;
        }
        if (this.historyTypeEnumValue.isSelected()) {
            historyTypeBits |= 4;
        }
        if (this.historyTypeStringValue.isSelected()) {
            historyTypeBits |= 8;
        }
        return historyTypeBits;
    }
}

