/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.credentials;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.workbench.view.BWbComponentView;
import solutions.onesight.ossEasyHistoryExport.export.BSftpKey;

@NiagaraType(agent={@AgentOn(types={"ossEasyHistoryExport:SftpKey"})})
public class BKeyImportView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BKeyImportView.class);
    private BTextEditorPane textStatusReport;
    private BTextEditorPane privateKeyText;
    private BTextField passphraseText;
    private BSftpKey sftpKey;

    public Type getType() {
        return TYPE;
    }

    public BKeyImportView() {
        BLabel headingLabel = new BLabel("Import Private Key");
        headingLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)20.0));
        headingLabel.setPadding(BInsets.make((double)10.0, (double)10.0, (double)3.0, (double)10.0));
        headingLabel.setHalign(BHalign.left);
        BTabbedPane tabbedPane = new BTabbedPane();
        tabbedPane.addPane("Text Import", this.createTextImportWidget());
        BGridPane rootPane = new BGridPane(1, new BWidget[]{headingLabel, tabbedPane});
        rootPane.setValign(BValign.make((int)0));
        rootPane.setHalign(BHalign.make((int)0));
        rootPane.setRowGap(10.0);
        this.setContent((BWidget)new BScrollPane((BWidget)rootPane));
    }

    private BWidget createTextImportWidget() {
        BLabel headingLabel = new BLabel("Import private key from text");
        headingLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)20.0));
        headingLabel.setPadding(BInsets.make((double)10.0, (double)10.0, (double)0.0, (double)10.0));
        headingLabel.setHalign(BHalign.left);
        BLabel privateKeyLabel = new BLabel("Private Key: ");
        privateKeyLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        privateKeyLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        BLabel passphraseLabel = new BLabel("Passphrase: ");
        passphraseLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        passphraseLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        this.privateKeyText = new BTextEditorPane("", 12, 70, true);
        this.passphraseText = new BTextField("", 70);
        BGridPane textFieldGrid = new BGridPane(2, new BWidget[]{privateKeyLabel, this.privateKeyText, passphraseLabel, this.passphraseText});
        textFieldGrid.setValign(BValign.make((int)0));
        textFieldGrid.setHalign(BHalign.make((int)0));
        textFieldGrid.setRowGap(10.0);
        BLabel statusLabel = new BLabel("Key Import Status:");
        statusLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)14.0));
        statusLabel.setPadding(BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)20.0));
        this.textStatusReport = new BTextEditorPane("", 5, 60, false);
        BGridPane statusGrid = new BGridPane(2, new BWidget[]{statusLabel, this.textStatusReport});
        BBorderPane statusPane = new BBorderPane((BWidget)statusGrid);
        statusPane.setPadding(BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)0.0));
        ImportKeyTextButtonCommand importCommand = new ImportKeyTextButtonCommand((BWidget)this);
        BButton importButton = new BButton((Command)importCommand, true, false);
        importButton.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        importButton.setText("Import Certificates");
        BBorderPane buttonPane = new BBorderPane((BWidget)importButton);
        buttonPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)330.0));
        BGridPane textImportPane = new BGridPane(1, new BWidget[]{headingLabel, textFieldGrid, statusPane, buttonPane});
        textImportPane.setValign(BValign.make((int)0));
        textImportPane.setHalign(BHalign.make((int)0));
        textImportPane.setRowGap(10.0);
        return textImportPane;
    }

    private BWidget createErrorWidget(String errorText) {
        BFont errorFont = BFont.make((BFont)BFont.DEFAULT, (double)14.0);
        BLabel errorMessage = new BLabel(errorText, errorFont, BHalign.center);
        errorMessage.setPadding(BInsets.make((double)8.0, (double)10.0, (double)8.0, (double)10.0));
        errorMessage.setBackground(BBrush.makeSolid((BColor)BColor.make((int)235, (int)94, (int)84)));
        BBorder paneBorder = BBorder.make((double)3.0, (int)1, (BBrush)BBrush.makeSolid((BColor)BColor.red));
        BBorderPane errorPane = new BBorderPane((BWidget)errorMessage, paneBorder);
        errorPane.setMargin(BInsets.make((double)0.0, (double)10.0, (double)0.0, (double)0.0));
        errorPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        return errorPane;
    }

    protected void doLoadValue(BObject value, Context cxt) {
        try {
            this.sftpKey = (BSftpKey)value;
        }
        catch (Exception loadException) {
            loadException.printStackTrace();
        }
    }

    public class ImportKeyTextButtonCommand
    extends Command {
        ImportKeyTextButtonCommand(BWidget owner) {
            super(owner, "Import Certificates");
        }

        public CommandArtifact doInvoke() {
            if (BKeyImportView.this.sftpKey != null) {
                int count = 0;
                StringBuilder statusText = new StringBuilder();
                String textFieldValue = BKeyImportView.this.privateKeyText.getText();
                if (!textFieldValue.isEmpty()) {
                    BKeyImportView.this.sftpKey.setPrivateKey(BPassword.make((String)textFieldValue));
                    ++count;
                    statusText.append("Private Key OK");
                    statusText.append("\n");
                } else {
                    statusText.append("Private Key is blank");
                    statusText.append("\n");
                }
                textFieldValue = BKeyImportView.this.passphraseText.getText();
                if (!textFieldValue.isEmpty()) {
                    BKeyImportView.this.sftpKey.setPassphrase(BPassword.make((String)textFieldValue));
                    ++count;
                    statusText.append("Passphrase OK");
                    statusText.append("\n");
                } else {
                    statusText.append("Passphrase is blank");
                    statusText.append("\n");
                }
                BKeyImportView.this.textStatusReport.setText(statusText.toString());
                if (count < 2) {
                    BKeyImportView.this.textStatusReport.setViewportBackground(BBrush.makeSolid((BColor)BColor.red));
                    BDialog.error((BWidget)this.getOwner(), (String)"Import Text Fault", (Object)BKeyImportView.this.createErrorWidget(statusText.toString()));
                } else {
                    BKeyImportView.this.textStatusReport.setViewportBackground(BBrush.makeSolid((BColor)BColor.green));
                }
            }
            return null;
        }
    }
}

