/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import solutions.onesight.ossEasyHistoryExport.utils.TimeUtils;

public class FileUtils {
    public static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};

    public static String getFilePath(String path) {
        if (path.startsWith("file:^")) {
            return Sys.getStationHome().toString() + "/" + path.substring(6);
        }
        if (path.startsWith("local:|file:^")) {
            return Sys.getStationHome().toString() + "/" + path.substring(13);
        }
        if (path.startsWith("local:|foxs:|file:^")) {
            return Sys.getStationHome().toString() + "/" + path.substring(19);
        }
        if (path.startsWith("file:/")) {
            return path.substring(6);
        }
        if (path.startsWith("local:|file:/")) {
            return path.substring(13);
        }
        return null;
    }

    public static String getFilePath(BOrd ord) {
        return FileUtils.getFilePath(ord.encodeToString());
    }

    public static File getFile(String path) {
        String filePath = FileUtils.getFilePath(path);
        if (filePath != null) {
            return new File(filePath);
        }
        return null;
    }

    public static String makeTimeStampFilename(String remotePath) {
        return FileUtils.makeTimeStampFilename(System.currentTimeMillis(), remotePath);
    }

    public static String makeTimeStampFilename(long epochTime, String remotePath) {
        int extIndex;
        String timestamp = TimeUtils.toTimestamp(epochTime);
        String newPath = (remotePath = remotePath.trim()).isEmpty() ? timestamp : ((extIndex = remotePath.lastIndexOf(".")) == 0 ? timestamp + remotePath.substring(extIndex) : (extIndex > 0 ? remotePath.substring(0, extIndex) + "-" + timestamp + remotePath.substring(extIndex) : remotePath + "-" + timestamp));
        return newPath;
    }

    public static boolean writeFile(String filePath, String contents, boolean addUtfBom) {
        boolean writeSuccess = false;
        try {
            FileOutputStream outputWriter = new FileOutputStream(filePath);
            if (addUtfBom) {
                outputWriter.write(UTF_8_BOM);
            }
            outputWriter.write(contents.getBytes(StandardCharsets.UTF_8));
            outputWriter.close();
            writeSuccess = true;
        }
        catch (Exception writeException) {
            writeException.printStackTrace();
        }
        return writeSuccess;
    }

    public static File getFile(BOrd ord) {
        return FileUtils.getFile(ord.encodeToString());
    }
}

