/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.selection;

import java.util.ArrayList;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossEasyHistoryExport.license.OssEasyHistoryExportLicense;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryDiscoveryJob;
import solutions.onesight.ossEasyHistoryExport.selection.BHistorySelection;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyDiscoveryFilter", type="String", defaultValue="", flags=4), @NiagaraProperty(name="historyDiscoveryFilterCaseSensitive", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="historyDiscoveryFilterRegex", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="historyDiscoveryFilterType", type="int", defaultValue="1", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="submitHistoryDiscoveryJob", parameterType="baja:Ord", defaultValue="BOrd.make( \"\" )", returnType="baja:Ord", flags=4), @NiagaraAction(name="addHistory", parameterType="BString", defaultValue="BString.make(\"\")")})
public class BHistoryList
extends BComponent {
    public static final Property historyDiscoveryFilter = BHistoryList.newProperty((int)4, (String)"", null);
    public static final Property historyDiscoveryFilterCaseSensitive = BHistoryList.newProperty((int)4, (boolean)false, null);
    public static final Property historyDiscoveryFilterRegex = BHistoryList.newProperty((int)4, (boolean)false, null);
    public static final Property historyDiscoveryFilterType = BHistoryList.newProperty((int)4, (int)1, null);
    public static final Action submitHistoryDiscoveryJob = BHistoryList.newAction((int)4, (BValue)BOrd.make((String)""), null);
    public static final Action addHistory = BHistoryList.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BHistoryList.class);

    public String getHistoryDiscoveryFilter() {
        return this.getString(historyDiscoveryFilter);
    }

    public void setHistoryDiscoveryFilter(String v) {
        this.setString(historyDiscoveryFilter, v, null);
    }

    public boolean getHistoryDiscoveryFilterCaseSensitive() {
        return this.getBoolean(historyDiscoveryFilterCaseSensitive);
    }

    public void setHistoryDiscoveryFilterCaseSensitive(boolean v) {
        this.setBoolean(historyDiscoveryFilterCaseSensitive, v, null);
    }

    public boolean getHistoryDiscoveryFilterRegex() {
        return this.getBoolean(historyDiscoveryFilterRegex);
    }

    public void setHistoryDiscoveryFilterRegex(boolean v) {
        this.setBoolean(historyDiscoveryFilterRegex, v, null);
    }

    public int getHistoryDiscoveryFilterType() {
        return this.getInt(historyDiscoveryFilterType);
    }

    public void setHistoryDiscoveryFilterType(int v) {
        this.setInt(historyDiscoveryFilterType, v, null);
    }

    public BOrd submitHistoryDiscoveryJob(BOrd parameter) {
        return (BOrd)this.invoke(submitHistoryDiscoveryJob, (BValue)parameter, null);
    }

    public void addHistory(BString parameter) {
        this.invoke(addHistory, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.lease();
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BHistorySelection)) continue;
            this.registerHistory((BHistorySelection)childItem);
        }
    }

    public void stopped() {
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BHistorySelection)) continue;
            this.removeHistory((BHistorySelection)childItem);
        }
    }

    public BOrd doSubmitHistoryDiscoveryJob(BOrd rootOrd) {
        BHistoryDiscoveryJob historyDiscovery = new BHistoryDiscoveryJob(rootOrd, this.getHistoryDiscoveryFilter(), this.getHistoryDiscoveryFilterCaseSensitive(), this.getHistoryDiscoveryFilterRegex(), this.getHistoryDiscoveryFilterType());
        return historyDiscovery.submit(null);
    }

    public void doAddHistory(BString historyId) {
        this.add(historyId.getString());
    }

    public void add(String resourcePath) {
        if (!this.isExisting(resourcePath)) {
            this.add("history1?", (BValue)new BHistorySelection(resourcePath));
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context cxt) {
        if (this.isRunning() && value instanceof BHistorySelection) {
            this.registerHistory((BHistorySelection)value);
        }
    }

    public void removed(Property prop, BValue oldValue, Context cxt) {
        if (this.isRunning() && oldValue instanceof BHistorySelection) {
            this.removeHistory((BHistorySelection)oldValue);
        }
    }

    private boolean isExisting(String checkHistoryPath) {
        boolean pathFound = false;
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BHistorySelection) || !((BHistorySelection)childItem).getHistoryPath().equals(checkHistoryPath)) continue;
            pathFound = true;
            break;
        }
        return pathFound;
    }

    private boolean registerHistory(BHistorySelection newHistoryEntry) {
        boolean success = false;
        OssEasyHistoryExportLicense.incrementExportHistoryCount();
        if (OssEasyHistoryExportLicense.checkExportHistoryLimit()) {
            newHistoryEntry.setStatus(BStatus.ok);
            newHistoryEntry.setFaultCause("");
            success = true;
        } else {
            newHistoryEntry.setStatus(BStatus.fault);
            newHistoryEntry.setFaultCause("Exceeded export history license limit");
            OssEasyHistoryExportLog.error("Exceeded export history license limit");
        }
        return success;
    }

    private void removeHistory(BHistorySelection historyEntry) {
        OssEasyHistoryExportLicense.decrementExportHistoryCount();
    }

    public String[] getHistoryEntries() {
        BHistorySelection[] historyEntryList = (BHistorySelection[])this.getChildren(BHistorySelection.class);
        ArrayList<String> historyPathList = new ArrayList<String>();
        for (BHistorySelection bHistorySelection : historyEntryList) {
            if (!bHistorySelection.getStatus().isOk()) continue;
            historyPathList.add(bHistorySelection.getHistoryPath());
        }
        return historyPathList.toArray(new String[0]);
    }
}

