/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.selection;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BTrendRecord;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryDiscoveryEntry;

@NiagaraType
@NiagaraProperty(name="historyPaths", type="BFolder", defaultValue="new BFolder()", flags=7)
public final class BHistoryDiscoveryJob
extends BSimpleJob {
    public static final Property historyPaths = BHistoryDiscoveryJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE = Sys.loadType(BHistoryDiscoveryJob.class);
    private BOrd rootOrd = null;
    private String filterString = null;
    private boolean filterRegexFlag = false;
    private boolean filterCaseSensitiveFlag = false;
    private int filterHistoryType = 1;
    private Pattern regexPattern;
    private boolean cancelOperation = false;

    public BFolder getHistoryPaths() {
        return (BFolder)this.get(historyPaths);
    }

    public void setHistoryPaths(BFolder v) {
        this.set(historyPaths, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHistoryDiscoveryJob() {
        this.rootOrd = null;
        this.cancelOperation = false;
    }

    public BHistoryDiscoveryJob(BOrd newRootOrd) {
        this.rootOrd = newRootOrd;
        this.filterString = null;
        this.filterRegexFlag = false;
        this.cancelOperation = false;
    }

    public BHistoryDiscoveryJob(BOrd newRootOrd, String newFilterString, boolean newFilterCaseSensitiveFlag, boolean newFilterRegexFlag, int newFilterHistoryType) {
        this.rootOrd = newRootOrd;
        this.filterString = newFilterString;
        this.filterCaseSensitiveFlag = newFilterCaseSensitiveFlag;
        this.filterRegexFlag = newFilterRegexFlag;
        this.filterHistoryType = newFilterHistoryType;
        this.cancelOperation = false;
    }

    public void run(Context cxt) {
        this.progress(0);
        this.cancelOperation = false;
        if (this.rootOrd == null || this.rootOrd.toString().isEmpty()) {
            this.log().message("ERROR: History search root is not defined");
            throw new NullPointerException();
        }
        if (this.filterString != null && this.filterString.isEmpty()) {
            this.filterString = null;
        }
        if (this.filterString == null) {
            this.log().message("No filter");
        } else if (this.filterRegexFlag) {
            if (this.filterCaseSensitiveFlag) {
                this.regexPattern = Pattern.compile(this.filterString);
                this.log().message("Using case sensitive regex filter: " + this.filterString);
            } else {
                this.regexPattern = Pattern.compile(this.filterString, 2);
                this.log().message("Using case insensitive regex filter: " + this.filterString);
            }
        } else if (this.filterCaseSensitiveFlag) {
            this.log().message("Using case sensitive contains filter: " + this.filterString);
        } else {
            this.log().message("Using case insensitive contains filter: " + this.filterString);
            this.filterString = this.filterString.toLowerCase();
        }
        try {
            this.log().message("History search");
            BComponent stationRoot = ((BComponent)this.rootOrd.get()).getComponentSpace().getRootComponent();
            stationRoot.lease();
            String historyBqlQuery = "history:|bql:select id, recordType";
            BITable table = null;
            try {
                table = (BITable)BOrd.make((String)historyBqlQuery).get((BObject)stationRoot);
            }
            catch (SyntaxException querySyntaxException) {
                if (querySyntaxException.getCause() instanceof IOException) {
                    throw new IllegalArgumentException(querySyntaxException.getCause().getMessage());
                }
                throw querySyntaxException;
            }
            ColumnList columns = table.getColumns();
            TableCursor cursor = table.cursor();
            int totalCount = 0;
            int foundCount = 0;
            while (cursor.next() && !this.cancelOperation) {
                String historyId = cursor.cell(columns.get(0)).toString();
                String historyTypeName = cursor.cell(columns.get(1)).toString();
                if (this.checkType(historyTypeName) && this.checkFilter(historyId)) {
                    this.getHistoryPaths().add("history1?", (BValue)new BHistoryDiscoveryEntry(historyId));
                    ++foundCount;
                }
                ++totalCount;
            }
            this.log().message("Found " + foundCount + " histories (of " + totalCount + ")");
        }
        catch (Exception discoverEx) {
            this.log().message("ERROR: History discovery exception: " + discoverEx);
            throw discoverEx;
        }
        this.progress(100);
    }

    public boolean checkType(String historyTypeName) {
        Type historyType = BTypeSpec.make((String)historyTypeName).getResolvedType();
        BObject recordInstance = historyType.getInstance();
        if (recordInstance instanceof BTrendRecord) {
            BTrendRecord historyRecord = (BTrendRecord)recordInstance;
            BValue recordValue = historyRecord.get(historyRecord.getValueProperty());
            Type recordType = recordValue.getType();
            if (recordType.is(BINumeric.TYPE)) {
                return (this.filterHistoryType & 1) != 0;
            }
            if (recordType.is(BIBoolean.TYPE)) {
                return (this.filterHistoryType & 2) != 0;
            }
            if (recordType.is(BIEnum.TYPE)) {
                return (this.filterHistoryType & 4) != 0;
            }
            if (recordType.is(BString.TYPE)) {
                return (this.filterHistoryType & 8) != 0;
            }
        }
        return false;
    }

    public boolean checkFilter(String historyId) {
        if (this.filterString == null) {
            return true;
        }
        if (this.filterRegexFlag) {
            return this.regexPattern.matcher(historyId).find();
        }
        if (this.filterCaseSensitiveFlag) {
            return historyId.contains(this.filterString);
        }
        return historyId.toLowerCase().contains(this.filterString);
    }

    public void doCancel(Context cxt) {
        this.cancelOperation = true;
    }
}

