/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.license;

import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.sys.Sys;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;

public class OssEasyHistoryExportLicense {
    private static int currentExportHistoryCount = 0;
    private static boolean licensed = false;
    private static boolean licenseExportHistoryUnlimited = false;
    private static int licenseExportHistoryLimit = 0;
    public static final String LICENSE_EXPORT_HISTORY_ERROR = "Exceeded export history license limit";
    private static final String LICENSE_EXPORT_HISTORY_LIMIT = "historyExportLimit";
    public static final String LICENSE_VENDOR = "OneSightSolutions";
    public static final String LICENSE_FEATURE = "ossEasyHistoryExport";

    public static boolean checkLicense() throws FeatureNotLicensedException {
        return OssEasyHistoryExportLicense.checkLicense(false);
    }

    public static boolean checkLicense(boolean debugEnabled) throws FeatureNotLicensedException {
        licensed = false;
        licenseExportHistoryUnlimited = false;
        licenseExportHistoryLimit = 0;
        try {
            Feature licenseFeature = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            if (licenseFeature != null) {
                licensed = true;
                String historyFeature = licenseFeature.get(LICENSE_EXPORT_HISTORY_LIMIT, "");
                if (historyFeature != null && !historyFeature.isEmpty()) {
                    if (historyFeature.equals("none")) {
                        licenseExportHistoryUnlimited = true;
                    } else {
                        licenseExportHistoryLimit = licenseFeature.geti(LICENSE_EXPORT_HISTORY_LIMIT, 0);
                    }
                }
            }
        }
        catch (LicenseException licEx) {
            licensed = false;
        }
        if (!licensed) {
            OssEasyHistoryExportLog.error("ossEasyHistoryExport is not licensed");
        } else if (debugEnabled) {
            if (licenseExportHistoryUnlimited) {
                OssEasyHistoryExportLog.debug("History export license unlimited");
            } else {
                OssEasyHistoryExportLog.debug("History export license limit: " + licenseExportHistoryLimit);
            }
        }
        return licensed;
    }

    public static boolean isLicensed() {
        return licensed;
    }

    public static void incrementExportHistoryCount() {
        ++currentExportHistoryCount;
    }

    public static void decrementExportHistoryCount() {
        --currentExportHistoryCount;
    }

    public static boolean checkExportHistoryLimit() {
        if (!licensed) {
            return false;
        }
        if (licenseExportHistoryUnlimited) {
            return true;
        }
        return currentExportHistoryCount <= licenseExportHistoryLimit;
    }
}

