/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.history;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailPart;
import javax.baja.email.BEmailPartList;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BTextPart;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossEasyHistoryExport.export.BEmailConfig;
import solutions.onesight.ossEasyHistoryExport.ftp.TransferClient;
import solutions.onesight.ossEasyHistoryExport.history.ExportMaster;
import solutions.onesight.ossEasyHistoryExport.history.HistoryCsvGenerator;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;
import solutions.onesight.ossEasyHistoryExport.utils.FileUtils;

public class HistoryExportProcessor {
    private final ExportMaster master;
    private final String logIdent;
    private static final Logger log = OssEasyHistoryExportLog.getLog();

    public HistoryExportProcessor(ExportMaster newQueryMaster) {
        this.master = newQueryMaster;
        this.logIdent = this.master.getLogPrefix();
    }

    public void exportHistory(long startTime, long endTime) {
        this.master.setCurrentState("Export scan in progress");
        Object[] historyList = this.master.getHistoryList().getHistoryEntries();
        if (historyList == null || historyList.length < 1) {
            this.master.setFault("History list empty");
            return;
        }
        if (this.master.getSortHistoriesByName()) {
            Arrays.sort(historyList);
        }
        this.master.debugMsg("History start time = " + startTime + " = " + BAbsTime.make((long)startTime));
        this.master.debugMsg("History - end time = " + endTime + " = " + BAbsTime.make((long)endTime));
        HistoryCsvGenerator csvGenerator = new HistoryCsvGenerator(this.master, (String[])historyList, this.master.getRowLimit(), this.master.getMaxExportSize(), startTime, endTime, this.master.getRowOrder().getOrdinal() == 1, this.master.getCellPaddingSpaces(), this.master.getHistoryIdFormat().getOrdinal(), this.master.getTimestampFormat().getOrdinal(), this.master.getTimestampSelection().getOrdinal(), this.master.getSeparateDateTimeColumns(), this.master.getUnitsFormat().getOrdinal(), this.master.getMinNumericPrecision(), this.master.getMaxNumericPrecision(), this.master.getEndOfHistoryPolicy().getOrdinal(), this.master.getNoChangePolicy().getOrdinal(), this.master.getSkipDuplicateRowTimes(), this.master.getUnescapeHistoryNames(), this.master.getBinSize(), this.master.getSeparator(), this.master.getIgnoreHiddenValues());
        csvGenerator.scan();
        if (csvGenerator.succeeded()) {
            LinkedList<String> rowList = csvGenerator.getRowList();
            if (rowList.size() > 0) {
                int unitsFormat;
                this.master.debugMsg("CSV rows = " + rowList.size());
                StringBuilder csvText = new StringBuilder();
                csvText.append(csvGenerator.getHeaderRow());
                csvText.append("\n");
                if (this.master.getAddTypeRow()) {
                    csvText.append(csvGenerator.getTypeRow());
                    csvText.append("\n");
                }
                if ((unitsFormat = this.master.getUnitsFormat().getOrdinal()) == 11 || unitsFormat == 12) {
                    csvText.append(csvGenerator.getUnitsRow());
                    csvText.append("\n");
                }
                csvText.append(String.join((CharSequence)"\n", rowList));
                csvText.append("\n");
                if (this.master.getAddSummary()) {
                    csvText.append("\n");
                    csvText.append(csvGenerator.getSummary());
                    csvText.append("\n\n");
                }
                this.master.debugMsg("CSV size = " + csvText.length() + " bytes");
                this.master.setLastExportSize(csvText.length());
                if (this.master.getTransferType().getOrdinal() == 3) {
                    this.saveLocalFile(csvText.toString());
                } else if (this.master.getTransferType().getOrdinal() == 4) {
                    this.sendEmail(csvText.toString());
                } else {
                    this.master.setCurrentState("Export transfer in progress");
                    this.master.debugMsg("Export transfer in progress");
                    TransferClient exportTransfer = new TransferClient(this.master);
                    exportTransfer.transfer(csvText.toString());
                    if (exportTransfer.success()) {
                        this.master.clearFault();
                        this.master.setLastExportTime(BAbsTime.now());
                        this.master.setCurrentState("Success @ " + BAbsTime.now());
                        this.master.fireExportComplete(BBoolean.TRUE);
                        this.master.debugMsg(exportTransfer.getTransferType() + " transfer success");
                    } else {
                        this.master.setFault(exportTransfer.getFaultMessage());
                    }
                }
            } else {
                this.master.setCurrentState("No history data to export");
                log.warning(this.logIdent + "No history data to export");
            }
        } else {
            this.master.setFault(csvGenerator.getFaultMessage());
        }
    }

    public void saveLocalFile(String csvText) {
        this.master.checkLocalFilePath();
        String filePath = this.master.getLocalConfig().getLocalFilePath().format((Object)this.master).trim();
        if (this.master.getTimestampFile()) {
            filePath = FileUtils.makeTimeStampFilename(filePath);
        }
        filePath = Sys.getStationHome().toString() + "/" + filePath;
        filePath = filePath.replaceAll("\\\\", "/");
        this.master.setCurrentState("Saving CSV to file");
        this.master.debugMsg("Saving CSV to file: " + filePath);
        if (FileUtils.writeFile(filePath, csvText, true)) {
            this.master.clearFault();
            this.master.setLastExportTime(BAbsTime.now());
            this.master.setCurrentState("Success @ " + BAbsTime.now());
            this.master.fireExportComplete(BBoolean.TRUE);
            this.master.debugMsg("Successfully saved CSV to file");
        } else {
            this.master.setFault("Failed to save CSV to file");
        }
    }

    public void sendEmail(String csvText) {
        BEmailService emailService = HistoryExportProcessor.checkEmailService();
        if (emailService == null) {
            this.master.setFault("Could not find email service");
            return;
        }
        BEmailConfig emailConfig = this.master.getEmailConfig();
        if (emailConfig.getEmailAccount().isEmpty()) {
            this.master.setFault("Email account is not defined");
            return;
        }
        if (emailConfig.getTo().getAddresses().length < 1) {
            this.master.setFault("Email destination address (to) is not defined");
            return;
        }
        BOutgoingAccount emailAccount = (BOutgoingAccount)emailService.loadSlots().get(emailConfig.getEmailAccount());
        if (emailAccount == null) {
            this.master.setFault("Emailer can not find '" + emailConfig.getEmailAccount() + "' outgoing account");
            return;
        }
        this.master.setLastExportTime(BAbsTime.now());
        BEmail exportEmail = new BEmail();
        exportEmail.setTo(emailConfig.getTo());
        exportEmail.setCc(emailConfig.getCc());
        exportEmail.setBcc(emailConfig.getBcc());
        exportEmail.setDate(BAbsTime.now());
        exportEmail.setSubject(emailConfig.getSubject().format((Object)this.master));
        exportEmail.setBody((BEmailPart)new BTextPart("", emailConfig.getBody().format((Object)this.master)));
        if (!emailConfig.getMailer().isEmpty()) {
            exportEmail.getHeaders().addHeader("X-Mailer", emailConfig.getMailer());
        }
        String attachmentName = emailConfig.getAttachmentName().format((Object)this.master);
        if (this.master.getTimestampFile()) {
            attachmentName = FileUtils.makeTimeStampFilename(attachmentName);
        }
        BBlobPart csvBlob = new BBlobPart(attachmentName, BBlob.make((byte[])csvText.getBytes()));
        csvBlob.setMimeType(emailConfig.getAttachmentType());
        BEmailPartList csvAttachment = new BEmailPartList();
        csvAttachment.add("csvAttachment", (BValue)csvBlob);
        exportEmail.setAttachments(csvAttachment);
        emailAccount.send(exportEmail);
        this.master.clearFault();
        this.master.setCurrentState("Success @ " + BAbsTime.now());
        this.master.fireExportComplete(BBoolean.TRUE);
        this.master.debugMsg("History export email sent");
    }

    public static BEmailService checkEmailService() {
        BEmailService emailService = null;
        try {
            emailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emailService;
    }
}

