/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.history;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import solutions.onesight.ossEasyHistoryExport.history.BRangeSelection;
import solutions.onesight.ossEasyHistoryExport.history.BScheduleSelection;
import solutions.onesight.ossEasyHistoryExport.history.BWeekdaySelection;

public class HistoryExportParameters {
    private long resultNextExportTime;
    private long resultCurrentExportStartTime;
    private long resultCurrentExportEndTime;
    private boolean parametersValid = false;
    private String failMessage;

    public boolean calculate(long currentTimeMilliseconds, BScheduleSelection exportScheduleSelection, int exportScheduleDayOfMonth, long customTimePeriodSecs, long exportScheduleDelaySecs, BRangeSelection exportRangeSelection, long customTimeRangeSecs, long endTimeOffsetSecs, BWeekdaySelection startOfWeek) {
        this.parametersValid = false;
        this.failMessage = "unknown";
        this.resultNextExportTime = 0L;
        this.resultCurrentExportStartTime = 0L;
        this.resultCurrentExportEndTime = 0L;
        try {
            OffsetDateTime currentExportEndTime;
            OffsetDateTime currentExportStartTime;
            ZoneOffset currentTimeOffset = OffsetDateTime.ofInstant(Instant.ofEpochMilli(currentTimeMilliseconds), ZoneId.systemDefault()).getOffset();
            OffsetDateTime currentTime = Instant.ofEpochMilli(currentTimeMilliseconds).atOffset(currentTimeOffset);
            OffsetDateTime referenceTime = OffsetDateTime.of(currentTime.getYear(), currentTime.getMonth().getValue(), currentTime.getDayOfMonth(), 0, 0, 0, 0, currentTimeOffset);
            OffsetDateTime nextExportTime = null;
            switch (exportScheduleSelection.getOrdinal()) {
                case 1: {
                    nextExportTime = referenceTime.plusSeconds(exportScheduleDelaySecs);
                    if (!nextExportTime.isBefore(currentTime.plusSeconds(5L))) break;
                    nextExportTime = nextExportTime.plusDays(1L);
                    break;
                }
                case 2: {
                    nextExportTime = referenceTime.with(TemporalAdjusters.previousOrSame(this.getCalendarDayOfWeek(startOfWeek))).plusSeconds(exportScheduleDelaySecs);
                    if (!nextExportTime.isBefore(currentTime.plusSeconds(5L))) break;
                    nextExportTime = this.roundToNearestDay(nextExportTime.plusWeeks(1L)).plusSeconds(exportScheduleDelaySecs);
                    break;
                }
                case 3: {
                    nextExportTime = referenceTime.with(TemporalAdjusters.firstDayOfMonth()).plusSeconds(exportScheduleDelaySecs);
                    nextExportTime = exportScheduleDayOfMonth > 0 ? nextExportTime.plusDays(exportScheduleDayOfMonth - 1) : nextExportTime.minusDays(Math.abs(exportScheduleDayOfMonth));
                    if (nextExportTime.isBefore(currentTime.plusSeconds(5L))) {
                        nextExportTime = referenceTime.with(TemporalAdjusters.firstDayOfMonth()).plusSeconds(exportScheduleDelaySecs).plusMonths(1L);
                        nextExportTime = exportScheduleDayOfMonth > 0 ? nextExportTime.plusDays(exportScheduleDayOfMonth - 1) : nextExportTime.minusDays(Math.abs(exportScheduleDayOfMonth));
                    }
                    nextExportTime = this.roundToNearestDay(nextExportTime.minusSeconds(exportScheduleDelaySecs)).plusSeconds(exportScheduleDelaySecs);
                    break;
                }
                case 4: {
                    nextExportTime = this.getNextQuarterStart(referenceTime).plusSeconds(exportScheduleDelaySecs);
                    break;
                }
                case 100: {
                    nextExportTime = currentTime.plusSeconds(customTimePeriodSecs).plusSeconds(exportScheduleDelaySecs);
                    break;
                }
                case 0: {
                    nextExportTime = currentTime;
                    break;
                }
                default: {
                    this.failMessage = "Invalid schedule selector: " + exportScheduleSelection.getOrdinal();
                    return false;
                }
            }
            this.resultNextExportTime = nextExportTime.toEpochSecond() * 1000L;
            switch (exportRangeSelection.getOrdinal()) {
                case 1: {
                    currentExportStartTime = this.roundToNearestDay(referenceTime.minusDays(1L));
                    currentExportEndTime = this.roundToNearestDay(referenceTime);
                    break;
                }
                case 2: {
                    currentExportEndTime = referenceTime.with(TemporalAdjusters.previousOrSame(this.getCalendarDayOfWeek(startOfWeek)));
                    currentExportStartTime = currentExportEndTime.minusWeeks(1L);
                    currentExportStartTime = this.roundToNearestDay(currentExportStartTime);
                    currentExportEndTime = this.roundToNearestDay(currentExportEndTime);
                    break;
                }
                case 3: {
                    OffsetDateTime refEndTime = currentExportEndTime = referenceTime.with(TemporalAdjusters.firstDayOfMonth());
                    currentExportEndTime = exportScheduleDayOfMonth > 0 ? currentExportEndTime.plusDays(exportScheduleDayOfMonth - 1) : currentExportEndTime.minusDays(Math.abs(exportScheduleDayOfMonth));
                    if (currentExportEndTime.isAfter(currentTime.plusSeconds(5L))) {
                        currentExportEndTime = currentExportEndTime.minusMonths(1L);
                        refEndTime = refEndTime.minusMonths(1L);
                    }
                    currentExportStartTime = refEndTime.minusMonths(1L);
                    currentExportStartTime = exportScheduleDayOfMonth > 0 ? currentExportStartTime.plusDays(exportScheduleDayOfMonth - 1) : currentExportStartTime.minusDays(Math.abs(exportScheduleDayOfMonth));
                    currentExportStartTime = this.roundToNearestDay(currentExportStartTime);
                    currentExportEndTime = this.roundToNearestDay(currentExportEndTime);
                    break;
                }
                case 4: {
                    currentExportStartTime = this.getLastQuarterStart(referenceTime);
                    currentExportEndTime = referenceTime;
                    break;
                }
                case 5: {
                    currentExportStartTime = referenceTime.minusYears(1L);
                    currentExportEndTime = referenceTime;
                    break;
                }
                case 100: {
                    currentExportEndTime = currentTime;
                    currentExportStartTime = currentExportEndTime.minusSeconds(customTimeRangeSecs);
                    break;
                }
                default: {
                    this.failMessage = "Invalid range selector: " + exportRangeSelection.getOrdinal();
                    return false;
                }
            }
            this.resultCurrentExportStartTime = currentExportStartTime.toEpochSecond() * 1000L;
            this.resultCurrentExportEndTime = (currentExportEndTime.toEpochSecond() - endTimeOffsetSecs) * 1000L;
            this.parametersValid = true;
        }
        catch (Exception parameterException) {
            this.failMessage = "Parameter exception: " + parameterException;
            parameterException.printStackTrace();
        }
        return this.parametersValid;
    }

    public OffsetDateTime roundToNearestDay(OffsetDateTime sourceDateTime) {
        OffsetDateTime adjustedDateTime = sourceDateTime.getHour() > 12 ? sourceDateTime.plusDays(1L) : sourceDateTime;
        ZoneOffset offset = OffsetDateTime.ofInstant(Instant.ofEpochSecond(adjustedDateTime.toEpochSecond()), ZoneId.systemDefault()).getOffset();
        return OffsetDateTime.of(adjustedDateTime.getYear(), adjustedDateTime.getMonth().getValue(), adjustedDateTime.getDayOfMonth(), 0, 0, 0, 0, offset);
    }

    public DayOfWeek getCalendarDayOfWeek(BWeekdaySelection enumDayOfWeek) {
        DayOfWeek dayOfWeek = DayOfWeek.MONDAY;
        switch (enumDayOfWeek.getOrdinal()) {
            case 1: {
                dayOfWeek = DayOfWeek.MONDAY;
                break;
            }
            case 2: {
                dayOfWeek = DayOfWeek.TUESDAY;
                break;
            }
            case 3: {
                dayOfWeek = DayOfWeek.WEDNESDAY;
                break;
            }
            case 4: {
                dayOfWeek = DayOfWeek.THURSDAY;
                break;
            }
            case 5: {
                dayOfWeek = DayOfWeek.FRIDAY;
                break;
            }
            case 6: {
                dayOfWeek = DayOfWeek.SATURDAY;
                break;
            }
            case 0: {
                dayOfWeek = DayOfWeek.SUNDAY;
            }
        }
        return dayOfWeek;
    }

    public OffsetDateTime getLastQuarterStart(OffsetDateTime referenceTime) {
        Month quarterStartMonth;
        int quarterStartYear;
        switch (referenceTime.getMonth()) {
            case JANUARY: {
                quarterStartYear = referenceTime.getYear() - 1;
                quarterStartMonth = Month.OCTOBER;
                break;
            }
            case FEBRUARY: 
            case MARCH: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.JANUARY;
                break;
            }
            case APRIL: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.JANUARY;
                break;
            }
            case MAY: 
            case JUNE: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.APRIL;
                break;
            }
            case JULY: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.APRIL;
                break;
            }
            case AUGUST: 
            case SEPTEMBER: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.JULY;
                break;
            }
            case OCTOBER: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.JULY;
                break;
            }
            case NOVEMBER: 
            case DECEMBER: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.OCTOBER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid calendar month");
            }
        }
        return OffsetDateTime.of(quarterStartYear, quarterStartMonth.getValue(), 1, 0, 0, 0, 0, referenceTime.getOffset());
    }

    public OffsetDateTime getNextQuarterStart(OffsetDateTime referenceTime) {
        Month quarterStartMonth;
        int quarterStartYear;
        switch (referenceTime.getMonth()) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.APRIL;
                break;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.JULY;
                break;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                quarterStartYear = referenceTime.getYear();
                quarterStartMonth = Month.OCTOBER;
                break;
            }
            case OCTOBER: 
            case NOVEMBER: 
            case DECEMBER: {
                quarterStartYear = referenceTime.getYear() + 1;
                quarterStartMonth = Month.JANUARY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid calendar month");
            }
        }
        return OffsetDateTime.of(quarterStartYear, quarterStartMonth.getValue(), 1, 0, 0, 0, 0, referenceTime.getOffset());
    }

    public long getReferenceExportTime() {
        return this.resultNextExportTime;
    }

    public long getNextExportTime() {
        return this.resultNextExportTime;
    }

    public long getCurrentExportStartTime() {
        return this.resultCurrentExportStartTime;
    }

    public long getCurrentExportEndTime() {
        return this.resultCurrentExportEndTime;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public boolean valid() {
        return this.parametersValid;
    }
}

