/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.history;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedList;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import solutions.onesight.ossEasyHistoryExport.history.HistoryColumn;
import solutions.onesight.ossEasyHistoryExport.log.Reporter;
import solutions.onesight.ossEasyHistoryExport.utils.TimeUtils;

public class HistoryCsvGenerator {
    private final Reporter report;
    private final String[] historyIdList;
    private final long maxRowCount;
    private final long maxExportSize;
    private final long startTime;
    private final long endTime;
    private final boolean ascendingOrder;
    private final int historyIdFormat;
    private final boolean cellPaddingSpaces;
    private final int timestampFormat;
    private final int timestampSelection;
    private final boolean separateDateTime;
    private final int unitsFormat;
    private final int minNumericPrecision;
    private final int maxNumericPrecision;
    private final int endOfHistoryPolicy;
    private final int noChangePolicy;
    private final boolean skipDuplicateRowTimes;
    private final boolean unescapeHistoryName;
    private final int binSize;
    private final String separator;
    private final boolean ignoreHidden;
    private boolean success;
    private String faultMessage = "unknown";
    private LinkedList<HistoryColumn> historyColumnList = null;
    private String headerRow = null;
    private String typeRow = null;
    private String unitsRow = null;
    private LinkedList<String> rowList = null;
    private final NumberFormat formatter = NumberFormat.getInstance();

    public HistoryCsvGenerator(Reporter newReporter, String[] newHistoryIdList, long newMaxRowCount, long newMaxExportSize, long newStartTime, long newEndTime, boolean newAscendingOrder, boolean newCellPaddingSpaces, int newHistoryIdFormat, int newTimestampFormat, int newTimestampSelection, boolean newSeparateDateTime, int newUnitsFormat, int newMinNumericPrecision, int newMaxNumericPrecision, int newEndOfHistoryPolicy, int newNoChangePolicy, boolean newSkipDuplicateRowTimes, boolean newUnescapeHistoryName, int newBinSize, String newSeparator, boolean newIgnoreHidden) {
        this.report = newReporter;
        this.historyIdList = newHistoryIdList;
        this.maxRowCount = newMaxRowCount;
        this.maxExportSize = newMaxExportSize;
        this.startTime = newStartTime;
        this.endTime = newEndTime;
        this.ascendingOrder = newAscendingOrder;
        this.historyIdFormat = newHistoryIdFormat;
        this.cellPaddingSpaces = newCellPaddingSpaces;
        this.timestampFormat = newTimestampFormat;
        this.timestampSelection = newTimestampSelection;
        this.separateDateTime = newSeparateDateTime;
        this.unitsFormat = newUnitsFormat;
        this.minNumericPrecision = newMinNumericPrecision;
        this.maxNumericPrecision = newMaxNumericPrecision;
        this.endOfHistoryPolicy = newEndOfHistoryPolicy;
        this.noChangePolicy = newNoChangePolicy;
        this.skipDuplicateRowTimes = newSkipDuplicateRowTimes;
        this.unescapeHistoryName = newUnescapeHistoryName;
        this.binSize = newBinSize * 1000;
        this.separator = newSeparator;
        this.ignoreHidden = newIgnoreHidden;
    }

    public void scan() {
        HistorySpaceConnection databaseConn;
        this.report.debugMsg("Scanning histories");
        this.success = false;
        this.faultMessage = "unknown";
        this.headerRow = null;
        this.rowList = null;
        this.historyColumnList = new LinkedList();
        this.report.debugMsg("Getting history list");
        try {
            BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase historyDatabase = historyService.getDatabase();
            databaseConn = historyDatabase.getConnection(null);
            StringBuilder headerLine = new StringBuilder();
            StringBuilder typeLine = new StringBuilder();
            StringBuilder unitsLine = new StringBuilder();
            if (!this.separateDateTime) {
                headerLine.append("Timestamp");
                typeLine.append("Timestamp");
                unitsLine.append("Timestamp");
            } else {
                headerLine.append("Date");
                typeLine.append("Date");
                unitsLine.append("Date");
                headerLine.append(",");
                typeLine.append(",");
                unitsLine.append(",");
                if (this.cellPaddingSpaces) {
                    headerLine.append(" ");
                    typeLine.append(" ");
                    unitsLine.append(" ");
                }
                headerLine.append("Time");
                typeLine.append("Time");
                unitsLine.append("Time");
            }
            for (String historyId : this.historyIdList) {
                try {
                    BHistoryId historyIdent = BHistoryId.make((String)historyId);
                    BIHistory historyInstance = databaseConn.getHistory(historyIdent);
                    if (historyInstance != null) {
                        this.report.debugMsg("History ID: " + historyId);
                        String historyLabel = this.historyIdFormat == 2 ? historyIdent.getHistoryName() : (this.historyIdFormat == 3 ? historyInstance.getDisplayName(null) : historyIdent.getDeviceName() + "-" + historyIdent.getHistoryName());
                        BTypeSpec historyType = historyInstance.getRecordType();
                        this.historyColumnList.add(new HistoryColumn(historyLabel, historyType, (Cursor<BHistoryRecord>)databaseConn.scan(historyInstance, true)));
                        headerLine.append(this.separator);
                        typeLine.append(this.separator);
                        unitsLine.append(this.separator);
                        if (this.cellPaddingSpaces) {
                            headerLine.append(" ");
                            typeLine.append(" ");
                            unitsLine.append(" ");
                        }
                        String headerLabel = this.unescapeHistoryName ? SlotPath.unescape((String)historyLabel) : historyLabel;
                        String historyUnits = this.getHistoryUnits(historyInstance.getConfig());
                        headerLine.append(this.getHeaderLabel(headerLabel, historyUnits));
                        typeLine.append(historyType.getTypeName());
                        unitsLine.append(historyUnits);
                        continue;
                    }
                    this.report.errorMsg("Invalid history: " + historyId);
                }
                catch (Exception historyAddException) {
                    this.report.errorMsg("Invalid history exception [" + historyId + "]: " + historyAddException);
                }
            }
            this.headerRow = headerLine.toString();
            this.typeRow = typeLine.toString();
            this.unitsRow = unitsLine.toString();
        }
        catch (Exception historyException) {
            this.faultMessage = "History scan list fault";
            this.report.errorMsg("History list exception: " + historyException.getMessage());
            historyException.printStackTrace();
            return;
        }
        if (databaseConn == null) {
            this.faultMessage = "History scan failed to get database connection";
            return;
        }
        if (this.historyColumnList.isEmpty()) {
            this.faultMessage = "No valid histories found";
            return;
        }
        this.report.debugMsg("Scanning history data");
        try {
            this.rowList = new LinkedList();
            long recordCount = 0L;
            long currentExportSize = 0L;
            boolean recordsRemain = true;
            long previousMaxTime = -1L;
            HashMap<Long, Integer> timeMap = new HashMap<Long, Integer>();
            while (recordsRemain) {
                long historyTime;
                BTrendRecord latestRecord;
                boolean validRow = true;
                int validColumnCount = 0;
                long binMaxTime = 0L;
                for (HistoryColumn history : this.historyColumnList) {
                    latestRecord = history.getRecord();
                    if (latestRecord == null) continue;
                    historyTime = latestRecord.getTimestamp().getMillis();
                    if (historyTime > binMaxTime) {
                        binMaxTime = historyTime;
                    }
                    ++validColumnCount;
                }
                if (validColumnCount < 1) break;
                long binMinTime = binMaxTime - (long)this.binSize + 1L;
                timeMap.clear();
                int timeMapMax = 1;
                long binModeTime = binMaxTime;
                for (HistoryColumn history : this.historyColumnList) {
                    latestRecord = history.getRecord();
                    if (latestRecord == null) continue;
                    if (this.ignoreHidden && latestRecord.getTrendFlags().getBit(4)) {
                        validRow = false;
                    }
                    if ((historyTime = latestRecord.getTimestamp().getMillis()) > binMaxTime || historyTime <= binMinTime) continue;
                    long truncatedTime = (historyTime + 30000L) / 60000L * 60000L;
                    if (timeMap.get(truncatedTime) != null) {
                        Integer timeMapCount;
                        Integer n = timeMapCount = (Integer)timeMap.get(truncatedTime);
                        Integer n2 = timeMapCount = Integer.valueOf(timeMapCount + 1);
                        timeMap.put(truncatedTime, timeMapCount);
                        if (timeMapCount <= timeMapMax) continue;
                        timeMapMax = timeMapCount;
                        binModeTime = truncatedTime;
                        continue;
                    }
                    timeMap.put(truncatedTime, 1);
                }
                long rowTime = binMaxTime;
                if (this.timestampSelection == 3) {
                    rowTime = binMinTime;
                } else if (this.timestampSelection == 2) {
                    rowTime = binModeTime;
                }
                if (previousMaxTime > 0L && rowTime >= previousMaxTime) {
                    rowTime = previousMaxTime;
                    if (this.skipDuplicateRowTimes) {
                        validRow = false;
                    }
                }
                if (rowTime > this.endTime) {
                    validRow = false;
                }
                if (validRow) {
                    previousMaxTime = rowTime;
                    StringBuilder csvLine = new StringBuilder();
                    if (!this.separateDateTime) {
                        csvLine.append(this.makeTimestamp(rowTime));
                    } else {
                        String fullTimestamp = this.makeTimestamp(rowTime);
                        String date = "";
                        String time = "";
                        if (fullTimestamp.contains(" ")) {
                            date = fullTimestamp.split(" ")[0];
                            time = fullTimestamp.split(" ")[1];
                        } else if (fullTimestamp.contains("T")) {
                            date = fullTimestamp.split("T")[0];
                            time = fullTimestamp.split("T")[1];
                        } else {
                            date = fullTimestamp;
                        }
                        csvLine.append(date);
                        csvLine.append(",");
                        if (this.cellPaddingSpaces) {
                            csvLine.append(" ");
                        }
                        csvLine.append(time);
                    }
                    this.formatter.setGroupingUsed(false);
                    this.formatter.setMinimumFractionDigits(this.minNumericPrecision);
                    this.formatter.setMaximumFractionDigits(this.maxNumericPrecision);
                    int validHistoryCount = 0;
                    for (HistoryColumn history : this.historyColumnList) {
                        csvLine.append(this.separator);
                        if (this.cellPaddingSpaces) {
                            csvLine.append(" ");
                        }
                        if ((latestRecord = history.getRecord()) != null) {
                            historyTime = latestRecord.getTimestamp().getMillis();
                            if (historyTime >= this.startTime) {
                                ++validHistoryCount;
                            }
                            BValue recordValue = latestRecord.get(latestRecord.getValueProperty());
                            String cellValue = this.formatValue(recordValue);
                            if (historyTime <= binMaxTime && historyTime > binMinTime) {
                                history.recordUsed();
                            } else if (this.noChangePolicy == 2) {
                                cellValue = "null";
                            } else if (this.noChangePolicy == 3) {
                                cellValue = "";
                            }
                            csvLine.append(cellValue);
                            continue;
                        }
                        if (this.endOfHistoryPolicy == 5) {
                            recordsRemain = false;
                            continue;
                        }
                        csvLine.append(this.makeNull(history.isNumeric()));
                    }
                    if (!recordsRemain || validHistoryCount < 1) break;
                    if (this.ascendingOrder) {
                        this.rowList.addFirst(csvLine.toString());
                    } else {
                        this.rowList.addLast(csvLine.toString());
                    }
                    currentExportSize += (long)csvLine.length();
                    if (this.maxRowCount > 0L && ++recordCount >= this.maxRowCount) {
                        recordsRemain = false;
                        this.report.debugMsg("Max row count exceeded: " + recordCount + " > " + this.maxRowCount);
                    }
                    if (this.maxExportSize < 0L || currentExportSize <= this.maxExportSize) continue;
                    recordsRemain = false;
                    this.report.debugMsg("Max export size exceeded: " + currentExportSize + " > " + this.maxExportSize);
                    continue;
                }
                for (HistoryColumn history : this.historyColumnList) {
                    latestRecord = history.getRecord();
                    if (latestRecord == null || (historyTime = latestRecord.getTimestamp().getMillis()) > binMaxTime || historyTime <= binMinTime) continue;
                    history.recordUsed();
                }
            }
            this.report.debugMsg("History scan complete: " + recordCount + " records");
            if (recordCount > 0L) {
                this.success = true;
            } else {
                this.faultMessage = "No valid history data found";
            }
        }
        catch (Exception historyException) {
            this.faultMessage = "History scan processing fault";
            this.report.errorMsg("History scan exception: " + historyException.getMessage());
            historyException.printStackTrace();
        }
    }

    private String getHeaderLabel(String rawHistoryLabel, String historyUnits) {
        if (this.unitsFormat == 21 || this.unitsFormat == 22) {
            String labelSpacing = "";
            if (this.cellPaddingSpaces) {
                labelSpacing = " ";
            }
            return rawHistoryLabel + labelSpacing + "(" + historyUnits + ")";
        }
        return rawHistoryLabel;
    }

    private String getHistoryUnits(BHistoryConfig historyConfig) {
        BObject unitObj;
        BValue slotObj;
        String units = "";
        if (this.unitsFormat != 1 && (slotObj = historyConfig.get("valueFacets")) instanceof BFacets && (unitObj = ((BFacets)slotObj).get("units")) instanceof BUnit) {
            if (this.unitsFormat == 11 || this.unitsFormat == 21) {
                units = ((BUnit)unitObj).getSymbol();
            } else if (this.unitsFormat == 12 || this.unitsFormat == 22) {
                units = ((BUnit)unitObj).getUnitName();
            }
        }
        return units;
    }

    private String makeTimestamp(long timeMillis) {
        if (timeMillis <= 0L) {
            return this.makeNull(false);
        }
        switch (this.timestampFormat) {
            case 1: {
                return TimeUtils.toIso(timeMillis);
            }
            case 3: {
                return BAbsTime.make((long)timeMillis).toString();
            }
            case 4: {
                return TimeUtils.toBasic(timeMillis);
            }
            case 5: {
                return TimeUtils.toBasic2(timeMillis);
            }
        }
        return Long.toString(timeMillis);
    }

    private String formatValue(BValue rawValue) {
        if (rawValue instanceof BNumber) {
            return this.formatter.format(((BNumber)rawValue).getDouble());
        }
        if (rawValue instanceof BString) {
            String strValue = rawValue.toString();
            if (strValue.contains(",")) {
                return "\"" + strValue + "\"";
            }
            return strValue;
        }
        return rawValue.toString();
    }

    private String makeNull(boolean numericData) {
        switch (this.endOfHistoryPolicy) {
            case 3: {
                return "null";
            }
            case 4: {
                return "";
            }
        }
        if (numericData) {
            if (this.endOfHistoryPolicy == 2) {
                return "NaN";
            }
            return "0";
        }
        return "";
    }

    public boolean succeeded() {
        return this.success;
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }

    public String getHeaderRow() {
        return this.headerRow;
    }

    public String getTypeRow() {
        return this.typeRow;
    }

    public String getUnitsRow() {
        return this.unitsRow;
    }

    public LinkedList<String> getRowList() {
        return this.rowList;
    }

    public String getSummary() {
        if (this.historyColumnList == null) {
            this.report.errorMsg("Summary failed invalid history list");
        }
        StringBuilder summaryText = new StringBuilder();
        StringBuilder summaryHeader = new StringBuilder();
        StringBuilder firstRowLine = new StringBuilder();
        StringBuilder lastRowLine = new StringBuilder();
        StringBuilder calcRowLine = new StringBuilder();
        summaryHeader.append("History Id");
        firstRowLine.append("Start Value");
        lastRowLine.append("End Value");
        calcRowLine.append("Difference");
        for (HistoryColumn history : this.historyColumnList) {
            summaryHeader.append(this.separator);
            firstRowLine.append(this.separator);
            lastRowLine.append(this.separator);
            calcRowLine.append(this.separator);
            if (this.cellPaddingSpaces) {
                summaryHeader.append(" ");
                firstRowLine.append(" ");
                lastRowLine.append(" ");
                calcRowLine.append(" ");
            }
            summaryHeader.append(history.getLabel());
            Double firstValue = history.getFirstValue();
            Double lastValue = history.getLastValue();
            if (firstValue != null) {
                firstRowLine.append(this.formatter.format(firstValue));
            }
            if (lastValue != null) {
                lastRowLine.append(this.formatter.format(lastValue));
            }
            if (firstValue == null || lastValue == null) continue;
            calcRowLine.append(this.formatter.format(lastValue - firstValue));
        }
        summaryText.append((CharSequence)summaryHeader);
        summaryText.append("\n");
        summaryText.append((CharSequence)firstRowLine);
        summaryText.append("\n");
        summaryText.append((CharSequence)lastRowLine);
        summaryText.append("\n");
        summaryText.append((CharSequence)calcRowLine);
        summaryText.append("\n");
        return summaryText.toString();
    }
}

