/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.history;

import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.sys.BINumeric;
import javax.baja.sys.Cursor;
import javax.baja.util.BTypeSpec;

public class HistoryColumn {
    private final String historyLabel;
    private final BTypeSpec historyType;
    private final Cursor<BHistoryRecord> historyCursor;
    private final boolean typeIsNumeric;
    private Double firstValue = null;
    private Double lastValue = null;
    private BTrendRecord latestRecord = null;

    public HistoryColumn(String newHistoryLabel, BTypeSpec newHistoryType, Cursor<BHistoryRecord> newHistoryCursor) {
        this.historyLabel = newHistoryLabel;
        this.historyType = newHistoryType;
        this.typeIsNumeric = this.historyType.getTypeInfo().is(BINumeric.TYPE);
        this.historyCursor = newHistoryCursor;
    }

    public String getLabel() {
        return this.historyLabel;
    }

    public BTypeSpec getType() {
        return this.historyType;
    }

    public String getTypeName() {
        return this.historyType.getTypeName();
    }

    public boolean isNumeric() {
        return this.typeIsNumeric;
    }

    public Double getFirstValue() {
        return this.firstValue;
    }

    public Double getLastValue() {
        return this.lastValue;
    }

    public BTrendRecord getRecord() {
        BHistoryRecord rawRecord;
        if (this.latestRecord == null && this.historyCursor.next() && (rawRecord = (BHistoryRecord)this.historyCursor.get()) instanceof BTrendRecord) {
            this.latestRecord = (BTrendRecord)rawRecord;
            if (this.typeIsNumeric) {
                if (this.lastValue == null) {
                    this.lastValue = ((BINumeric)this.latestRecord).getNumeric();
                }
                this.firstValue = ((BINumeric)this.latestRecord).getNumeric();
            }
        }
        return this.latestRecord;
    }

    public void recordUsed() {
        this.latestRecord = null;
    }
}

