/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.ftp;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.security.BPassword;
import solutions.onesight.ossEasyHistoryExport.ftp.ExportTransfer;
import solutions.onesight.ossEasyHistoryExport.ftp.FtpTransfer;
import solutions.onesight.ossEasyHistoryExport.ftp.SftpTransfer;
import solutions.onesight.ossEasyHistoryExport.ftp.TransferMaster;
import solutions.onesight.ossEasyHistoryExport.utils.FileUtils;

public class TransferClient {
    private ExportTransfer client;
    private final TransferMaster master;

    public TransferClient(TransferMaster newTransferMaster) {
        this.master = newTransferMaster;
    }

    public void transfer(String fileData) {
        String ftpPassword = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return TransferClient.this.master.getFtpConfig().getLogin().getPassword().getValue();
            }
        });
        String privateKey = AccessController.doPrivileged(() -> ((BPassword)this.master.getFtpConfig().getSftpKey().getPrivateKey()).getValue());
        String passPhrase = AccessController.doPrivileged(() -> ((BPassword)this.master.getFtpConfig().getSftpKey().getPassphrase()).getValue());
        String remotePath = this.master.getTimestampFile() ? FileUtils.makeTimeStampFilename(this.master.getFtpConfig().getRemotePath()) : this.master.getFtpConfig().getRemotePath();
        if (this.master.getTransferType().getOrdinal() == 1) {
            this.client = new FtpTransfer(this.master.getFtpConfig().getFtpServerAddress(), this.master.getFtpConfig().getFtpPort(), this.master.getFtpConfig().getLogin().getUsername(), ftpPassword, remotePath, this.master.getFtpConfig().getTimeout());
        } else if (this.master.getTransferType().getOrdinal() == 2) {
            this.client = new SftpTransfer(this.master.getFtpConfig().getFtpServerAddress(), this.master.getFtpConfig().getFtpPort(), this.master.getFtpConfig().getLogin().getUsername(), ftpPassword, remotePath, this.master.getFtpConfig().getTimeout(), this.master.getDebugEnabled(), this.master.getFtpConfig().getUseKey(), privateKey, passPhrase);
        } else {
            this.master.setFault("Invalid transfer type");
            return;
        }
        this.client.transfer(fileData);
    }

    public boolean success() {
        if (this.client != null) {
            return this.client.succeeded();
        }
        return false;
    }

    public String getFaultMessage() {
        if (this.client != null) {
            return this.client.getFaultMessage();
        }
        return "No transfer";
    }

    public String getTransferType() {
        if (this.client != null) {
            return this.client.getTransferType();
        }
        return "None";
    }
}

