/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.ftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import solutions.onesight.ossEasyHistoryExport.ftp.ExportTransfer;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;

public class SftpTransfer
implements ExportTransfer {
    private final String serverAddress;
    private final int serverPort;
    private final String username;
    private final String password;
    private final String remotePath;
    private final int timeoutMillis;
    private final boolean debugEnabled;
    private final boolean useKey;
    private final String privateKey;
    private final String passphrase;
    private boolean success = false;
    private String faultMessage = "unknown";

    public SftpTransfer(String newServerAddress, int newServerPort, String newUsername, String newPassword, String newRemotePath, int newTimeoutSecs, boolean newDebugEnabled, boolean newUseKey, String newPrivateKey, String newPassphrase) {
        this.serverAddress = newServerAddress;
        this.serverPort = newServerPort;
        this.username = newUsername;
        this.password = newPassword;
        this.remotePath = newRemotePath;
        this.timeoutMillis = newTimeoutSecs * 1000;
        this.debugEnabled = newDebugEnabled;
        this.useKey = newUseKey;
        this.privateKey = newPrivateKey;
        this.passphrase = newPassphrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void transfer(String fileData) {
        this.success = false;
        if (this.debugEnabled) {
            JSch.setLogger(new TransferLogger());
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            if (this.useKey) {
                jsch.addIdentity(null, this.privateKey.getBytes(), null, this.passphrase.getBytes());
            }
            session = jsch.getSession(this.username, this.serverAddress, this.serverPort);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setTimeout(this.timeoutMillis);
            session.setPassword(this.password);
            try {
                session.connect();
            }
            catch (JSchException connectException) {
                this.faultMessage = "Failed to connect to SFTP server: " + connectException.getMessage();
                try {
                    if (sftpChannel != null) {
                        sftpChannel.disconnect();
                    }
                    if (session == null) return;
                    session.disconnect();
                    return;
                }
                catch (Exception closeException) {
                    this.faultMessage = "Transfer close exception: " + closeException.getMessage();
                }
                return;
            }
            sftpChannel = (ChannelSftp)session.openChannel("sftp");
            if (sftpChannel == null) {
                this.faultMessage = "Failed to open SFTP channel";
                return;
            }
            sftpChannel.connect();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData.getBytes());
            try {
                sftpChannel.put(inputStream, this.remotePath);
            }
            catch (Exception sftpException) {
                this.faultMessage = "SFTP upload failed: " + sftpException.getMessage();
                try {
                    if (sftpChannel != null) {
                        sftpChannel.disconnect();
                    }
                    if (session == null) return;
                    session.disconnect();
                    return;
                }
                catch (Exception closeException) {
                    this.faultMessage = "Transfer close exception: " + closeException.getMessage();
                }
                return;
            }
            try {
                SftpATTRS fileAttr = sftpChannel.stat(this.remotePath);
                this.success = true;
                return;
            }
            catch (Exception pathException) {
                this.faultMessage = "SFTP upload failed";
                return;
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception transferException) {
            this.faultMessage = "File transfer exception: " + transferException.getMessage();
            return;
        }
        finally {
            try {
                if (sftpChannel != null) {
                    sftpChannel.disconnect();
                }
                if (session != null) {
                    session.disconnect();
                }
            }
            catch (Exception closeException) {
                this.faultMessage = "Transfer close exception: " + closeException.getMessage();
            }
        }
    }

    @Override
    public boolean succeeded() {
        return this.success;
    }

    @Override
    public String getFaultMessage() {
        return this.faultMessage;
    }

    @Override
    public String getTransferType() {
        return "SFTP";
    }

    class TransferLogger
    implements Logger {
        TransferLogger() {
        }

        @Override
        public boolean isEnabled(int level) {
            return true;
        }

        @Override
        public void log(int level, String message) {
            OssEasyHistoryExportLog.debug("SFTP: " + message);
        }
    }
}

