/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.ftp;

import java.io.ByteArrayInputStream;
import java.net.ConnectException;
import java.time.Duration;
import org.apache.commons.net.ftp.FTPClient;
import solutions.onesight.ossEasyHistoryExport.ftp.ExportTransfer;

public class FtpTransfer
implements ExportTransfer {
    private String serverAddress;
    private int serverPort;
    private String username;
    private String password;
    private String remotePath;
    private int timeoutMillis;
    private boolean success = false;
    private String faultMessage = "unknown";

    public FtpTransfer(String newServerAddress, int newServerPort, String newUsername, String newPassword, String newRemotePath, int newTimeoutSecs) {
        this.serverAddress = newServerAddress;
        this.serverPort = newServerPort;
        this.username = newUsername;
        this.password = newPassword;
        this.remotePath = newRemotePath;
        this.timeoutMillis = newTimeoutSecs * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transfer(String fileData) {
        this.success = false;
        try {
            FTPClient ftpClient = new FTPClient();
            ftpClient.setConnectTimeout(this.timeoutMillis);
            ftpClient.setDefaultTimeout(this.timeoutMillis);
            ftpClient.setDataTimeout(Duration.ofMillis(this.timeoutMillis));
            ftpClient.setControlKeepAliveTimeout(Duration.ofMinutes(5L));
            ftpClient.setControlKeepAliveReplyTimeout(Duration.ofMillis(this.timeoutMillis));
            try {
                ftpClient.connect(this.serverAddress, this.serverPort);
            }
            catch (ConnectException connectException) {
                this.faultMessage = "Failed to connect to FTP server: " + connectException.getMessage();
                return;
            }
            ftpClient.login(this.username, this.password);
            int ftpReplyCode = ftpClient.getReplyCode();
            if (ftpReplyCode == 530) {
                this.faultMessage = "FTP login failed for user '" + this.username + "'";
                return;
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData.getBytes());){
                this.success = ftpClient.storeFile(this.remotePath, inputStream);
            }
            if (!this.success) {
                try {
                    ftpClient.getReply();
                    this.faultMessage = "File transfer failed: " + ftpClient.getReplyString();
                }
                catch (Exception statusException) {
                    this.faultMessage = "File transfer fault: " + statusException.getMessage();
                }
            }
        }
        catch (Exception transferException) {
            this.faultMessage = "File transfer exception: " + transferException.getMessage();
            return;
        }
    }

    @Override
    public boolean succeeded() {
        return this.success;
    }

    @Override
    public String getFaultMessage() {
        return this.faultMessage;
    }

    @Override
    public String getTransferType() {
        return "FTP";
    }
}

