/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.exportDailyRow;

import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailPart;
import javax.baja.email.BEmailPartList;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BTextPart;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossEasyHistoryExport.export.BEmailConfig;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BOssDailyRowHistoryExport;
import solutions.onesight.ossEasyHistoryExport.ftp.TransferClient;
import solutions.onesight.ossEasyHistoryExport.utils.FileUtils;

public class TransferHandler {
    public static void exportCsv(BOssDailyRowHistoryExport master, String csvText) {
        master.setLastExportSize(csvText.length());
        master.debugMsg("CSV size = " + csvText.length() + " bytes");
        if (master.getTransferType().getOrdinal() == 3) {
            TransferHandler.saveLocalFile(master, csvText);
        } else if (master.getTransferType().getOrdinal() == 4) {
            TransferHandler.sendEmail(master, csvText);
        } else {
            master.setCurrentState("Export transfer in progress");
            master.debugMsg("Export transfer in progress");
            TransferClient exportTransfer = new TransferClient(master);
            exportTransfer.transfer(csvText);
            if (exportTransfer.success()) {
                master.clearFault();
                master.setLastExportTime(BAbsTime.now());
                master.setCurrentState("Success @ " + BAbsTime.now());
                master.fireExportComplete(BBoolean.TRUE);
                master.debugMsg(exportTransfer.getTransferType() + " transfer success");
            } else {
                master.setFault(exportTransfer.getFaultMessage());
            }
        }
    }

    public static void saveLocalFile(BOssDailyRowHistoryExport master, String csvText) {
        master.checkLocalFilePath();
        String filePath = master.getLocalConfig().getLocalFilePath().format((Object)master).trim();
        if (master.getTimestampFile()) {
            filePath = FileUtils.makeTimeStampFilename(filePath);
        }
        filePath = Sys.getStationHome().toString() + "/" + filePath;
        filePath = filePath.replaceAll("\\\\", "/");
        master.setCurrentState("Saving CSV to file");
        master.debugMsg("Saving CSV to file: " + filePath);
        if (FileUtils.writeFile(filePath, csvText, true)) {
            master.clearFault();
            master.setLastExportTime(BAbsTime.now());
            master.setCurrentState("Success @ " + BAbsTime.now());
            master.fireExportComplete(BBoolean.TRUE);
            master.debugMsg("Successfully saved CSV to file");
        } else {
            master.setFault("Failed to save CSV to file");
        }
    }

    public static void sendEmail(BOssDailyRowHistoryExport master, String csvText) {
        BEmailService emailService = TransferHandler.checkEmailService();
        if (emailService == null) {
            master.setFault("Could not find email service");
            return;
        }
        BEmailConfig emailConfig = master.getEmailConfig();
        if (emailConfig.getEmailAccount().isEmpty()) {
            master.setFault("Email account is not defined");
            return;
        }
        if (emailConfig.getTo().getAddresses().length < 1) {
            master.setFault("Email destination address (to) is not defined");
            return;
        }
        BOutgoingAccount emailAccount = (BOutgoingAccount)emailService.loadSlots().get(emailConfig.getEmailAccount());
        if (emailAccount == null) {
            master.setFault("Emailer can not find '" + emailConfig.getEmailAccount() + "' outgoing account");
            return;
        }
        master.setLastExportTime(BAbsTime.now());
        BEmail exportEmail = new BEmail();
        exportEmail.setTo(emailConfig.getTo());
        exportEmail.setCc(emailConfig.getCc());
        exportEmail.setBcc(emailConfig.getBcc());
        exportEmail.setDate(BAbsTime.now());
        exportEmail.setSubject(emailConfig.getSubject().format((Object)master));
        exportEmail.setBody((BEmailPart)new BTextPart("", emailConfig.getBody().format((Object)master)));
        if (!emailConfig.getMailer().isEmpty()) {
            exportEmail.getHeaders().addHeader("X-Mailer", emailConfig.getMailer());
        }
        String attachmentName = emailConfig.getAttachmentName().format((Object)master);
        if (master.getTimestampFile()) {
            attachmentName = FileUtils.makeTimeStampFilename(attachmentName);
        }
        BBlobPart csvBlob = new BBlobPart(attachmentName, BBlob.make((byte[])csvText.getBytes()));
        csvBlob.setMimeType(emailConfig.getAttachmentType());
        BEmailPartList csvAttachment = new BEmailPartList();
        csvAttachment.add("csvAttachment", (BValue)csvBlob);
        exportEmail.setAttachments(csvAttachment);
        emailAccount.send(exportEmail);
        master.clearFault();
        master.setCurrentState("Success @ " + BAbsTime.now());
        master.fireExportComplete(BBoolean.TRUE);
        master.debugMsg("History export email sent");
    }

    public static BEmailService checkEmailService() {
        BEmailService emailService = null;
        try {
            emailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emailService;
    }
}

