/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.exportDailyRow;

import java.util.List;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BDailyRowHistorySelection;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BOssDailyRowHistoryExport;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.DailyRowHistoryCsvGenerator;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.TransferHandler;

public class DailyRowHistoryExportProcessor {
    private final BOssDailyRowHistoryExport master;
    private DailyRowHistoryCsvGenerator csvGenerator = null;

    public DailyRowHistoryExportProcessor(BOssDailyRowHistoryExport newQueryMaster) {
        this.master = newQueryMaster;
    }

    public void exportHistory(long exportTime) {
        this.master.setCurrentState("Export generation in progress");
        List<BDailyRowHistorySelection> historyList = this.master.getHistoryList().getHistoryEntries();
        if (historyList == null || historyList.size() < 1) {
            this.master.setFault("History list invalid");
            return;
        }
        this.csvGenerator = new DailyRowHistoryCsvGenerator(this.master, historyList, exportTime, this.master.getExportRange().getMillis(), this.master.getReadingInterval(), this.master.getHistoryNameSelection(), this.master.getDateFormat().trim(), this.master.getMinNumericPrecision(), this.master.getMaxNumericPrecision(), this.master.getCellFillValue(), this.master.getAddHeaderRow(), this.master.getCellPaddingSpaces(), this.master.getAnchorStartToDay(), this.master.getUnescapeHistoryNames(), this.master.getMaxExportSize(), this.master.getSeparator());
        this.csvGenerator.process();
        if (this.csvGenerator.succeeded()) {
            TransferHandler.exportCsv(this.master, this.csvGenerator.getCsvText());
        } else {
            this.master.setFault(this.csvGenerator.getFaultMessage());
        }
        this.csvGenerator = null;
    }

    public void cancel() {
        if (this.csvGenerator != null) {
            this.csvGenerator.cancel();
        }
    }
}

