/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.exportDailyRow;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BDailyRowHistorySelection;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BHistoryNameSelection;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BReadingInterval;
import solutions.onesight.ossEasyHistoryExport.log.Reporter;

public class DailyRowHistoryCsvGenerator {
    private final Reporter report;
    private final List<BDailyRowHistorySelection> historyList;
    private final long exportTime;
    private final long exportRange;
    private final BReadingInterval readingInterval;
    private final BHistoryNameSelection historyNameSelection;
    private final String dateFormat;
    private final int minNumericPrecision;
    private final int maxNumericPrecision;
    private final String cellFillValue;
    private final boolean addHeaderRow;
    private final boolean cellPaddingSpaces;
    private final boolean anchorStartToDay;
    private final boolean unescapeHistoryName;
    private final long maxExportSize;
    private String separator = ",";
    private BAbsTime startTime = null;
    private BAbsTime endTime = null;
    private int columnCount = 0;
    private BRelTime columnPeriod = null;
    private volatile boolean cancelOperation;
    private boolean success;
    private String faultMessage = "unknown";
    private int rowCount;
    private StringBuilder csvText;
    private String columnDelimiter = this.separator + " ";
    private final NumberFormat formatter = NumberFormat.getInstance();

    public DailyRowHistoryCsvGenerator(Reporter newReporter, List<BDailyRowHistorySelection> newHistoryList, long newExportTime, long newExportRange, BReadingInterval newReadingInterval, BHistoryNameSelection newHistoryNameFormat, String newDateFormat, int newMinNumericPrecision, int newMaxNumericPrecision, String newCellFillValue, boolean newAddHeaderRow, boolean newCellPaddingSpaces, boolean newAnchorStartToDay, boolean newUnescapeHistoryName, long newMaxExportSize, String newSeparator) {
        this.report = newReporter;
        this.historyList = newHistoryList;
        this.exportTime = newExportTime;
        this.exportRange = newExportRange;
        this.readingInterval = newReadingInterval;
        this.historyNameSelection = newHistoryNameFormat;
        this.dateFormat = newDateFormat.trim();
        this.minNumericPrecision = newMinNumericPrecision;
        this.maxNumericPrecision = newMaxNumericPrecision;
        this.cellFillValue = newCellFillValue.trim();
        this.addHeaderRow = newAddHeaderRow;
        this.cellPaddingSpaces = newCellPaddingSpaces;
        this.anchorStartToDay = newAnchorStartToDay;
        this.unescapeHistoryName = newUnescapeHistoryName;
        this.maxExportSize = newMaxExportSize;
        this.separator = newSeparator;
    }

    public void process() {
        this.report.debugMsg("Generating day row history CSV");
        this.cancelOperation = false;
        this.success = false;
        this.faultMessage = "unknown";
        this.rowCount = 0;
        try {
            if (this.formatDateText(BAbsTime.make((long)this.exportTime)) == null) {
                this.faultMessage = "Invalid date format";
                return;
            }
            this.columnDelimiter = this.cellPaddingSpaces ? this.separator + " " : this.separator;
            this.formatter.setGroupingUsed(false);
            this.formatter.setMinimumFractionDigits(this.minNumericPrecision);
            this.formatter.setMaximumFractionDigits(this.maxNumericPrecision);
            BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase historyDatabase = historyService.getDatabase();
            HistorySpaceConnection databaseConn = historyDatabase.getConnection(null);
            if (databaseConn == null) {
                this.faultMessage = "Failed to get history database connection";
                return;
            }
            this.startTime = BAbsTime.make((long)(this.exportTime - this.exportRange));
            if (this.anchorStartToDay) {
                this.startTime = this.roundTimeToDay(this.startTime);
            }
            this.endTime = BAbsTime.make((long)this.exportTime);
            this.report.debugMsg("Export start time: " + this.startTime);
            this.report.debugMsg("Export   end time: " + this.endTime);
            switch (this.readingInterval.getOrdinal()) {
                case 1: {
                    this.columnCount = 96;
                    this.columnPeriod = BRelTime.makeMinutes((int)15);
                    break;
                }
                case 2: {
                    this.columnCount = 48;
                    this.columnPeriod = BRelTime.makeMinutes((int)30);
                    break;
                }
                case 3: {
                    this.columnCount = 24;
                    this.columnPeriod = BRelTime.makeHours((int)1);
                    break;
                }
                default: {
                    this.faultMessage = "Invalid reading interval";
                    return;
                }
            }
            this.csvText = new StringBuilder();
            if (this.addHeaderRow) {
                this.generateHeaderRow();
            }
            this.report.debugMsg(this.historyList.size() + " histories");
            for (BDailyRowHistorySelection currentHistory : this.historyList) {
                try {
                    BHistoryId historyIdent = BHistoryId.make((String)currentHistory.getHistoryPath());
                    BIHistory historyInstance = databaseConn.getHistory(historyIdent);
                    if (historyInstance != null) {
                        this.report.debugMsg("History ID: " + historyIdent);
                        BTypeSpec historyTypeSpec = historyInstance.getRecordType();
                        if (historyTypeSpec.equals((Object)BNumericTrendRecord.TYPE.getTypeSpec())) {
                            String historyLabel = this.historyNameSelection.getOrdinal() == 1 ? historyIdent.getHistoryName() : (this.historyNameSelection.getOrdinal() == 3 ? currentHistory.getDisplayName(null) : historyInstance.getDisplayName(null));
                            if (this.unescapeHistoryName) {
                                historyLabel = SlotPath.unescape((String)historyLabel);
                            }
                            this.report.debugMsg("History Label: " + historyLabel);
                            String historyUnits = currentHistory.getHistoryUnits();
                            this.report.debugMsg("History Units: " + historyUnits);
                            this.processHistory(databaseConn, historyInstance, historyLabel, historyUnits);
                        } else {
                            this.report.errorMsg("Invalid history type: " + historyIdent);
                        }
                    } else {
                        this.report.errorMsg("Invalid history: " + historyIdent);
                    }
                }
                catch (Exception historyInstanceException) {
                    this.report.errorMsg("Invalid history exception [" + currentHistory.getHistoryPath() + "]: " + historyInstanceException);
                    historyInstanceException.printStackTrace();
                }
                if ((long)this.csvText.length() > this.maxExportSize) {
                    this.report.errorMsg("Export too large");
                    break;
                }
                if (!this.cancelOperation) continue;
                break;
            }
            this.report.debugMsg("Day Row History scan complete: " + this.rowCount + " rows generated");
            if (this.rowCount > 0) {
                this.success = true;
            } else {
                this.faultMessage = "No valid history data found";
            }
        }
        catch (Exception historyException) {
            this.faultMessage = "History exception: " + historyException.getMessage();
            this.report.errorMsg("History list exception: " + historyException.getMessage());
            historyException.printStackTrace();
        }
    }

    private void processHistory(HistorySpaceConnection databaseConn, BIHistory historyInstance, String historyLabel, String historyUnits) {
        int rowsForThisHistory = 0;
        BAbsTime dayBegin = this.startTime;
        while (dayBegin.isBefore(this.endTime)) {
            BITable dayRecordsTable = null;
            try {
                dayRecordsTable = databaseConn.timeQuery(historyInstance, dayBegin, dayBegin.add(BRelTime.makeMinutes((int)1499)));
            }
            catch (SyntaxException syntaxException) {
                // empty catch block
            }
            if (dayRecordsTable != null) {
                CharSequence[] columnEntryList = new String[this.columnCount];
                TableCursor historyCursor = dayRecordsTable.cursor();
                int columnIndex = 0;
                block3: while (historyCursor.next() && columnIndex < this.columnCount && !this.cancelOperation) {
                    BHistoryRecord historyEntry = (BHistoryRecord)historyCursor.get();
                    if (!(historyEntry instanceof BNumericTrendRecord) || !historyEntry.getTimestamp().getDate().equals((Object)dayBegin.getDate())) continue;
                    BNumericTrendRecord latestRecord = (BNumericTrendRecord)historyEntry;
                    long recordTimeMs = latestRecord.getTimestamp().getTimeOfDayMillis();
                    while (columnIndex < this.columnCount) {
                        long columnBeginMs = (long)columnIndex * this.columnPeriod.getMillis();
                        long columnEndMs = columnBeginMs + this.columnPeriod.getMillis();
                        if (recordTimeMs < columnBeginMs) continue block3;
                        if (recordTimeMs < columnEndMs) {
                            if (columnEntryList[columnIndex] != null) continue block3;
                            columnEntryList[columnIndex] = this.formatter.format(latestRecord.getNumeric());
                            continue block3;
                        }
                        ++columnIndex;
                        if (!this.cancelOperation) continue;
                        continue block3;
                    }
                }
                historyCursor.close();
                for (columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                    if (columnEntryList[columnIndex] != null) continue;
                    columnEntryList[columnIndex] = this.cellFillValue;
                }
                this.csvText.append(historyLabel);
                this.csvText.append(this.columnDelimiter);
                if (historyUnits != null) {
                    this.csvText.append(historyUnits);
                    this.csvText.append(this.columnDelimiter);
                }
                this.csvText.append(this.formatDateText(dayBegin));
                this.csvText.append(this.columnDelimiter);
                this.csvText.append(String.join((CharSequence)this.columnDelimiter, columnEntryList));
                this.csvText.append("\n");
                ++this.rowCount;
                ++rowsForThisHistory;
                if ((long)this.csvText.length() > this.maxExportSize) {
                    break;
                }
            } else {
                this.report.errorMsg("Invalid day data [" + historyLabel + "/" + dayBegin + "]");
            }
            dayBegin = this.roundTimeToDay(dayBegin.add(BRelTime.DAY));
        }
        this.report.debugMsg("History rows: " + rowsForThisHistory);
    }

    public void generateHeaderRow() {
        LinkedList<String> headerList = new LinkedList<String>();
        headerList.add("Name");
        headerList.add("Units");
        headerList.add("Date");
        BRelTime columnTime = BRelTime.make((long)0L);
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            headerList.add("T" + String.format("%02d:%02d", columnTime.getHours(), columnTime.getMinutesPart()));
            columnTime = BRelTime.make((long)(columnTime.getMillis() + this.columnPeriod.getMillis()));
        }
        this.csvText.append(String.join((CharSequence)this.columnDelimiter, headerList));
        this.csvText.append("\n");
    }

    private String formatDateText(BAbsTime sourceDate) {
        String dateText = null;
        if (sourceDate != null && !sourceDate.isNull()) {
            try {
                dateText = new SimpleDateFormat(this.dateFormat).format(sourceDate.getMillis());
            }
            catch (Exception timeException) {
                timeException.printStackTrace();
            }
        }
        return dateText;
    }

    private BAbsTime roundTimeToDay(BAbsTime sourceDate) {
        return this.roundTimeToDay(sourceDate, 3, 59);
    }

    private BAbsTime roundTimeToDay(BAbsTime sourceDate, int hourWrap, int minuteWrap) {
        BAbsTime refTime = sourceDate.add(BRelTime.make((int)0, (int)hourWrap, (int)minuteWrap, (int)0));
        return BAbsTime.make((int)refTime.getYear(), (BMonth)refTime.getMonth(), (int)refTime.getDay());
    }

    public void cancel() {
        this.cancelOperation = true;
    }

    public boolean succeeded() {
        return this.success;
    }

    public String getCsvText() {
        return this.csvText.toString();
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }
}

