/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.exportDailyRow;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BOssDailyRowHistoryExport;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.DailyRowHistoryExportProcessor;

public class DailyRowExportTask
extends Thread {
    private final BOssDailyRowHistoryExport master;
    private DailyRowHistoryExportProcessor processor = null;
    private boolean runExport = false;
    private volatile boolean abortTask = false;
    public static final int MINIMUM_EXPORT_PERIOD = 50000;

    public DailyRowExportTask(BOssDailyRowHistoryExport newQueryMaster) {
        this.master = newQueryMaster;
        this.setName("OSS-DailyRowExportTask-" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.master.debugMsg("Day row history export task started");
        this.runExport = false;
        this.abortTask = false;
        try {
            this.processor = new DailyRowHistoryExportProcessor(this.master);
            this.master.setCurrentState("Pending");
            while (!this.abortTask) {
                try {
                    long lastExportTime = System.currentTimeMillis();
                    if (this.runExport) {
                        this.processor.exportHistory(lastExportTime);
                    }
                    this.runExport = true;
                    long exportPeriod = this.master.getExportSchedulePeriod().getMillis();
                    if (exportPeriod < 50000L) {
                        exportPeriod = 50000L;
                    }
                    long nextExportTime = lastExportTime + exportPeriod;
                    this.master.setNextExportTime(BAbsTime.make((long)nextExportTime));
                    this.master.debugMsg("Next export @ " + BAbsTime.make((long)nextExportTime).toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)));
                    long waitPeriod = nextExportTime - System.currentTimeMillis();
                    if (waitPeriod < 50000L) {
                        waitPeriod = 50000L;
                    }
                    DailyRowExportTask dailyRowExportTask = this;
                    synchronized (dailyRowExportTask) {
                        this.wait(waitPeriod);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this.processor = null;
        }
        catch (Exception exportException) {
            this.master.setFault("Day row history export exception: " + exportException);
            exportException.printStackTrace();
        }
        this.master.debugMsg("Day row history export task terminated");
    }

    public void wakeTask(boolean runExportFlag) {
        this.runExport = runExportFlag;
        this.notifyAll();
    }

    public void abort() {
        if (this.processor != null) {
            this.processor.cancel();
        }
        this.abortTask = true;
        this.interrupt();
    }
}

