/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.exportDailyRow;

import java.util.logging.Logger;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import solutions.onesight.ossEasyHistoryExport.alarm.BExportAlarm;
import solutions.onesight.ossEasyHistoryExport.export.BColumnSeparator;
import solutions.onesight.ossEasyHistoryExport.export.BEmailConfig;
import solutions.onesight.ossEasyHistoryExport.export.BFtpConfig;
import solutions.onesight.ossEasyHistoryExport.export.BLocalFileConfig;
import solutions.onesight.ossEasyHistoryExport.export.BTransferType;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BDailyRowHistoryList;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BHistoryNameSelection;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BReadingInterval;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.DailyRowExportTask;
import solutions.onesight.ossEasyHistoryExport.ftp.TransferMaster;
import solutions.onesight.ossEasyHistoryExport.history.HistoryExportProcessor;
import solutions.onesight.ossEasyHistoryExport.license.OssEasyHistoryExportLicense;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;
import solutions.onesight.ossEasyHistoryExport.log.Reporter;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="alarm", type="BExportAlarm", defaultValue="new BExportAlarm()"), @NiagaraProperty(name="currentState", type="String", defaultValue="Idle", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="transferType", type="BTransferType", defaultValue="BTransferType.Local"), @NiagaraProperty(name="localConfig", type="BLocalFileConfig", defaultValue="new BLocalFileConfig()"), @NiagaraProperty(name="ftpConfig", type="BFtpConfig", defaultValue="new BFtpConfig()", flags=4), @NiagaraProperty(name="emailConfig", type="BEmailConfig", defaultValue="new BEmailConfig()", flags=4), @NiagaraProperty(name="historyList", type="BDailyRowHistoryList", defaultValue="new BDailyRowHistoryList()", flags=1), @NiagaraProperty(name="exportSchedulePeriod", type="BRelTime", defaultValue="BRelTime.makeDays( 1 )", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="exportRange", type="BRelTime", defaultValue="BRelTime.makeDays( 7 )", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="readingInterval", type="BReadingInterval", defaultValue="BReadingInterval.DEFAULT"), @NiagaraProperty(name="historyNameSelection", type="BHistoryNameSelection", defaultValue="BHistoryNameSelection.DEFAULT"), @NiagaraProperty(name="dateFormat", type="String", defaultValue="new String( \"dd/MM/yyyy\" )"), @NiagaraProperty(name="minNumericPrecision", type="int", defaultValue="0"), @NiagaraProperty(name="maxNumericPrecision", type="int", defaultValue="2"), @NiagaraProperty(name="cellFillValue", type="String", defaultValue="new String(\"0\")"), @NiagaraProperty(name="addHeaderRow", type="boolean", defaultValue="true"), @NiagaraProperty(name="cellPaddingSpaces", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean( \"Enabled\", \"Disabled\" )")}), @NiagaraProperty(name="columnSeparator", type="BColumnSeparator", defaultValue="BColumnSeparator.DEFAULT"), @NiagaraProperty(name="maxExportSize", type="long", defaultValue="1000000000L", facets={@Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="timestampFile", type="boolean", defaultValue="false"), @NiagaraProperty(name="anchorStartToDay", type="boolean", defaultValue="false"), @NiagaraProperty(name="unescapeHistoryNames", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="nextExportTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastExportTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastExportSize", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="export"), @NiagaraAction(name="startExportTask", flags=4), @NiagaraAction(name="stopExportTask", flags=4)})
@NiagaraTopic(name="exportComplete", eventType="BBoolean")
public class BOssDailyRowHistoryExport
extends BComponent
implements TransferMaster,
Reporter {
    public static final Property enabled = BOssDailyRowHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property status = BOssDailyRowHistoryExport.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssDailyRowHistoryExport.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property alarm = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)new BExportAlarm(), null);
    public static final Property currentState = BOssDailyRowHistoryExport.newProperty((int)67, (String)"Idle", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property transferType = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)BTransferType.Local, null);
    public static final Property localConfig = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)new BLocalFileConfig(), null);
    public static final Property ftpConfig = BOssDailyRowHistoryExport.newProperty((int)4, (BValue)new BFtpConfig(), null);
    public static final Property emailConfig = BOssDailyRowHistoryExport.newProperty((int)4, (BValue)new BEmailConfig(), null);
    public static final Property historyList = BOssDailyRowHistoryExport.newProperty((int)1, (BValue)new BDailyRowHistoryList(), null);
    public static final Property exportSchedulePeriod = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)BRelTime.makeDays((int)1), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property exportRange = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)BRelTime.makeDays((int)7), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property readingInterval = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)BReadingInterval.DEFAULT, null);
    public static final Property historyNameSelection = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)BHistoryNameSelection.DEFAULT, null);
    public static final Property dateFormat = BOssDailyRowHistoryExport.newProperty((int)0, (String)new String("dd/MM/yyyy"), null);
    public static final Property minNumericPrecision = BOssDailyRowHistoryExport.newProperty((int)0, (int)0, null);
    public static final Property maxNumericPrecision = BOssDailyRowHistoryExport.newProperty((int)0, (int)2, null);
    public static final Property cellFillValue = BOssDailyRowHistoryExport.newProperty((int)0, (String)new String("0"), null);
    public static final Property addHeaderRow = BOssDailyRowHistoryExport.newProperty((int)0, (boolean)true, null);
    public static final Property cellPaddingSpaces = BOssDailyRowHistoryExport.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
    public static final Property columnSeparator = BOssDailyRowHistoryExport.newProperty((int)0, (BValue)BColumnSeparator.DEFAULT, null);
    public static final Property maxExportSize = BOssDailyRowHistoryExport.newProperty((int)0, (long)1000000000L, (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0));
    public static final Property timestampFile = BOssDailyRowHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property anchorStartToDay = BOssDailyRowHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property unescapeHistoryNames = BOssDailyRowHistoryExport.newProperty((int)4, (boolean)true, null);
    public static final Property nextExportTime = BOssDailyRowHistoryExport.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastExportTime = BOssDailyRowHistoryExport.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastExportSize = BOssDailyRowHistoryExport.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property debugEnabled = BOssDailyRowHistoryExport.newProperty((int)4, (boolean)false, null);
    public static final Action export = BOssDailyRowHistoryExport.newAction((int)0, null);
    public static final Action startExportTask = BOssDailyRowHistoryExport.newAction((int)4, null);
    public static final Action stopExportTask = BOssDailyRowHistoryExport.newAction((int)4, null);
    public static final Topic exportComplete = BOssDailyRowHistoryExport.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssDailyRowHistoryExport.class);
    private DailyRowExportTask exportTask = null;
    private String logPrefix = "DailyRowHistoryExport";
    public static final String DEFAULT_FILE_PATH = "history-export.csv";
    private static final Logger log = OssEasyHistoryExportLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BExportAlarm getAlarm() {
        return (BExportAlarm)this.get(alarm);
    }

    public void setAlarm(BExportAlarm v) {
        this.set(alarm, (BValue)v, null);
    }

    public String getCurrentState() {
        return this.getString(currentState);
    }

    public void setCurrentState(String v) {
        this.setString(currentState, v, null);
    }

    @Override
    public BTransferType getTransferType() {
        return (BTransferType)this.get(transferType);
    }

    public void setTransferType(BTransferType v) {
        this.set(transferType, (BValue)v, null);
    }

    public BLocalFileConfig getLocalConfig() {
        return (BLocalFileConfig)this.get(localConfig);
    }

    public void setLocalConfig(BLocalFileConfig v) {
        this.set(localConfig, (BValue)v, null);
    }

    @Override
    public BFtpConfig getFtpConfig() {
        return (BFtpConfig)this.get(ftpConfig);
    }

    public void setFtpConfig(BFtpConfig v) {
        this.set(ftpConfig, (BValue)v, null);
    }

    public BEmailConfig getEmailConfig() {
        return (BEmailConfig)this.get(emailConfig);
    }

    public void setEmailConfig(BEmailConfig v) {
        this.set(emailConfig, (BValue)v, null);
    }

    public BDailyRowHistoryList getHistoryList() {
        return (BDailyRowHistoryList)this.get(historyList);
    }

    public void setHistoryList(BDailyRowHistoryList v) {
        this.set(historyList, (BValue)v, null);
    }

    public BRelTime getExportSchedulePeriod() {
        return (BRelTime)this.get(exportSchedulePeriod);
    }

    public void setExportSchedulePeriod(BRelTime v) {
        this.set(exportSchedulePeriod, (BValue)v, null);
    }

    public BRelTime getExportRange() {
        return (BRelTime)this.get(exportRange);
    }

    public void setExportRange(BRelTime v) {
        this.set(exportRange, (BValue)v, null);
    }

    public BReadingInterval getReadingInterval() {
        return (BReadingInterval)this.get(readingInterval);
    }

    public void setReadingInterval(BReadingInterval v) {
        this.set(readingInterval, (BValue)v, null);
    }

    public BHistoryNameSelection getHistoryNameSelection() {
        return (BHistoryNameSelection)this.get(historyNameSelection);
    }

    public void setHistoryNameSelection(BHistoryNameSelection v) {
        this.set(historyNameSelection, (BValue)v, null);
    }

    public String getDateFormat() {
        return this.getString(dateFormat);
    }

    public void setDateFormat(String v) {
        this.setString(dateFormat, v, null);
    }

    public int getMinNumericPrecision() {
        return this.getInt(minNumericPrecision);
    }

    public void setMinNumericPrecision(int v) {
        this.setInt(minNumericPrecision, v, null);
    }

    public int getMaxNumericPrecision() {
        return this.getInt(maxNumericPrecision);
    }

    public void setMaxNumericPrecision(int v) {
        this.setInt(maxNumericPrecision, v, null);
    }

    public String getCellFillValue() {
        return this.getString(cellFillValue);
    }

    public void setCellFillValue(String v) {
        this.setString(cellFillValue, v, null);
    }

    public boolean getAddHeaderRow() {
        return this.getBoolean(addHeaderRow);
    }

    public void setAddHeaderRow(boolean v) {
        this.setBoolean(addHeaderRow, v, null);
    }

    public boolean getCellPaddingSpaces() {
        return this.getBoolean(cellPaddingSpaces);
    }

    public void setCellPaddingSpaces(boolean v) {
        this.setBoolean(cellPaddingSpaces, v, null);
    }

    public BColumnSeparator getColumnSeparator() {
        return (BColumnSeparator)this.get(columnSeparator);
    }

    public void setColumnSeparator(BColumnSeparator v) {
        this.set(columnSeparator, (BValue)v, null);
    }

    public long getMaxExportSize() {
        return this.getLong(maxExportSize);
    }

    public void setMaxExportSize(long v) {
        this.setLong(maxExportSize, v, null);
    }

    @Override
    public boolean getTimestampFile() {
        return this.getBoolean(timestampFile);
    }

    public void setTimestampFile(boolean v) {
        this.setBoolean(timestampFile, v, null);
    }

    public boolean getAnchorStartToDay() {
        return this.getBoolean(anchorStartToDay);
    }

    public void setAnchorStartToDay(boolean v) {
        this.setBoolean(anchorStartToDay, v, null);
    }

    public boolean getUnescapeHistoryNames() {
        return this.getBoolean(unescapeHistoryNames);
    }

    public void setUnescapeHistoryNames(boolean v) {
        this.setBoolean(unescapeHistoryNames, v, null);
    }

    public BAbsTime getNextExportTime() {
        return (BAbsTime)this.get(nextExportTime);
    }

    public void setNextExportTime(BAbsTime v) {
        this.set(nextExportTime, (BValue)v, null);
    }

    public BAbsTime getLastExportTime() {
        return (BAbsTime)this.get(lastExportTime);
    }

    public void setLastExportTime(BAbsTime v) {
        this.set(lastExportTime, (BValue)v, null);
    }

    public int getLastExportSize() {
        return this.getInt(lastExportSize);
    }

    public void setLastExportSize(int v) {
        this.setInt(lastExportSize, v, null);
    }

    @Override
    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void export() {
        this.invoke(export, null, null);
    }

    public void startExportTask() {
        this.invoke(startExportTask, null, null);
    }

    public void stopExportTask() {
        this.invoke(stopExportTask, null, null);
    }

    public void fireExportComplete(BBoolean event) {
        this.fire(exportComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.logPrefix = "[" + this.getName() + "] ";
        this.getAlarm().setSource(this);
        if (!OssEasyHistoryExportLicense.checkLicense()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
            this.setCurrentState("Idle");
            if (Sys.atSteadyState()) {
                this.exportTaskStart();
            }
        } else {
            this.setStatus(BStatus.disabled);
            this.setCurrentState("Disabled");
        }
        this.setFaultCause("");
    }

    public void stopped() {
        this.exportTaskStop();
    }

    public void atSteadyState() {
        if (this.getEnabled()) {
            this.exportTaskStart();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                this.setCurrentState("Pending");
                this.exportTaskStart();
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.exportTaskStop();
                this.setCurrentState("Disabled");
            }
        } else if (property == transferType) {
            int configType = this.getTransferType().getOrdinal();
            if (configType == 1) {
                if (this.getFtpConfig().getFtpPort() == 22) {
                    this.getFtpConfig().setFtpPort(21);
                }
            } else if (configType == 2 && this.getFtpConfig().getFtpPort() == 21) {
                this.getFtpConfig().setFtpPort(22);
            }
            if (configType == 3) {
                this.checkLocalFilePath();
                this.setFlags((Slot)ftpConfig, 4);
                this.setFlags((Slot)localConfig, 0);
                this.setFlags((Slot)emailConfig, 4);
            } else if (configType == 4) {
                this.setFlags((Slot)ftpConfig, 4);
                this.setFlags((Slot)localConfig, 4);
                this.setFlags((Slot)emailConfig, 0);
            } else {
                this.setFlags((Slot)ftpConfig, 0);
                this.setFlags((Slot)localConfig, 4);
                this.setFlags((Slot)emailConfig, 4);
            }
        } else if (property == exportSchedulePeriod) {
            this.exportTaskNotify(false);
        }
    }

    public void doExport() {
        if (!OssEasyHistoryExportLicense.isLicensed()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setCurrentState("Disabled");
            log.fine(this.logPrefix + "Disabled");
            return;
        }
        this.exportTaskNotify(true);
    }

    public void doStartExportTask() {
        this.exportTaskStart();
    }

    public void doStopExportTask() {
        this.exportTaskStop();
    }

    public void exportTaskStart() {
        if (!OssEasyHistoryExportLicense.isLicensed()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setCurrentState("Disabled");
            log.fine(this.logPrefix + "Disabled");
            return;
        }
        if (this.getTransferType().getOrdinal() == 4) {
            if (HistoryExportProcessor.checkEmailService() == null) {
                this.setFault("Could not find email service");
                return;
            }
            if (this.getEmailConfig().getEmailAccount().isEmpty()) {
                this.setFault("Email account is not defined");
                return;
            }
            if (this.getEmailConfig().getTo().getAddresses().length < 1) {
                this.setFault("Email destination address (to) is not defined");
                return;
            }
        } else if (this.getTransferType().getOrdinal() != 3) {
            if (this.getFtpConfig().getFtpServerAddress().isEmpty()) {
                this.setFault("FTP Server Address is not defined");
                return;
            }
            if (this.getFtpConfig().getLogin().getUsername().isEmpty()) {
                this.setFault("FTP username is not defined");
                return;
            }
            if (this.getFtpConfig().getRemotePath().isEmpty()) {
                this.setFault("FTP remote path is not defined");
                return;
            }
        }
        if (this.exportTask == null || !this.exportTask.isAlive()) {
            this.exportTask = new DailyRowExportTask(this);
            this.exportTask.start();
        } else {
            this.debugMsg(this.logPrefix + "Export task already running");
        }
    }

    public void exportTaskStop() {
        if (this.exportTask != null) {
            this.exportTask.abort();
            this.exportTask = null;
        }
        this.setNextExportTime(BAbsTime.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTaskNotify(boolean runExportFlag) {
        if (this.exportTask != null) {
            DailyRowExportTask dailyRowExportTask = this.exportTask;
            synchronized (dailyRowExportTask) {
                this.exportTask.wakeTask(runExportFlag);
            }
        }
    }

    public void checkLocalFilePath() {
        if (this.getLocalConfig().getLocalFilePath().format((Object)this).trim().isEmpty()) {
            if (this.getFtpConfig().getRemotePath().trim().isEmpty()) {
                this.getLocalConfig().setLocalFilePath(BFormat.make((String)DEFAULT_FILE_PATH));
            } else {
                this.getLocalConfig().setLocalFilePath(BFormat.make((String)this.getFtpConfig().getRemotePath().trim()));
            }
        }
    }

    public void clearFault() {
        if (this.getStatus().isFault()) {
            this.getAlarm().dispatch(BSourceState.normal);
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    @Override
    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.setCurrentState("Fault @ " + BAbsTime.now());
        log.severe(this.logPrefix + faultMessage);
        this.getAlarm().dispatch(BSourceState.fault);
    }

    @Override
    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest(this.logPrefix + debugMessage);
        }
    }

    @Override
    public void errorMsg(String errorMessage) {
        log.severe(this.logPrefix + errorMessage);
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyHistoryExport/icons/oss-icon-16.png");
    }

    public String getSeparator() {
        BColumnSeparator s = this.getColumnSeparator();
        if (s.equals((Object)BColumnSeparator.comma)) {
            return ",";
        }
        return ";";
    }
}

