/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.exportDailyRow;

import java.util.ArrayList;
import java.util.List;
import javax.baja.history.BIHistory;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import solutions.onesight.ossEasyHistoryExport.exportDailyRow.BDailyRowHistorySelection;
import solutions.onesight.ossEasyHistoryExport.license.OssEasyHistoryExportLicense;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryDiscoveryJob;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyDiscoveryFilter", type="String", defaultValue="", flags=4), @NiagaraProperty(name="historyDiscoveryFilterCaseSensitive", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="historyDiscoveryFilterRegex", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="historyDiscoveryFilterType", type="int", defaultValue="1", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="submitHistoryDiscoveryJob", parameterType="baja:Ord", defaultValue="BOrd.make( \"\" )", returnType="baja:Ord", flags=4), @NiagaraAction(name="addHistory", parameterType="BString", defaultValue="BString.make(\"\")")})
public class BDailyRowHistoryList
extends BComponent {
    public static final Property historyDiscoveryFilter = BDailyRowHistoryList.newProperty((int)4, (String)"", null);
    public static final Property historyDiscoveryFilterCaseSensitive = BDailyRowHistoryList.newProperty((int)4, (boolean)false, null);
    public static final Property historyDiscoveryFilterRegex = BDailyRowHistoryList.newProperty((int)4, (boolean)false, null);
    public static final Property historyDiscoveryFilterType = BDailyRowHistoryList.newProperty((int)4, (int)1, null);
    public static final Action submitHistoryDiscoveryJob = BDailyRowHistoryList.newAction((int)4, (BValue)BOrd.make((String)""), null);
    public static final Action addHistory = BDailyRowHistoryList.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BDailyRowHistoryList.class);

    public String getHistoryDiscoveryFilter() {
        return this.getString(historyDiscoveryFilter);
    }

    public void setHistoryDiscoveryFilter(String v) {
        this.setString(historyDiscoveryFilter, v, null);
    }

    public boolean getHistoryDiscoveryFilterCaseSensitive() {
        return this.getBoolean(historyDiscoveryFilterCaseSensitive);
    }

    public void setHistoryDiscoveryFilterCaseSensitive(boolean v) {
        this.setBoolean(historyDiscoveryFilterCaseSensitive, v, null);
    }

    public boolean getHistoryDiscoveryFilterRegex() {
        return this.getBoolean(historyDiscoveryFilterRegex);
    }

    public void setHistoryDiscoveryFilterRegex(boolean v) {
        this.setBoolean(historyDiscoveryFilterRegex, v, null);
    }

    public int getHistoryDiscoveryFilterType() {
        return this.getInt(historyDiscoveryFilterType);
    }

    public void setHistoryDiscoveryFilterType(int v) {
        this.setInt(historyDiscoveryFilterType, v, null);
    }

    public BOrd submitHistoryDiscoveryJob(BOrd parameter) {
        return (BOrd)this.invoke(submitHistoryDiscoveryJob, (BValue)parameter, null);
    }

    public void addHistory(BString parameter) {
        this.invoke(addHistory, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.lease();
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BDailyRowHistorySelection)) continue;
            this.registerHistory((BDailyRowHistorySelection)childItem);
        }
    }

    public void stopped() {
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BDailyRowHistorySelection)) continue;
            this.removeHistory((BDailyRowHistorySelection)childItem);
        }
    }

    public BOrd doSubmitHistoryDiscoveryJob(BOrd rootOrd) {
        BHistoryDiscoveryJob historyDiscovery = new BHistoryDiscoveryJob(rootOrd, this.getHistoryDiscoveryFilter(), this.getHistoryDiscoveryFilterCaseSensitive(), this.getHistoryDiscoveryFilterRegex(), this.getHistoryDiscoveryFilterType());
        return historyDiscovery.submit(null);
    }

    public void doAddHistory(BString historyId) {
        this.add(historyId.getString());
    }

    public void add(String resourcePath) {
        if (!this.isExisting(resourcePath)) {
            this.add("history1?", (BValue)new BDailyRowHistorySelection(resourcePath));
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context cxt) {
        if (this.isRunning() && value instanceof BDailyRowHistorySelection) {
            this.registerHistory((BDailyRowHistorySelection)value);
        }
    }

    public void added(Property addedProperty, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        BValue addedObject = this.get(addedProperty);
        if (!(addedObject instanceof BDailyRowHistorySelection)) {
            return;
        }
        BDailyRowHistorySelection historySelection = (BDailyRowHistorySelection)addedObject;
        BIHistory historyInstance = null;
        try {
            BOrd historyOrd = BOrd.make((String)("history:" + historySelection.getHistoryPath()));
            BObject historyObject = historyOrd.get((BObject)this);
            if (historyObject instanceof BIHistory) {
                historyInstance = (BIHistory)historyObject;
                this.setDisplayName(addedProperty, BFormat.make((String)SlotPath.unescape((String)historyInstance.getConfig().getId().encodeToString())), null);
            }
        }
        catch (Exception historyOrd) {
            // empty catch block
        }
        if (historyInstance == null) {
            return;
        }
        try {
            BHistoryExt sourceExtension;
            BObject facetObject;
            BOrd sourceOrd;
            BObject sourceObject;
            BOrdList sourceList = historyInstance.getConfig().getSource();
            if (sourceList != null && sourceList.size() > 0 && (sourceObject = (sourceOrd = sourceList.get(0)).get()) instanceof BHistoryExt && (facetObject = (sourceExtension = (BHistoryExt)sourceObject).getPointFacets().getFacet("units")) instanceof BUnit) {
                BUnit historyUnits = (BUnit)facetObject;
                historySelection.setHistoryUnits(historyUnits.getSymbol());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removed(Property prop, BValue oldValue, Context cxt) {
        if (this.isRunning() && oldValue instanceof BDailyRowHistorySelection) {
            this.removeHistory((BDailyRowHistorySelection)oldValue);
        }
    }

    private boolean isExisting(String checkHistoryPath) {
        boolean pathFound = false;
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BDailyRowHistorySelection) || !((BDailyRowHistorySelection)childItem).getHistoryPath().equals(checkHistoryPath)) continue;
            pathFound = true;
            break;
        }
        return pathFound;
    }

    private boolean registerHistory(BDailyRowHistorySelection newHistoryEntry) {
        boolean success = false;
        OssEasyHistoryExportLicense.incrementExportHistoryCount();
        if (OssEasyHistoryExportLicense.checkExportHistoryLimit()) {
            newHistoryEntry.setStatus(BStatus.ok);
            newHistoryEntry.setFaultCause("");
            success = true;
        } else {
            newHistoryEntry.setStatus(BStatus.fault);
            newHistoryEntry.setFaultCause("Exceeded export history license limit");
            OssEasyHistoryExportLog.error("Exceeded export history license limit");
        }
        return success;
    }

    private void removeHistory(BDailyRowHistorySelection historyEntry) {
        OssEasyHistoryExportLicense.decrementExportHistoryCount();
    }

    public List<BDailyRowHistorySelection> getHistoryEntries() {
        ArrayList<BDailyRowHistorySelection> historyPathList = new ArrayList<BDailyRowHistorySelection>();
        for (BDailyRowHistorySelection currentSelection : (BDailyRowHistorySelection[])this.getChildren(BDailyRowHistorySelection.class)) {
            if (!currentSelection.getStatus().isOk()) continue;
            historyPathList.add(currentSelection);
        }
        return historyPathList;
    }
}

