/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.export;

import javax.baja.sys.BAbsTime;
import solutions.onesight.ossEasyHistoryExport.export.BOssMultiHistoryExport;
import solutions.onesight.ossEasyHistoryExport.history.HistoryExportProcessor;

public class HistoryExportTask
extends Thread {
    private final BOssMultiHistoryExport master;
    private volatile boolean abortTask = false;
    public static final int MINIMUM_UPDATE_PERIOD = 10000;

    public HistoryExportTask(BOssMultiHistoryExport newQueryMaster) {
        this.master = newQueryMaster;
        this.setName("OSS-HistoryExportTask-" + this.getId());
    }

    @Override
    public void run() {
        this.master.debugMsg("History export task started");
        this.abortTask = false;
        HistoryExportProcessor processor = new HistoryExportProcessor(this.master);
        try {
            while (!this.abortTask) {
                try {
                    long exportStartTime = System.currentTimeMillis() - this.master.getTimeLimit().getMillis();
                    processor.exportHistory(exportStartTime, System.currentTimeMillis());
                    if (this.master.getAutoExport() && !this.abortTask) {
                        long updatePeriod = this.master.getUpdatePeriod().getMillis();
                        if (updatePeriod < 10000L) {
                            updatePeriod = 10000L;
                        }
                        this.master.debugMsg("Next export @ " + BAbsTime.make((long)(System.currentTimeMillis() + updatePeriod)));
                        Thread.sleep(updatePeriod);
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exportException) {
            this.master.setFault("Export exception: " + exportException);
            exportException.printStackTrace();
        }
        this.master.debugMsg("History export task terminated");
    }

    public void abort() {
        this.abortTask = true;
        this.interrupt();
    }
}

