/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.export;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import solutions.onesight.ossEasyHistoryExport.export.BOssAdvancedHistoryExport;
import solutions.onesight.ossEasyHistoryExport.history.HistoryExportParameters;
import solutions.onesight.ossEasyHistoryExport.history.HistoryExportProcessor;

public class HistoryExportAdvancedTask
extends Thread {
    private final BOssAdvancedHistoryExport master;
    private boolean runExport = false;
    private volatile boolean abortTask = false;

    public HistoryExportAdvancedTask(BOssAdvancedHistoryExport newQueryMaster) {
        this.master = newQueryMaster;
        this.setName("OSS-HistoryExportAdvancedTask-" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.master.debugMsg("History export advanced task started");
        this.abortTask = false;
        params = new HistoryExportParameters();
        processor = new HistoryExportProcessor(this.master);
        try {
            this.master.setCurrentState("Pending");
            this.runExport = false;
            while (!this.abortTask) {
                try {
                    currentTime = System.currentTimeMillis();
                    this.master.debugMsg("Params: CurrentTime: " + currentTime);
                    this.master.debugMsg("Params: ExportSchedule: " + (Object)this.master.getExportSchedule());
                    this.master.debugMsg("Params: ExportDayOfMonth: " + this.master.getExportDayOfMonth());
                    this.master.debugMsg("Params: CustomTimePeriod: " + this.master.getCustomTimePeriod().getSeconds());
                    this.master.debugMsg("Params: ExportScheduleDelay: " + this.master.getExportScheduleDelay().getSeconds());
                    this.master.debugMsg("Params: ExportRange: " + (Object)this.master.getExportRange());
                    this.master.debugMsg("Params: CustomTimeRange: " + this.master.getCustomTimeRange().getSeconds());
                    this.master.debugMsg("Params: StartOfWeek: " + (Object)this.master.getStartOfWeek());
                    if (this.master.getExportSchedule().getOrdinal() == 0) ** GOTO lbl43
                    if (!params.calculate(currentTime, this.master.getExportSchedule(), this.master.getExportDayOfMonth(), this.master.getCustomTimePeriod().getSeconds(), this.master.getExportScheduleDelay().getSeconds(), this.master.getExportRange(), this.master.getCustomTimeRange().getSeconds(), this.master.getEndTimeOffset().getSeconds(), this.master.getStartOfWeek())) {
                        this.master.setFault("Invalid export parameters");
                        this.master.debugMsg("Parameter fault: " + params.getFailMessage());
                        break;
                    }
                    if (this.runExport) {
                        processor.exportHistory(params.getCurrentExportStartTime(), params.getCurrentExportEndTime());
                    }
                    if (this.abortTask) break;
                    this.runExport = true;
                    this.master.setNextExportTime(BAbsTime.make((long)params.getNextExportTime()));
                    this.master.debugMsg("Next export @ " + BAbsTime.make((long)params.getNextExportTime()).toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)));
                    waitPeriod = params.getNextExportTime() - System.currentTimeMillis();
                    if (waitPeriod >= 500L) ** GOTO lbl36
                    if (waitPeriod < 0L) {
                        this.master.setFault("Invalid export wait period: " + waitPeriod);
                    } else {
                        waitPeriod = 10000L;
lbl36:
                        // 2 sources

                        var7_6 = this;
                        synchronized (var7_6) {
                            this.wait(waitPeriod);
                            continue;
                        }
lbl43:
                        // 1 sources

                        this.master.setNextExportTime(BAbsTime.NULL);
                        if (!params.calculate(currentTime, this.master.getExportSchedule(), this.master.getExportDayOfMonth(), this.master.getCustomTimePeriod().getSeconds(), this.master.getExportScheduleDelay().getSeconds(), this.master.getExportRange(), this.master.getCustomTimeRange().getSeconds(), this.master.getEndTimeOffset().getSeconds(), this.master.getStartOfWeek())) {
                            this.master.setFault("Invalid export parameters");
                            this.master.debugMsg("Parameter fault: " + params.getFailMessage());
                        } else {
                            if (this.runExport) {
                                processor.exportHistory(params.getCurrentExportStartTime(), params.getCurrentExportEndTime());
                            }
                            if (!this.abortTask) {
                                this.master.debugMsg("Waiting for manual export");
                                var7_6 = this;
                                synchronized (var7_6) {
                                    this.wait();
                                    continue;
                                }
                            }
                        }
                    }
                    break;
                }
                catch (InterruptedException var7_7) {
                }
            }
        }
        catch (Exception exportException) {
            this.master.setFault("Export exception: " + exportException);
            exportException.printStackTrace();
        }
        this.master.debugMsg("History export advanced task terminated");
    }

    public void wakeTask(boolean runExportFlag) {
        this.runExport = runExportFlag;
        this.notifyAll();
    }

    public void abort() {
        this.abortTask = true;
        this.interrupt();
    }
}

