/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.export;

import java.util.logging.Logger;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import solutions.onesight.ossEasyHistoryExport.alarm.BExportAlarm;
import solutions.onesight.ossEasyHistoryExport.export.BColumnSeparator;
import solutions.onesight.ossEasyHistoryExport.export.BEmailConfig;
import solutions.onesight.ossEasyHistoryExport.export.BEndOfHistoryPolicy;
import solutions.onesight.ossEasyHistoryExport.export.BFtpConfig;
import solutions.onesight.ossEasyHistoryExport.export.BHistoryIdFormat;
import solutions.onesight.ossEasyHistoryExport.export.BLocalFileConfig;
import solutions.onesight.ossEasyHistoryExport.export.BNoChangePolicy;
import solutions.onesight.ossEasyHistoryExport.export.BRowOrder;
import solutions.onesight.ossEasyHistoryExport.export.BTimestampFormat;
import solutions.onesight.ossEasyHistoryExport.export.BTimestampSelection;
import solutions.onesight.ossEasyHistoryExport.export.BTransferType;
import solutions.onesight.ossEasyHistoryExport.export.BUnitsFormat;
import solutions.onesight.ossEasyHistoryExport.export.HistoryExportTask;
import solutions.onesight.ossEasyHistoryExport.history.ExportMaster;
import solutions.onesight.ossEasyHistoryExport.history.HistoryExportProcessor;
import solutions.onesight.ossEasyHistoryExport.license.OssEasyHistoryExportLicense;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryList;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="alarm", type="BExportAlarm", defaultValue="new BExportAlarm()"), @NiagaraProperty(name="currentState", type="String", defaultValue="Idle", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="transferType", type="BTransferType", defaultValue="BTransferType.Sftp"), @NiagaraProperty(name="ftpConfig", type="BFtpConfig", defaultValue="new BFtpConfig()"), @NiagaraProperty(name="localConfig", type="BLocalFileConfig", defaultValue="new BLocalFileConfig()", flags=4), @NiagaraProperty(name="emailConfig", type="BEmailConfig", defaultValue="new BEmailConfig()", flags=4), @NiagaraProperty(name="historyList", type="BHistoryList", defaultValue="new BHistoryList()", flags=1), @NiagaraProperty(name="rowLimit", type="int", defaultValue="1000000000", facets={@Facet(value="BFacets.makeNumeric( BUnit.make( \"rows\", \"rows\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="timeLimit", type="BRelTime", defaultValue="BRelTime.makeDays( 7 )", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="binSize", type="int", defaultValue="300", facets={@Facet(value="BFacets.make( BFacets.UNITS, UnitDatabase.getUnit( \"second\" ) )")}), @NiagaraProperty(name="rowOrder", type="BRowOrder", defaultValue="BRowOrder.AscendingTime"), @NiagaraProperty(name="cellPaddingSpaces", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean( \"Enabled\", \"Disabled\" )")}), @NiagaraProperty(name="columnSeparator", type="BColumnSeparator", defaultValue="BColumnSeparator.DEFAULT"), @NiagaraProperty(name="HistoryIdFormat", type="BHistoryIdFormat", defaultValue="BHistoryIdFormat.DEFAULT"), @NiagaraProperty(name="TimestampFormat", type="BTimestampFormat", defaultValue="BTimestampFormat.Iso8601TimeFormat"), @NiagaraProperty(name="TimestampSelection", type="BTimestampSelection", defaultValue="BTimestampSelection.BinMaxTime"), @NiagaraProperty(name="SeparateDateTimeColumns", type="boolean", defaultValue="false"), @NiagaraProperty(name="minNumericPrecision", type="int", defaultValue="0"), @NiagaraProperty(name="maxNumericPrecision", type="int", defaultValue="2"), @NiagaraProperty(name="EndOfHistoryPolicy", type="BEndOfHistoryPolicy", defaultValue="BEndOfHistoryPolicy.FillWithZero"), @NiagaraProperty(name="NoChangePolicy", type="BNoChangePolicy", defaultValue="BNoChangePolicy.UseLastValue"), @NiagaraProperty(name="timestampFile", type="boolean", defaultValue="false"), @NiagaraProperty(name="sortHistoriesByName", type="boolean", defaultValue="true"), @NiagaraProperty(name="addTypeRow", type="boolean", defaultValue="false"), @NiagaraProperty(name="unitsFormat", type="BUnitsFormat", defaultValue="BUnitsFormat.DEFAULT"), @NiagaraProperty(name="addSummary", type="boolean", defaultValue="false"), @NiagaraProperty(name="autoExport", type="boolean", defaultValue="false"), @NiagaraProperty(name="updatePeriod", type="BRelTime", defaultValue="BRelTime.make( 600000 )", flags=4), @NiagaraProperty(name="unescapeHistoryNames", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lastExportTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastExportSize", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="ignoreHiddenValues", type="boolean", defaultValue="true"), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="export"), @NiagaraAction(name="abortExportTask", flags=4)})
@NiagaraTopic(name="exportComplete", eventType="BBoolean")
public class BOssMultiHistoryExport
extends BComponent
implements ExportMaster {
    public static final Property enabled = BOssMultiHistoryExport.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssMultiHistoryExport.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssMultiHistoryExport.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property alarm = BOssMultiHistoryExport.newProperty((int)0, (BValue)new BExportAlarm(), null);
    public static final Property currentState = BOssMultiHistoryExport.newProperty((int)67, (String)"Idle", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property transferType = BOssMultiHistoryExport.newProperty((int)0, (BValue)BTransferType.Sftp, null);
    public static final Property ftpConfig = BOssMultiHistoryExport.newProperty((int)0, (BValue)new BFtpConfig(), null);
    public static final Property localConfig = BOssMultiHistoryExport.newProperty((int)4, (BValue)new BLocalFileConfig(), null);
    public static final Property emailConfig = BOssMultiHistoryExport.newProperty((int)4, (BValue)new BEmailConfig(), null);
    public static final Property historyList = BOssMultiHistoryExport.newProperty((int)1, (BValue)new BHistoryList(), null);
    public static final Property rowLimit = BOssMultiHistoryExport.newProperty((int)0, (int)1000000000, (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"rows", (String)"rows", (BDimension)BDimension.NULL), (int)0));
    public static final Property timeLimit = BOssMultiHistoryExport.newProperty((int)0, (BValue)BRelTime.makeDays((int)7), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property binSize = BOssMultiHistoryExport.newProperty((int)0, (int)300, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")));
    public static final Property rowOrder = BOssMultiHistoryExport.newProperty((int)0, (BValue)BRowOrder.AscendingTime, null);
    public static final Property cellPaddingSpaces = BOssMultiHistoryExport.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
    public static final Property columnSeparator = BOssMultiHistoryExport.newProperty((int)0, (BValue)BColumnSeparator.DEFAULT, null);
    public static final Property HistoryIdFormat = BOssMultiHistoryExport.newProperty((int)0, (BValue)BHistoryIdFormat.DEFAULT, null);
    public static final Property TimestampFormat = BOssMultiHistoryExport.newProperty((int)0, (BValue)BTimestampFormat.Iso8601TimeFormat, null);
    public static final Property TimestampSelection = BOssMultiHistoryExport.newProperty((int)0, (BValue)BTimestampSelection.BinMaxTime, null);
    public static final Property SeparateDateTimeColumns = BOssMultiHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property minNumericPrecision = BOssMultiHistoryExport.newProperty((int)0, (int)0, null);
    public static final Property maxNumericPrecision = BOssMultiHistoryExport.newProperty((int)0, (int)2, null);
    public static final Property EndOfHistoryPolicy = BOssMultiHistoryExport.newProperty((int)0, (BValue)BEndOfHistoryPolicy.FillWithZero, null);
    public static final Property NoChangePolicy = BOssMultiHistoryExport.newProperty((int)0, (BValue)BNoChangePolicy.UseLastValue, null);
    public static final Property timestampFile = BOssMultiHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property sortHistoriesByName = BOssMultiHistoryExport.newProperty((int)0, (boolean)true, null);
    public static final Property addTypeRow = BOssMultiHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property unitsFormat = BOssMultiHistoryExport.newProperty((int)0, (BValue)BUnitsFormat.DEFAULT, null);
    public static final Property addSummary = BOssMultiHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property autoExport = BOssMultiHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property updatePeriod = BOssMultiHistoryExport.newProperty((int)4, (BValue)BRelTime.make((long)600000L), null);
    public static final Property unescapeHistoryNames = BOssMultiHistoryExport.newProperty((int)4, (boolean)true, null);
    public static final Property lastExportTime = BOssMultiHistoryExport.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastExportSize = BOssMultiHistoryExport.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property ignoreHiddenValues = BOssMultiHistoryExport.newProperty((int)0, (boolean)true, null);
    public static final Property debugEnabled = BOssMultiHistoryExport.newProperty((int)4, (boolean)false, null);
    public static final Action export = BOssMultiHistoryExport.newAction((int)0, null);
    public static final Action abortExportTask = BOssMultiHistoryExport.newAction((int)4, null);
    public static final Topic exportComplete = BOssMultiHistoryExport.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssMultiHistoryExport.class);
    private HistoryExportTask exportTask = null;
    private String logPrefix = "OssMultiHistoryExport";
    public static final String DEFAULT_FILE_PATH = "history-export.csv";
    private static final Logger log = OssEasyHistoryExportLog.getLog();

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BExportAlarm getAlarm() {
        return (BExportAlarm)this.get(alarm);
    }

    public void setAlarm(BExportAlarm v) {
        this.set(alarm, (BValue)v, null);
    }

    public String getCurrentState() {
        return this.getString(currentState);
    }

    @Override
    public void setCurrentState(String v) {
        this.setString(currentState, v, null);
    }

    @Override
    public BTransferType getTransferType() {
        return (BTransferType)this.get(transferType);
    }

    public void setTransferType(BTransferType v) {
        this.set(transferType, (BValue)v, null);
    }

    @Override
    public BFtpConfig getFtpConfig() {
        return (BFtpConfig)this.get(ftpConfig);
    }

    public void setFtpConfig(BFtpConfig v) {
        this.set(ftpConfig, (BValue)v, null);
    }

    @Override
    public BLocalFileConfig getLocalConfig() {
        return (BLocalFileConfig)this.get(localConfig);
    }

    public void setLocalConfig(BLocalFileConfig v) {
        this.set(localConfig, (BValue)v, null);
    }

    @Override
    public BEmailConfig getEmailConfig() {
        return (BEmailConfig)this.get(emailConfig);
    }

    public void setEmailConfig(BEmailConfig v) {
        this.set(emailConfig, (BValue)v, null);
    }

    @Override
    public BHistoryList getHistoryList() {
        return (BHistoryList)this.get(historyList);
    }

    public void setHistoryList(BHistoryList v) {
        this.set(historyList, (BValue)v, null);
    }

    @Override
    public int getRowLimit() {
        return this.getInt(rowLimit);
    }

    public void setRowLimit(int v) {
        this.setInt(rowLimit, v, null);
    }

    public BRelTime getTimeLimit() {
        return (BRelTime)this.get(timeLimit);
    }

    public void setTimeLimit(BRelTime v) {
        this.set(timeLimit, (BValue)v, null);
    }

    @Override
    public int getBinSize() {
        return this.getInt(binSize);
    }

    public void setBinSize(int v) {
        this.setInt(binSize, v, null);
    }

    @Override
    public BRowOrder getRowOrder() {
        return (BRowOrder)this.get(rowOrder);
    }

    public void setRowOrder(BRowOrder v) {
        this.set(rowOrder, (BValue)v, null);
    }

    @Override
    public boolean getCellPaddingSpaces() {
        return this.getBoolean(cellPaddingSpaces);
    }

    public void setCellPaddingSpaces(boolean v) {
        this.setBoolean(cellPaddingSpaces, v, null);
    }

    public BColumnSeparator getColumnSeparator() {
        return (BColumnSeparator)this.get(columnSeparator);
    }

    public void setColumnSeparator(BColumnSeparator v) {
        this.set(columnSeparator, (BValue)v, null);
    }

    @Override
    public BHistoryIdFormat getHistoryIdFormat() {
        return (BHistoryIdFormat)this.get(HistoryIdFormat);
    }

    public void setHistoryIdFormat(BHistoryIdFormat v) {
        this.set(HistoryIdFormat, (BValue)v, null);
    }

    @Override
    public BTimestampFormat getTimestampFormat() {
        return (BTimestampFormat)this.get(TimestampFormat);
    }

    public void setTimestampFormat(BTimestampFormat v) {
        this.set(TimestampFormat, (BValue)v, null);
    }

    @Override
    public BTimestampSelection getTimestampSelection() {
        return (BTimestampSelection)this.get(TimestampSelection);
    }

    public void setTimestampSelection(BTimestampSelection v) {
        this.set(TimestampSelection, (BValue)v, null);
    }

    @Override
    public boolean getSeparateDateTimeColumns() {
        return this.getBoolean(SeparateDateTimeColumns);
    }

    public void setSeparateDateTimeColumns(boolean v) {
        this.setBoolean(SeparateDateTimeColumns, v, null);
    }

    @Override
    public int getMinNumericPrecision() {
        return this.getInt(minNumericPrecision);
    }

    public void setMinNumericPrecision(int v) {
        this.setInt(minNumericPrecision, v, null);
    }

    @Override
    public int getMaxNumericPrecision() {
        return this.getInt(maxNumericPrecision);
    }

    public void setMaxNumericPrecision(int v) {
        this.setInt(maxNumericPrecision, v, null);
    }

    @Override
    public BEndOfHistoryPolicy getEndOfHistoryPolicy() {
        return (BEndOfHistoryPolicy)this.get(EndOfHistoryPolicy);
    }

    public void setEndOfHistoryPolicy(BEndOfHistoryPolicy v) {
        this.set(EndOfHistoryPolicy, (BValue)v, null);
    }

    @Override
    public BNoChangePolicy getNoChangePolicy() {
        return (BNoChangePolicy)this.get(NoChangePolicy);
    }

    public void setNoChangePolicy(BNoChangePolicy v) {
        this.set(NoChangePolicy, (BValue)v, null);
    }

    @Override
    public boolean getTimestampFile() {
        return this.getBoolean(timestampFile);
    }

    public void setTimestampFile(boolean v) {
        this.setBoolean(timestampFile, v, null);
    }

    @Override
    public boolean getSortHistoriesByName() {
        return this.getBoolean(sortHistoriesByName);
    }

    public void setSortHistoriesByName(boolean v) {
        this.setBoolean(sortHistoriesByName, v, null);
    }

    @Override
    public boolean getAddTypeRow() {
        return this.getBoolean(addTypeRow);
    }

    public void setAddTypeRow(boolean v) {
        this.setBoolean(addTypeRow, v, null);
    }

    @Override
    public BUnitsFormat getUnitsFormat() {
        return (BUnitsFormat)this.get(unitsFormat);
    }

    public void setUnitsFormat(BUnitsFormat v) {
        this.set(unitsFormat, (BValue)v, null);
    }

    @Override
    public boolean getAddSummary() {
        return this.getBoolean(addSummary);
    }

    public void setAddSummary(boolean v) {
        this.setBoolean(addSummary, v, null);
    }

    public boolean getAutoExport() {
        return this.getBoolean(autoExport);
    }

    public void setAutoExport(boolean v) {
        this.setBoolean(autoExport, v, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    @Override
    public boolean getUnescapeHistoryNames() {
        return this.getBoolean(unescapeHistoryNames);
    }

    public void setUnescapeHistoryNames(boolean v) {
        this.setBoolean(unescapeHistoryNames, v, null);
    }

    public BAbsTime getLastExportTime() {
        return (BAbsTime)this.get(lastExportTime);
    }

    @Override
    public void setLastExportTime(BAbsTime v) {
        this.set(lastExportTime, (BValue)v, null);
    }

    public int getLastExportSize() {
        return this.getInt(lastExportSize);
    }

    @Override
    public void setLastExportSize(int v) {
        this.setInt(lastExportSize, v, null);
    }

    @Override
    public boolean getIgnoreHiddenValues() {
        return this.getBoolean(ignoreHiddenValues);
    }

    public void setIgnoreHiddenValues(boolean v) {
        this.setBoolean(ignoreHiddenValues, v, null);
    }

    @Override
    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void export() {
        this.invoke(export, null, null);
    }

    public void abortExportTask() {
        this.invoke(abortExportTask, null, null);
    }

    @Override
    public void fireExportComplete(BBoolean event) {
        this.fire(exportComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.logPrefix = "[" + this.getName() + "] ";
        this.getAlarm().setSource(this);
        if (!OssEasyHistoryExportLicense.checkLicense()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
        this.setCurrentState("Idle");
    }

    public void stopped() {
        this.doAbortExportTask();
    }

    public void atSteadyState() {
        if (this.getAutoExport()) {
            this.doExport();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                if (this.getAutoExport()) {
                    this.doExport();
                }
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.doAbortExportTask();
            }
        } else if (property == autoExport) {
            if (this.getAutoExport()) {
                this.setFlags((Slot)updatePeriod, 0);
                if (this.getUpdatePeriod().getSeconds() > 0) {
                    this.doExport();
                } else {
                    this.doAbortExportTask();
                }
            } else {
                this.doAbortExportTask();
                this.setFlags((Slot)updatePeriod, 4);
            }
        } else if (property == updatePeriod) {
            if (this.getAutoExport()) {
                this.setFlags((Slot)updatePeriod, 0);
                if (this.getUpdatePeriod().getSeconds() > 0) {
                    if (this.exportTask != null) {
                        this.exportTask.interrupt();
                    }
                } else {
                    this.doAbortExportTask();
                }
            } else {
                this.doAbortExportTask();
                this.setFlags((Slot)updatePeriod, 4);
            }
        } else if (property == transferType) {
            int configType = this.getTransferType().getOrdinal();
            if (configType == 1) {
                if (this.getFtpConfig().getFtpPort() == 22) {
                    this.getFtpConfig().setFtpPort(21);
                }
            } else if (configType == 2 && this.getFtpConfig().getFtpPort() == 21) {
                this.getFtpConfig().setFtpPort(22);
            }
            if (configType == 3) {
                this.checkLocalFilePath();
                this.setFlags((Slot)ftpConfig, 4);
                this.setFlags((Slot)localConfig, 0);
                this.setFlags((Slot)emailConfig, 4);
            } else if (configType == 4) {
                this.setFlags((Slot)ftpConfig, 4);
                this.setFlags((Slot)localConfig, 4);
                this.setFlags((Slot)emailConfig, 0);
            } else {
                this.setFlags((Slot)ftpConfig, 0);
                this.setFlags((Slot)localConfig, 4);
                this.setFlags((Slot)emailConfig, 4);
            }
        }
    }

    public void doExport() {
        if (!OssEasyHistoryExportLicense.isLicensed()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setCurrentState("Disabled");
            log.fine(this.logPrefix + "Disabled");
            return;
        }
        if (this.getTransferType().getOrdinal() == 4) {
            if (HistoryExportProcessor.checkEmailService() == null) {
                this.setFault("Could not find email service");
                return;
            }
            if (this.getEmailConfig().getEmailAccount().isEmpty()) {
                this.setFault("Email account is not defined");
                return;
            }
            if (this.getEmailConfig().getTo().getAddresses().length < 1) {
                this.setFault("Email destination address (to) is not defined");
                return;
            }
        } else if (this.getTransferType().getOrdinal() != 3) {
            if (this.getFtpConfig().getFtpServerAddress().isEmpty()) {
                this.setFault("FTP Server Address is not defined");
                return;
            }
            if (this.getFtpConfig().getLogin().getUsername().isEmpty()) {
                this.setFault("FTP username is not defined");
                return;
            }
            if (this.getFtpConfig().getRemotePath().isEmpty()) {
                this.setFault("FTP remote path is not defined");
                return;
            }
        }
        if (this.exportTask == null || !this.exportTask.isAlive()) {
            this.exportTask = new HistoryExportTask(this);
            this.exportTask.start();
        } else {
            log.fine(this.logPrefix + "Export already in progress");
        }
    }

    public void doAbortExportTask() {
        if (this.exportTask != null) {
            this.exportTask.abort();
            this.exportTask = null;
        }
    }

    @Override
    public void checkLocalFilePath() {
        if (this.getLocalConfig().getLocalFilePath().format((Object)this).trim().isEmpty()) {
            if (this.getFtpConfig().getRemotePath().trim().isEmpty()) {
                this.getLocalConfig().setLocalFilePath(BFormat.make((String)DEFAULT_FILE_PATH));
            } else {
                this.getLocalConfig().setLocalFilePath(BFormat.make((String)this.getFtpConfig().getRemotePath().trim()));
            }
        }
    }

    @Override
    public long getMaxExportSize() {
        return -1L;
    }

    @Override
    public boolean getSkipDuplicateRowTimes() {
        return false;
    }

    @Override
    public void clearFault() {
        if (this.getStatus().isFault()) {
            this.getAlarm().dispatch(BSourceState.normal);
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    @Override
    public String getSeparator() {
        BColumnSeparator s = this.getColumnSeparator();
        if (s.equals((Object)BColumnSeparator.comma)) {
            return ",";
        }
        return ";";
    }

    @Override
    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.setCurrentState("Fault @ " + BAbsTime.now());
        log.severe(this.logPrefix + faultMessage);
        this.getAlarm().dispatch(BSourceState.fault);
    }

    @Override
    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest(this.logPrefix + debugMessage);
        }
    }

    @Override
    public void errorMsg(String errorMessage) {
        log.severe(this.logPrefix + errorMessage);
    }

    @Override
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyHistoryExport/icons/oss-icon-16.png");
    }
}

