/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.export;

import java.util.logging.Logger;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import solutions.onesight.ossEasyHistoryExport.alarm.BExportAlarm;
import solutions.onesight.ossEasyHistoryExport.export.BColumnSeparator;
import solutions.onesight.ossEasyHistoryExport.export.BEmailConfig;
import solutions.onesight.ossEasyHistoryExport.export.BEndOfHistoryPolicy;
import solutions.onesight.ossEasyHistoryExport.export.BFtpConfig;
import solutions.onesight.ossEasyHistoryExport.export.BHistoryIdFormat;
import solutions.onesight.ossEasyHistoryExport.export.BLocalFileConfig;
import solutions.onesight.ossEasyHistoryExport.export.BNoChangePolicy;
import solutions.onesight.ossEasyHistoryExport.export.BRowOrder;
import solutions.onesight.ossEasyHistoryExport.export.BTimestampFormat;
import solutions.onesight.ossEasyHistoryExport.export.BTimestampSelection;
import solutions.onesight.ossEasyHistoryExport.export.BTransferType;
import solutions.onesight.ossEasyHistoryExport.export.BUnitsFormat;
import solutions.onesight.ossEasyHistoryExport.export.HistoryExportAdvancedTask;
import solutions.onesight.ossEasyHistoryExport.history.BRangeSelection;
import solutions.onesight.ossEasyHistoryExport.history.BScheduleSelection;
import solutions.onesight.ossEasyHistoryExport.history.BWeekdaySelection;
import solutions.onesight.ossEasyHistoryExport.history.ExportMaster;
import solutions.onesight.ossEasyHistoryExport.history.HistoryExportProcessor;
import solutions.onesight.ossEasyHistoryExport.license.OssEasyHistoryExportLicense;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;
import solutions.onesight.ossEasyHistoryExport.selection.BHistoryList;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="alarm", type="BExportAlarm", defaultValue="new BExportAlarm()"), @NiagaraProperty(name="currentState", type="String", defaultValue="Idle", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="transferType", type="BTransferType", defaultValue="BTransferType.Local"), @NiagaraProperty(name="localConfig", type="BLocalFileConfig", defaultValue="new BLocalFileConfig()"), @NiagaraProperty(name="ftpConfig", type="BFtpConfig", defaultValue="new BFtpConfig()", flags=4), @NiagaraProperty(name="emailConfig", type="BEmailConfig", defaultValue="new BEmailConfig()", flags=4), @NiagaraProperty(name="historyList", type="BHistoryList", defaultValue="new BHistoryList()", flags=1), @NiagaraProperty(name="exportSchedule", type="BScheduleSelection", defaultValue="BScheduleSelection.DEFAULT"), @NiagaraProperty(name="customTimePeriod", type="BRelTime", defaultValue="BRelTime.makeDays( 7 )", flags=4, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="startOfWeek", type="BWeekdaySelection", defaultValue="BWeekdaySelection.monday", flags=4), @NiagaraProperty(name="exportDayOfMonth", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="BDouble.make( -30 )"), @Facet(name="BFacets.MAX", value="BDouble.make( 31 )")}), @NiagaraProperty(name="exportScheduleDelay", type="BRelTime", defaultValue="BRelTime.makeMinutes( 5 )"), @NiagaraProperty(name="exportRange", type="BRangeSelection", defaultValue="BRangeSelection.DEFAULT"), @NiagaraProperty(name="customTimeRange", type="BRelTime", defaultValue="BRelTime.makeDays( 7 )", flags=4, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="endTimeOffset", type="BRelTime", defaultValue="BRelTime.make( 0 )", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="rowLimit", type="int", defaultValue="-1", flags=4, facets={@Facet(value="BFacets.makeNumeric( BUnit.make( \"rows\", \"rows\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="maxExportSize", type="long", defaultValue="1000000000L", facets={@Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="binSize", type="int", defaultValue="300", facets={@Facet(value="BFacets.make( BFacets.UNITS, UnitDatabase.getUnit( \"second\" ) )")}), @NiagaraProperty(name="rowOrder", type="BRowOrder", defaultValue="BRowOrder.AscendingTime"), @NiagaraProperty(name="cellPaddingSpaces", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean( \"Enabled\", \"Disabled\" )")}), @NiagaraProperty(name="columnSeparator", type="BColumnSeparator", defaultValue="BColumnSeparator.DEFAULT"), @NiagaraProperty(name="HistoryIdFormat", type="BHistoryIdFormat", defaultValue="BHistoryIdFormat.DEFAULT"), @NiagaraProperty(name="TimestampFormat", type="BTimestampFormat", defaultValue="BTimestampFormat.Iso8601TimeFormat"), @NiagaraProperty(name="TimestampSelection", type="BTimestampSelection", defaultValue="BTimestampSelection.BinMaxTime"), @NiagaraProperty(name="SeparateDateTimeColumns", type="boolean", defaultValue="false"), @NiagaraProperty(name="minNumericPrecision", type="int", defaultValue="0"), @NiagaraProperty(name="maxNumericPrecision", type="int", defaultValue="2"), @NiagaraProperty(name="EndOfHistoryPolicy", type="BEndOfHistoryPolicy", defaultValue="BEndOfHistoryPolicy.FillWithZero"), @NiagaraProperty(name="NoChangePolicy", type="BNoChangePolicy", defaultValue="BNoChangePolicy.UseLastValue"), @NiagaraProperty(name="skipDuplicateRowTimes", type="boolean", defaultValue="false"), @NiagaraProperty(name="timestampFile", type="boolean", defaultValue="false"), @NiagaraProperty(name="sortHistoriesByName", type="boolean", defaultValue="true"), @NiagaraProperty(name="addTypeRow", type="boolean", defaultValue="false"), @NiagaraProperty(name="unitsFormat", type="BUnitsFormat", defaultValue="BUnitsFormat.DEFAULT"), @NiagaraProperty(name="addSummary", type="boolean", defaultValue="false"), @NiagaraProperty(name="unescapeHistoryNames", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="nextExportTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastExportTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastExportSize", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="ignoreHiddenValues", type="boolean", defaultValue="true"), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="export"), @NiagaraAction(name="startExportTask", flags=4), @NiagaraAction(name="stopExportTask", flags=4)})
@NiagaraTopic(name="exportComplete", eventType="BBoolean")
public class BOssAdvancedHistoryExport
extends BComponent
implements ExportMaster {
    public static final Property enabled = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property status = BOssAdvancedHistoryExport.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssAdvancedHistoryExport.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property alarm = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)new BExportAlarm(), null);
    public static final Property currentState = BOssAdvancedHistoryExport.newProperty((int)67, (String)"Idle", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property transferType = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BTransferType.Local, null);
    public static final Property localConfig = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)new BLocalFileConfig(), null);
    public static final Property ftpConfig = BOssAdvancedHistoryExport.newProperty((int)4, (BValue)new BFtpConfig(), null);
    public static final Property emailConfig = BOssAdvancedHistoryExport.newProperty((int)4, (BValue)new BEmailConfig(), null);
    public static final Property historyList = BOssAdvancedHistoryExport.newProperty((int)1, (BValue)new BHistoryList(), null);
    public static final Property exportSchedule = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BScheduleSelection.DEFAULT, null);
    public static final Property customTimePeriod = BOssAdvancedHistoryExport.newProperty((int)4, (BValue)BRelTime.makeDays((int)7), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property startOfWeek = BOssAdvancedHistoryExport.newProperty((int)4, (BValue)BWeekdaySelection.monday, null);
    public static final Property exportDayOfMonth = BOssAdvancedHistoryExport.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)-30.0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BDouble.make((double)31.0))));
    public static final Property exportScheduleDelay = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property exportRange = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BRangeSelection.DEFAULT, null);
    public static final Property customTimeRange = BOssAdvancedHistoryExport.newProperty((int)4, (BValue)BRelTime.makeDays((int)7), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property endTimeOffset = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property rowLimit = BOssAdvancedHistoryExport.newProperty((int)4, (int)-1, (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"rows", (String)"rows", (BDimension)BDimension.NULL), (int)0));
    public static final Property maxExportSize = BOssAdvancedHistoryExport.newProperty((int)0, (long)1000000000L, (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0));
    public static final Property binSize = BOssAdvancedHistoryExport.newProperty((int)0, (int)300, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")));
    public static final Property rowOrder = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BRowOrder.AscendingTime, null);
    public static final Property cellPaddingSpaces = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
    public static final Property columnSeparator = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BColumnSeparator.DEFAULT, null);
    public static final Property HistoryIdFormat = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BHistoryIdFormat.DEFAULT, null);
    public static final Property TimestampFormat = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BTimestampFormat.Iso8601TimeFormat, null);
    public static final Property TimestampSelection = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BTimestampSelection.BinMaxTime, null);
    public static final Property SeparateDateTimeColumns = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property minNumericPrecision = BOssAdvancedHistoryExport.newProperty((int)0, (int)0, null);
    public static final Property maxNumericPrecision = BOssAdvancedHistoryExport.newProperty((int)0, (int)2, null);
    public static final Property EndOfHistoryPolicy = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BEndOfHistoryPolicy.FillWithZero, null);
    public static final Property NoChangePolicy = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BNoChangePolicy.UseLastValue, null);
    public static final Property skipDuplicateRowTimes = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property timestampFile = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property sortHistoriesByName = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)true, null);
    public static final Property addTypeRow = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property unitsFormat = BOssAdvancedHistoryExport.newProperty((int)0, (BValue)BUnitsFormat.DEFAULT, null);
    public static final Property addSummary = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property unescapeHistoryNames = BOssAdvancedHistoryExport.newProperty((int)4, (boolean)true, null);
    public static final Property nextExportTime = BOssAdvancedHistoryExport.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastExportTime = BOssAdvancedHistoryExport.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastExportSize = BOssAdvancedHistoryExport.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property ignoreHiddenValues = BOssAdvancedHistoryExport.newProperty((int)0, (boolean)true, null);
    public static final Property debugEnabled = BOssAdvancedHistoryExport.newProperty((int)4, (boolean)false, null);
    public static final Action export = BOssAdvancedHistoryExport.newAction((int)0, null);
    public static final Action startExportTask = BOssAdvancedHistoryExport.newAction((int)4, null);
    public static final Action stopExportTask = BOssAdvancedHistoryExport.newAction((int)4, null);
    public static final Topic exportComplete = BOssAdvancedHistoryExport.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssAdvancedHistoryExport.class);
    private HistoryExportAdvancedTask exportTask = null;
    private String logPrefix = "OssAdvancedHistoryExport";
    public static final String DEFAULT_FILE_PATH = "history-export.csv";
    private static final Logger log = OssEasyHistoryExportLog.getLog();

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BExportAlarm getAlarm() {
        return (BExportAlarm)this.get(alarm);
    }

    public void setAlarm(BExportAlarm v) {
        this.set(alarm, (BValue)v, null);
    }

    public String getCurrentState() {
        return this.getString(currentState);
    }

    @Override
    public void setCurrentState(String v) {
        this.setString(currentState, v, null);
    }

    @Override
    public BTransferType getTransferType() {
        return (BTransferType)this.get(transferType);
    }

    public void setTransferType(BTransferType v) {
        this.set(transferType, (BValue)v, null);
    }

    @Override
    public BLocalFileConfig getLocalConfig() {
        return (BLocalFileConfig)this.get(localConfig);
    }

    public void setLocalConfig(BLocalFileConfig v) {
        this.set(localConfig, (BValue)v, null);
    }

    @Override
    public BFtpConfig getFtpConfig() {
        return (BFtpConfig)this.get(ftpConfig);
    }

    public void setFtpConfig(BFtpConfig v) {
        this.set(ftpConfig, (BValue)v, null);
    }

    @Override
    public BEmailConfig getEmailConfig() {
        return (BEmailConfig)this.get(emailConfig);
    }

    public void setEmailConfig(BEmailConfig v) {
        this.set(emailConfig, (BValue)v, null);
    }

    @Override
    public BHistoryList getHistoryList() {
        return (BHistoryList)this.get(historyList);
    }

    public void setHistoryList(BHistoryList v) {
        this.set(historyList, (BValue)v, null);
    }

    public BScheduleSelection getExportSchedule() {
        return (BScheduleSelection)this.get(exportSchedule);
    }

    public void setExportSchedule(BScheduleSelection v) {
        this.set(exportSchedule, (BValue)v, null);
    }

    public BRelTime getCustomTimePeriod() {
        return (BRelTime)this.get(customTimePeriod);
    }

    public void setCustomTimePeriod(BRelTime v) {
        this.set(customTimePeriod, (BValue)v, null);
    }

    public BWeekdaySelection getStartOfWeek() {
        return (BWeekdaySelection)this.get(startOfWeek);
    }

    public void setStartOfWeek(BWeekdaySelection v) {
        this.set(startOfWeek, (BValue)v, null);
    }

    public int getExportDayOfMonth() {
        return this.getInt(exportDayOfMonth);
    }

    public void setExportDayOfMonth(int v) {
        this.setInt(exportDayOfMonth, v, null);
    }

    public BRelTime getExportScheduleDelay() {
        return (BRelTime)this.get(exportScheduleDelay);
    }

    public void setExportScheduleDelay(BRelTime v) {
        this.set(exportScheduleDelay, (BValue)v, null);
    }

    public BRangeSelection getExportRange() {
        return (BRangeSelection)this.get(exportRange);
    }

    public void setExportRange(BRangeSelection v) {
        this.set(exportRange, (BValue)v, null);
    }

    public BRelTime getCustomTimeRange() {
        return (BRelTime)this.get(customTimeRange);
    }

    public void setCustomTimeRange(BRelTime v) {
        this.set(customTimeRange, (BValue)v, null);
    }

    public BRelTime getEndTimeOffset() {
        return (BRelTime)this.get(endTimeOffset);
    }

    public void setEndTimeOffset(BRelTime v) {
        this.set(endTimeOffset, (BValue)v, null);
    }

    @Override
    public int getRowLimit() {
        return this.getInt(rowLimit);
    }

    public void setRowLimit(int v) {
        this.setInt(rowLimit, v, null);
    }

    @Override
    public long getMaxExportSize() {
        return this.getLong(maxExportSize);
    }

    public void setMaxExportSize(long v) {
        this.setLong(maxExportSize, v, null);
    }

    @Override
    public int getBinSize() {
        return this.getInt(binSize);
    }

    public void setBinSize(int v) {
        this.setInt(binSize, v, null);
    }

    @Override
    public BRowOrder getRowOrder() {
        return (BRowOrder)this.get(rowOrder);
    }

    public void setRowOrder(BRowOrder v) {
        this.set(rowOrder, (BValue)v, null);
    }

    @Override
    public boolean getCellPaddingSpaces() {
        return this.getBoolean(cellPaddingSpaces);
    }

    public void setCellPaddingSpaces(boolean v) {
        this.setBoolean(cellPaddingSpaces, v, null);
    }

    public BColumnSeparator getColumnSeparator() {
        return (BColumnSeparator)this.get(columnSeparator);
    }

    public void setColumnSeparator(BColumnSeparator v) {
        this.set(columnSeparator, (BValue)v, null);
    }

    @Override
    public BHistoryIdFormat getHistoryIdFormat() {
        return (BHistoryIdFormat)this.get(HistoryIdFormat);
    }

    public void setHistoryIdFormat(BHistoryIdFormat v) {
        this.set(HistoryIdFormat, (BValue)v, null);
    }

    @Override
    public BTimestampFormat getTimestampFormat() {
        return (BTimestampFormat)this.get(TimestampFormat);
    }

    public void setTimestampFormat(BTimestampFormat v) {
        this.set(TimestampFormat, (BValue)v, null);
    }

    @Override
    public BTimestampSelection getTimestampSelection() {
        return (BTimestampSelection)this.get(TimestampSelection);
    }

    public void setTimestampSelection(BTimestampSelection v) {
        this.set(TimestampSelection, (BValue)v, null);
    }

    @Override
    public boolean getSeparateDateTimeColumns() {
        return this.getBoolean(SeparateDateTimeColumns);
    }

    public void setSeparateDateTimeColumns(boolean v) {
        this.setBoolean(SeparateDateTimeColumns, v, null);
    }

    @Override
    public int getMinNumericPrecision() {
        return this.getInt(minNumericPrecision);
    }

    public void setMinNumericPrecision(int v) {
        this.setInt(minNumericPrecision, v, null);
    }

    @Override
    public int getMaxNumericPrecision() {
        return this.getInt(maxNumericPrecision);
    }

    public void setMaxNumericPrecision(int v) {
        this.setInt(maxNumericPrecision, v, null);
    }

    @Override
    public BEndOfHistoryPolicy getEndOfHistoryPolicy() {
        return (BEndOfHistoryPolicy)this.get(EndOfHistoryPolicy);
    }

    public void setEndOfHistoryPolicy(BEndOfHistoryPolicy v) {
        this.set(EndOfHistoryPolicy, (BValue)v, null);
    }

    @Override
    public BNoChangePolicy getNoChangePolicy() {
        return (BNoChangePolicy)this.get(NoChangePolicy);
    }

    public void setNoChangePolicy(BNoChangePolicy v) {
        this.set(NoChangePolicy, (BValue)v, null);
    }

    @Override
    public boolean getSkipDuplicateRowTimes() {
        return this.getBoolean(skipDuplicateRowTimes);
    }

    public void setSkipDuplicateRowTimes(boolean v) {
        this.setBoolean(skipDuplicateRowTimes, v, null);
    }

    @Override
    public boolean getTimestampFile() {
        return this.getBoolean(timestampFile);
    }

    public void setTimestampFile(boolean v) {
        this.setBoolean(timestampFile, v, null);
    }

    @Override
    public boolean getSortHistoriesByName() {
        return this.getBoolean(sortHistoriesByName);
    }

    public void setSortHistoriesByName(boolean v) {
        this.setBoolean(sortHistoriesByName, v, null);
    }

    @Override
    public boolean getAddTypeRow() {
        return this.getBoolean(addTypeRow);
    }

    public void setAddTypeRow(boolean v) {
        this.setBoolean(addTypeRow, v, null);
    }

    @Override
    public BUnitsFormat getUnitsFormat() {
        return (BUnitsFormat)this.get(unitsFormat);
    }

    public void setUnitsFormat(BUnitsFormat v) {
        this.set(unitsFormat, (BValue)v, null);
    }

    @Override
    public boolean getAddSummary() {
        return this.getBoolean(addSummary);
    }

    public void setAddSummary(boolean v) {
        this.setBoolean(addSummary, v, null);
    }

    @Override
    public boolean getUnescapeHistoryNames() {
        return this.getBoolean(unescapeHistoryNames);
    }

    public void setUnescapeHistoryNames(boolean v) {
        this.setBoolean(unescapeHistoryNames, v, null);
    }

    public BAbsTime getNextExportTime() {
        return (BAbsTime)this.get(nextExportTime);
    }

    public void setNextExportTime(BAbsTime v) {
        this.set(nextExportTime, (BValue)v, null);
    }

    public BAbsTime getLastExportTime() {
        return (BAbsTime)this.get(lastExportTime);
    }

    @Override
    public void setLastExportTime(BAbsTime v) {
        this.set(lastExportTime, (BValue)v, null);
    }

    public int getLastExportSize() {
        return this.getInt(lastExportSize);
    }

    @Override
    public void setLastExportSize(int v) {
        this.setInt(lastExportSize, v, null);
    }

    @Override
    public boolean getIgnoreHiddenValues() {
        return this.getBoolean(ignoreHiddenValues);
    }

    public void setIgnoreHiddenValues(boolean v) {
        this.setBoolean(ignoreHiddenValues, v, null);
    }

    @Override
    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void export() {
        this.invoke(export, null, null);
    }

    public void startExportTask() {
        this.invoke(startExportTask, null, null);
    }

    public void stopExportTask() {
        this.invoke(stopExportTask, null, null);
    }

    @Override
    public void fireExportComplete(BBoolean event) {
        this.fire(exportComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.logPrefix = "[" + this.getName() + "] ";
        this.getAlarm().setSource(this);
        if (!OssEasyHistoryExportLicense.checkLicense()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
            this.setCurrentState("Idle");
            if (Sys.atSteadyState()) {
                this.exportTaskStart();
            }
        } else {
            this.setStatus(BStatus.disabled);
            this.setCurrentState("Disabled");
        }
        this.setFaultCause("");
    }

    public void stopped() {
        this.exportTaskStop();
    }

    public void atSteadyState() {
        if (this.getEnabled()) {
            this.exportTaskStart();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                this.setCurrentState("Pending");
                this.exportTaskStart();
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.exportTaskStop();
                this.setCurrentState("Disabled");
            }
        } else if (property == transferType) {
            int configType = this.getTransferType().getOrdinal();
            if (configType == 1) {
                if (this.getFtpConfig().getFtpPort() == 22) {
                    this.getFtpConfig().setFtpPort(21);
                }
            } else if (configType == 2 && this.getFtpConfig().getFtpPort() == 21) {
                this.getFtpConfig().setFtpPort(22);
            }
            if (configType == 3) {
                this.checkLocalFilePath();
                this.setFlags((Slot)ftpConfig, 4);
                this.setFlags((Slot)localConfig, 0);
                this.setFlags((Slot)emailConfig, 4);
            } else if (configType == 4) {
                this.setFlags((Slot)ftpConfig, 4);
                this.setFlags((Slot)localConfig, 4);
                this.setFlags((Slot)emailConfig, 0);
            } else {
                this.setFlags((Slot)ftpConfig, 0);
                this.setFlags((Slot)localConfig, 4);
                this.setFlags((Slot)emailConfig, 4);
            }
        } else if (property == exportSchedule) {
            if (this.getExportSchedule().getOrdinal() == 2) {
                this.setFlags((Slot)startOfWeek, 0);
                this.setFlags((Slot)exportDayOfMonth, 4);
                this.setFlags((Slot)customTimePeriod, 4);
            } else if (this.getExportSchedule().getOrdinal() == 3) {
                this.setFlags((Slot)startOfWeek, 4);
                this.setFlags((Slot)exportDayOfMonth, 0);
                this.setFlags((Slot)customTimePeriod, 4);
            } else if (this.getExportSchedule().getOrdinal() == 100) {
                this.setFlags((Slot)startOfWeek, 4);
                this.setFlags((Slot)exportDayOfMonth, 4);
                this.setFlags((Slot)customTimePeriod, 0);
            } else {
                this.setFlags((Slot)startOfWeek, 4);
                this.setFlags((Slot)exportDayOfMonth, 4);
                this.setFlags((Slot)customTimePeriod, 4);
            }
            this.exportTaskNotify(false);
        } else if (property == customTimePeriod) {
            this.exportTaskNotify(false);
        } else if (property == exportScheduleDelay) {
            if (this.getExportScheduleDelay().getSeconds() < 0) {
                this.setExportScheduleDelay(this.getExportScheduleDelay().abs());
            }
            this.exportTaskNotify(false);
        } else if (property == startOfWeek) {
            this.exportTaskNotify(false);
        } else if (property == exportDayOfMonth) {
            this.exportTaskNotify(false);
        } else if (property == exportRange) {
            if (this.getExportRange().getOrdinal() == 100) {
                this.setFlags((Slot)customTimeRange, 0);
            } else {
                this.setFlags((Slot)customTimeRange, 4);
            }
        }
    }

    public void doExport() {
        if (!OssEasyHistoryExportLicense.isLicensed()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setCurrentState("Disabled");
            log.fine(this.logPrefix + "Disabled");
            return;
        }
        this.exportTaskNotify(true);
    }

    public void doStartExportTask() {
        this.exportTaskStart();
    }

    public void doStopExportTask() {
        this.exportTaskStop();
    }

    public void exportTaskStart() {
        if (!OssEasyHistoryExportLicense.isLicensed()) {
            this.setFault("ossEasyHistoryExport is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setCurrentState("Disabled");
            log.fine(this.logPrefix + "Disabled");
            return;
        }
        if (this.getTransferType().getOrdinal() == 4) {
            if (HistoryExportProcessor.checkEmailService() == null) {
                this.setFault("Could not find email service");
                return;
            }
            if (this.getEmailConfig().getEmailAccount().isEmpty()) {
                this.setFault("Email account is not defined");
                return;
            }
            if (this.getEmailConfig().getTo().getAddresses().length < 1) {
                this.setFault("Email destination address (to) is not defined");
                return;
            }
        } else if (this.getTransferType().getOrdinal() != 3) {
            if (this.getFtpConfig().getFtpServerAddress().isEmpty()) {
                this.setFault("FTP Server Address is not defined");
                return;
            }
            if (this.getFtpConfig().getLogin().getUsername().isEmpty()) {
                this.setFault("FTP username is not defined");
                return;
            }
            if (this.getFtpConfig().getRemotePath().isEmpty()) {
                this.setFault("FTP remote path is not defined");
                return;
            }
        }
        if (this.exportTask == null || !this.exportTask.isAlive()) {
            this.exportTask = new HistoryExportAdvancedTask(this);
            this.exportTask.start();
        } else {
            this.debugMsg(this.logPrefix + "Export task already running");
        }
    }

    public void exportTaskStop() {
        if (this.exportTask != null) {
            this.exportTask.abort();
            this.exportTask = null;
        }
        this.setNextExportTime(BAbsTime.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTaskNotify(boolean runExportFlag) {
        if (this.exportTask != null) {
            HistoryExportAdvancedTask historyExportAdvancedTask = this.exportTask;
            synchronized (historyExportAdvancedTask) {
                this.exportTask.wakeTask(runExportFlag);
            }
        }
    }

    @Override
    public void checkLocalFilePath() {
        if (this.getLocalConfig().getLocalFilePath().format((Object)this).trim().isEmpty()) {
            if (this.getFtpConfig().getRemotePath().trim().isEmpty()) {
                this.getLocalConfig().setLocalFilePath(BFormat.make((String)DEFAULT_FILE_PATH));
            } else {
                this.getLocalConfig().setLocalFilePath(BFormat.make((String)this.getFtpConfig().getRemotePath().trim()));
            }
        }
    }

    @Override
    public void clearFault() {
        if (this.getStatus().isFault()) {
            this.getAlarm().dispatch(BSourceState.normal);
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    @Override
    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.setCurrentState("Fault @ " + BAbsTime.now());
        log.severe(this.logPrefix + faultMessage);
        this.getAlarm().dispatch(BSourceState.fault);
    }

    @Override
    public String getSeparator() {
        BColumnSeparator s = this.getColumnSeparator();
        if (s.equals((Object)BColumnSeparator.comma)) {
            return ",";
        }
        return ";";
    }

    @Override
    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest(this.logPrefix + debugMessage);
        }
    }

    @Override
    public void errorMsg(String errorMessage) {
        log.severe(this.logPrefix + errorMessage);
    }

    @Override
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyHistoryExport/icons/oss-icon-16.png");
    }
}

