/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyHistoryExport.alarm;

import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import solutions.onesight.ossEasyHistoryExport.log.OssEasyHistoryExportLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make( \"alarm:AlarmClassFE\" )")}), @NiagaraProperty(name="alarmSourceName", type="BFormat", defaultValue="BFormat.make( \"%parent.displayName%/%displayName%\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="toFaultMessage", type="BFormat", defaultValue="BFormat.make( \"Fault: %faultCause%\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="toNormalMessage", type="BFormat", defaultValue="BFormat.make( \"OK\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="lastAlarmTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="toNormal")
public class BExportAlarm
extends BComponent {
    public static final Property alarmEnabled = BExportAlarm.newProperty((int)0, (boolean)false, null);
    public static final Property alarmClass = BExportAlarm.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property alarmSourceName = BExportAlarm.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%/%displayName%"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property toFaultMessage = BExportAlarm.newProperty((int)0, (BValue)BFormat.make((String)"Fault: %faultCause%"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property toNormalMessage = BExportAlarm.newProperty((int)0, (BValue)BFormat.make((String)"OK"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property lastAlarmTime = BExportAlarm.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnabled = BExportAlarm.newProperty((int)4, (boolean)false, null);
    public static final Action toNormal = BExportAlarm.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BExportAlarm.class);
    private BComponent sourceObject = null;
    private static final Logger log = OssEasyHistoryExportLog.getLog();

    public boolean getAlarmEnabled() {
        return this.getBoolean(alarmEnabled);
    }

    public void setAlarmEnabled(boolean v) {
        this.setBoolean(alarmEnabled, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BFormat getAlarmSourceName() {
        return (BFormat)this.get(alarmSourceName);
    }

    public void setAlarmSourceName(BFormat v) {
        this.set(alarmSourceName, (BValue)v, null);
    }

    public BFormat getToFaultMessage() {
        return (BFormat)this.get(toFaultMessage);
    }

    public void setToFaultMessage(BFormat v) {
        this.set(toFaultMessage, (BValue)v, null);
    }

    public BFormat getToNormalMessage() {
        return (BFormat)this.get(toNormalMessage);
    }

    public void setToNormalMessage(BFormat v) {
        this.set(toNormalMessage, (BValue)v, null);
    }

    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    public void setLastAlarmTime(BAbsTime v) {
        this.set(lastAlarmTime, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void toNormal() {
        this.invoke(toNormal, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setSource(BComponent newSource) {
        this.sourceObject = newSource;
    }

    public final void dispatch(BSourceState alarmState) {
        BAlarmService alarmService;
        if (this.getAlarmEnabled() && (alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE)) != null && this.sourceObject != null) {
            String sourcePathText = this.getAlarmSourceName().format((Object)this.sourceObject);
            String alarmMessageText = alarmState.getOrdinal() == 0 ? this.getToNormalMessage().format((Object)this.sourceObject) : this.getToFaultMessage().format((Object)this.sourceObject);
            BFacets alarmFacets = BFacets.make((String)"msgText", (BIDataValue)BString.make((String)alarmMessageText), (String)"sourceName", (BIDataValue)BString.make((String)sourcePathText));
            BAlarmRecord alarmRecord = new BAlarmRecord();
            alarmRecord.setSource(BOrdList.make((BOrd)this.sourceObject.getNavOrd()));
            alarmRecord.setAlarmClass(this.getAlarmClass());
            alarmRecord.setAlarmTransition(alarmState);
            alarmRecord.setSourceState(alarmState);
            alarmRecord.setAckRequired(true);
            alarmRecord.setAlarmData(alarmFacets);
            alarmService.routeAlarm(alarmRecord);
            this.setLastAlarmTime(BAbsTime.now());
            if (this.getDebugEnabled()) {
                if (alarmState.getOrdinal() == 0) {
                    log.fine("Alarm Normal [" + sourcePathText + "]: " + alarmMessageText);
                } else {
                    log.warning("Alarm Fault [" + sourcePathText + "]: " + alarmMessageText);
                }
            }
        }
    }

    public void doToNormal() {
        this.dispatch(BSourceState.normal);
    }
}

