/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.url;

import com.oss.ossEasyAPI.tools.url.BUrlBuilder;
import com.oss.ossEasyAPI.utils.BajaUtils;
import java.util.LinkedList;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addParameter", parameterType="BString", defaultValue="BString.make(\"\")"), @NiagaraAction(name="removeParameter", parameterType="BString", defaultValue="BString.make(\"\")")})
public class BUrlParameters
extends BComponent {
    public static final Action addParameter = BUrlParameters.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action removeParameter = BUrlParameters.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BUrlParameters.class);

    public void addParameter(BString parameter) {
        this.invoke(addParameter, (BValue)parameter, null);
    }

    public void removeParameter(BString parameter) {
        this.invoke(removeParameter, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        ((BUrlBuilder)this.getParent()).doGenerate();
    }

    public void doAddParameter(BString parameterName) {
        String slotName = BajaUtils.sanitiseSlotName(parameterName.getString());
        Property newSlot = this.add(slotName, (BValue)BString.make((String)""));
        this.setFacets((Slot)newSlot, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
        ((BUrlBuilder)this.getParent()).doGenerate();
    }

    public void doRemoveParameter(BString parameterName) {
        String slotName = BajaUtils.sanitiseSlotName(parameterName.getString());
        for (Property child : this.getPropertiesArray()) {
            if (!slotName.equalsIgnoreCase(child.getName())) continue;
            this.remove(child);
        }
        ((BUrlBuilder)this.getParent()).doGenerate();
    }

    public String getParameterString() {
        LinkedList<String> parameterList = new LinkedList<String>();
        for (Property child : this.getDynamicPropertiesArray()) {
            if (!child.getType().is(BString.TYPE)) continue;
            String parameterName = this.getDisplayName((Slot)child, null);
            String parameterValue = this.get(child).toString();
            if (parameterValue.isEmpty()) {
                parameterList.add(parameterName);
                continue;
            }
            parameterList.add(parameterName + "=" + parameterValue);
        }
        if (parameterList.size() > 0) {
            return "?" + String.join((CharSequence)"&", parameterList);
        }
        return "";
    }
}

