/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.time;

import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enable", type="boolean", flags=256, defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="useCurrentTime", type="boolean", defaultValue="true", flags=256), @NiagaraProperty(name="timeInput", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=328, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="epochSeconds", type="long", defaultValue="0", flags=65), @NiagaraProperty(name="epochMilliseconds", type="long", defaultValue="0", flags=65), @NiagaraProperty(name="isoUtcTime", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="customTime", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="customTimeFormat", type="String", defaultValue="EEE, dd MMM yyyy HH:mm:ss zzz", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65601, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnable", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="update", flags=8)
@NiagaraTopic(name="updatedTrigger", eventType="BBoolean", flags=8)
public final class BTimeEncode
extends BComponent {
    public static final Property enable = BTimeEncode.newProperty((int)256, (boolean)true, null);
    public static final Property status = BTimeEncode.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BTimeEncode.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property useCurrentTime = BTimeEncode.newProperty((int)256, (boolean)true, null);
    public static final Property timeInput = BTimeEncode.newProperty((int)328, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property epochSeconds = BTimeEncode.newProperty((int)65, (int)0, null);
    public static final Property epochMilliseconds = BTimeEncode.newProperty((int)65, (int)0, null);
    public static final Property isoUtcTime = BTimeEncode.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property customTime = BTimeEncode.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property customTimeFormat = BTimeEncode.newProperty((int)0, (String)"EEE, dd MMM yyyy HH:mm:ss zzz", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property lastUpdate = BTimeEncode.newProperty((int)65601, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnable = BTimeEncode.newProperty((int)4, (boolean)false, null);
    public static final Action update = BTimeEncode.newAction((int)8, null);
    public static final Topic updatedTrigger = BTimeEncode.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BTimeEncode.class);

    public boolean getEnable() {
        return this.getBoolean(enable);
    }

    public void setEnable(boolean v) {
        this.setBoolean(enable, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getUseCurrentTime() {
        return this.getBoolean(useCurrentTime);
    }

    public void setUseCurrentTime(boolean v) {
        this.setBoolean(useCurrentTime, v, null);
    }

    public BAbsTime getTimeInput() {
        return (BAbsTime)this.get(timeInput);
    }

    public void setTimeInput(BAbsTime v) {
        this.set(timeInput, (BValue)v, null);
    }

    public long getEpochSeconds() {
        return this.getLong(epochSeconds);
    }

    public void setEpochSeconds(long v) {
        this.setLong(epochSeconds, v, null);
    }

    public long getEpochMilliseconds() {
        return this.getLong(epochMilliseconds);
    }

    public void setEpochMilliseconds(long v) {
        this.setLong(epochMilliseconds, v, null);
    }

    public String getIsoUtcTime() {
        return this.getString(isoUtcTime);
    }

    public void setIsoUtcTime(String v) {
        this.setString(isoUtcTime, v, null);
    }

    public String getCustomTime() {
        return this.getString(customTime);
    }

    public void setCustomTime(String v) {
        this.setString(customTime, v, null);
    }

    public String getCustomTimeFormat() {
        return this.getString(customTimeFormat);
    }

    public void setCustomTimeFormat(String v) {
        this.setString(customTimeFormat, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public boolean getDebugEnable() {
        return this.getBoolean(debugEnable);
    }

    public void setDebugEnable(boolean v) {
        this.setBoolean(debugEnable, v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void fireUpdatedTrigger(BBoolean event) {
        this.fire(updatedTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        if (this.getTimeInput().isNull()) {
            this.setTimeInput(BAbsTime.now());
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enable || property == useCurrentTime || property == timeInput) {
            this.processTime();
        }
    }

    public void doUpdate() {
        this.processTime();
    }

    public void processTime() {
        long timeMillis;
        block9: {
            String timeStr;
            SimpleDateFormat simpleDateFormat;
            Date targetTime;
            block8: {
                if (!OssEasyApiLicense.isLicensed()) {
                    this.setFault("ossEasyAPI is not licensed");
                    return;
                }
                if (!this.getEnable()) {
                    this.debugMsg("Disabled");
                    return;
                }
                if (this.getUseCurrentTime()) {
                    this.setTimeInput(BAbsTime.now());
                }
                if (this.getTimeInput().isNull()) {
                    this.clearOutput();
                    this.debugMsg("Input time is NULL");
                    return;
                }
                timeMillis = this.getTimeInput().getMillis();
                this.setEpochSeconds(timeMillis / 1000L);
                this.setEpochMilliseconds(timeMillis);
                targetTime = new Date(timeMillis);
                try {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    timeStr = simpleDateFormat.format(targetTime);
                    this.setIsoUtcTime(timeStr);
                }
                catch (Exception timeException) {
                    this.setIsoUtcTime("");
                    OssEasyApiLog.getLog().severe("[" + this.getName() + "] ISO UTC time exception: " + timeException);
                    if (!this.getDebugEnable()) break block8;
                    timeException.printStackTrace();
                }
            }
            try {
                simpleDateFormat = new SimpleDateFormat(this.getCustomTimeFormat());
                timeStr = simpleDateFormat.format(targetTime);
                this.setCustomTime(timeStr);
            }
            catch (Exception timeException) {
                this.setCustomTime("");
                OssEasyApiLog.getLog().severe("[" + this.getName() + "] Custom time exception: " + timeException);
                if (!this.getDebugEnable()) break block9;
                timeException.printStackTrace();
            }
        }
        this.setLastUpdate(BAbsTime.now());
        this.fireUpdatedTrigger(BBoolean.TRUE);
        this.debugMsg("Time updated: " + timeMillis);
    }

    public void clearOutput() {
        this.setEpochSeconds(0L);
        this.setEpochMilliseconds(0L);
        this.setIsoUtcTime("");
        this.setCustomTime("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
    }

    public void debugMsg(String messageText) {
        if (this.getDebugEnable()) {
            OssEasyApiLog.getLog().finer("[" + this.getName() + "] " + messageText);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }
}

