/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.time;

import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enable", type="boolean", flags=256, defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="timeInput", type="String", defaultValue="", flags=328, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="timeInputFormat", type="BEnum", defaultValue="BDynamicEnum.make( 1, BEnumRange.make( new int[]{ 1, 2, 3 }, new String[]{ \"Epoch_Milliseconds\", \"Epoch_Seconds\", \"Text\" } ) )"), @NiagaraProperty(name="textTimeFormat", type="String", defaultValue="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="epochSeconds", type="long", defaultValue="0", flags=65), @NiagaraProperty(name="epochMilliseconds", type="long", defaultValue="0", flags=65), @NiagaraProperty(name="niagaraTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=73, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="isoUtcTime", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65601, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="clearOutputOnFault", type="boolean", flags=256, defaultValue="true"), @NiagaraProperty(name="debugEnable", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="update")
@NiagaraTopic(name="updatedTrigger", eventType="BBoolean")
public final class BTimeDecode
extends BComponent {
    public static final Property enable = BTimeDecode.newProperty((int)256, (boolean)true, null);
    public static final Property status = BTimeDecode.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BTimeDecode.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property timeInput = BTimeDecode.newProperty((int)328, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property timeInputFormat = BTimeDecode.newProperty((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((int[])new int[]{1, 2, 3}, (String[])new String[]{"Epoch_Milliseconds", "Epoch_Seconds", "Text"})), null);
    public static final Property textTimeFormat = BTimeDecode.newProperty((int)0, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property epochSeconds = BTimeDecode.newProperty((int)65, (int)0, null);
    public static final Property epochMilliseconds = BTimeDecode.newProperty((int)65, (int)0, null);
    public static final Property niagaraTime = BTimeDecode.newProperty((int)73, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property isoUtcTime = BTimeDecode.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property lastUpdate = BTimeDecode.newProperty((int)65601, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property clearOutputOnFault = BTimeDecode.newProperty((int)256, (boolean)true, null);
    public static final Property debugEnable = BTimeDecode.newProperty((int)4, (boolean)false, null);
    public static final Action update = BTimeDecode.newAction((int)0, null);
    public static final Topic updatedTrigger = BTimeDecode.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTimeDecode.class);

    public boolean getEnable() {
        return this.getBoolean(enable);
    }

    public void setEnable(boolean v) {
        this.setBoolean(enable, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getTimeInput() {
        return this.getString(timeInput);
    }

    public void setTimeInput(String v) {
        this.setString(timeInput, v, null);
    }

    public BEnum getTimeInputFormat() {
        return (BEnum)this.get(timeInputFormat);
    }

    public void setTimeInputFormat(BEnum v) {
        this.set(timeInputFormat, (BValue)v, null);
    }

    public String getTextTimeFormat() {
        return this.getString(textTimeFormat);
    }

    public void setTextTimeFormat(String v) {
        this.setString(textTimeFormat, v, null);
    }

    public long getEpochSeconds() {
        return this.getLong(epochSeconds);
    }

    public void setEpochSeconds(long v) {
        this.setLong(epochSeconds, v, null);
    }

    public long getEpochMilliseconds() {
        return this.getLong(epochMilliseconds);
    }

    public void setEpochMilliseconds(long v) {
        this.setLong(epochMilliseconds, v, null);
    }

    public BAbsTime getNiagaraTime() {
        return (BAbsTime)this.get(niagaraTime);
    }

    public void setNiagaraTime(BAbsTime v) {
        this.set(niagaraTime, (BValue)v, null);
    }

    public String getIsoUtcTime() {
        return this.getString(isoUtcTime);
    }

    public void setIsoUtcTime(String v) {
        this.setString(isoUtcTime, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public boolean getClearOutputOnFault() {
        return this.getBoolean(clearOutputOnFault);
    }

    public void setClearOutputOnFault(boolean v) {
        this.setBoolean(clearOutputOnFault, v, null);
    }

    public boolean getDebugEnable() {
        return this.getBoolean(debugEnable);
    }

    public void setDebugEnable(boolean v) {
        this.setBoolean(debugEnable, v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void fireUpdatedTrigger(BBoolean event) {
        this.fire(updatedTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enable || property == timeInput) {
            this.processTime();
        }
    }

    public void doUpdate() {
        this.processTime();
    }

    public void processTime() {
        block18: {
            if (!OssEasyApiLicense.isLicensed()) {
                this.setFault("ossEasyAPI is not licensed");
                return;
            }
            if (!this.getEnable()) {
                this.debugMsg("Disabled");
                return;
            }
            if (this.getTimeInputFormat().getOrdinal() == 1) {
                try {
                    this.outputTime((long)Double.parseDouble(this.getTimeInput()));
                }
                catch (NumberFormatException timeException) {
                    this.setFault("Invalid epoch milliseconds input");
                }
                catch (Exception timeException) {
                    this.setFault("Epoch milliseconds decode exception: " + timeException);
                    if (this.getDebugEnable()) {
                        timeException.printStackTrace();
                    }
                    break block18;
                }
            }
            if (this.getTimeInputFormat().getOrdinal() == 2) {
                try {
                    this.outputTime((long)Double.parseDouble(this.getTimeInput()) * 1000L);
                }
                catch (NumberFormatException timeException) {
                    this.setFault("Invalid epoch seconds input");
                }
                catch (Exception timeException) {
                    this.setFault("Epoch seconds decode exception: " + timeException);
                    if (this.getDebugEnable()) {
                        timeException.printStackTrace();
                    }
                    break block18;
                }
            }
            if (this.getTimeInputFormat().getOrdinal() == 3) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getTextTimeFormat());
                    Date decodedTime = simpleDateFormat.parse(this.getTimeInput());
                    this.outputTime(decodedTime.getTime());
                }
                catch (ParseException parseException) {
                    this.setFault("Invalid time input: " + parseException.getMessage());
                    if (this.getDebugEnable()) {
                        parseException.printStackTrace();
                    }
                    break block18;
                }
                catch (Exception timeException) {
                    this.setFault("Text time decode exception: " + timeException);
                    if (this.getDebugEnable()) {
                        timeException.printStackTrace();
                    }
                    break block18;
                }
            }
            this.setFault("Invalid input time format");
        }
    }

    public void outputTime(long timeMillis) {
        block5: {
            block4: {
                this.setEpochSeconds(timeMillis / 1000L);
                this.setEpochMilliseconds(timeMillis);
                try {
                    this.setNiagaraTime(BAbsTime.make((long)timeMillis));
                }
                catch (Exception timeException) {
                    this.setNiagaraTime(BAbsTime.NULL);
                    OssEasyApiLog.getLog().severe("[" + this.getName() + "] Niagara time exception: " + timeException);
                    if (!this.getDebugEnable()) break block4;
                    timeException.printStackTrace();
                }
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                String isoTimeStr = simpleDateFormat.format(new Date(timeMillis));
                this.setIsoUtcTime(isoTimeStr);
            }
            catch (Exception timeException) {
                this.setIsoUtcTime("");
                OssEasyApiLog.getLog().severe("[" + this.getName() + "] ISO UTC time exception: " + timeException);
                if (!this.getDebugEnable()) break block5;
                timeException.printStackTrace();
            }
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setLastUpdate(BAbsTime.now());
        this.fireUpdatedTrigger(BBoolean.TRUE);
        this.debugMsg("Time updated: " + timeMillis);
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
        if (this.getClearOutputOnFault()) {
            this.setEpochSeconds(0L);
            this.setEpochMilliseconds(0L);
            this.setNiagaraTime(BAbsTime.NULL);
            this.setIsoUtcTime("");
        }
    }

    public void debugMsg(String messageText) {
        if (this.getDebugEnable()) {
            OssEasyApiLog.getLog().finer("[" + this.getName() + "] " + messageText);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }
}

