/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonDecode;

import com.google.gson.JsonElement;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.tools.json.jsonDecode.BJsonDemux;
import com.oss.ossEasyAPI.tools.json.jsonDecode.JsonDecodeProcessor;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;

public class JsonDemuxTask
extends Thread {
    private final BJsonDemux master;
    private boolean debugEnabled = false;
    private String logIdent = "";
    private final JsonDecodeProcessor processor = new JsonDecodeProcessor();
    private static final Logger log = OssEasyApiLog.getLog();

    public JsonDemuxTask(BJsonDemux newDecodeMaster) {
        this.master = newDecodeMaster;
        this.setName("OSS-JsonDemuxTask-" + this.master.getName());
        this.debugEnabled = this.master.getDebugEnabled();
        this.logIdent = "[" + this.master.getName() + "] ";
    }

    @Override
    public void run() {
        block2: {
            this.debugMsg("JSON decode task started");
            try {
                this.processJsonInput();
            }
            catch (Exception decodeException) {
                this.master.setFault("JSON decode task exception: " + decodeException);
                if (!this.debugEnabled) break block2;
                decodeException.printStackTrace();
            }
        }
        this.debugMsg("JSON decode task terminated");
    }

    public void processJsonInput() {
        block12: {
            this.processor.setConfig(this.master.getCreatePoints(), this.master.getPointPrefix().format((Object)this.master), this.master.getPinDecodeSlots(), this.master.getKeyIgnoreList());
            this.processor.setDebug(this.debugEnabled, this.logIdent);
            this.processor.setDecodeParent(this.master, this.master.getDecodeFolder());
            String jsonText = this.master.getJsonIn();
            if (jsonText.isEmpty() || jsonText.contentEquals("-")) {
                if (this.master.getIgnoreEmptyInput()) {
                    this.debugMsg("Empty JSON input");
                } else {
                    this.master.setFault("Empty JSON input");
                }
            } else {
                this.debugMsg("Input: " + jsonText);
                try {
                    JsonElement jsonRoot = JsonDecodeProcessor.getJson(jsonText);
                    if (jsonRoot != null) {
                        if (jsonRoot.isJsonObject()) {
                            this.processor.processJsonObject(jsonRoot.getAsJsonObject());
                            this.master.clearFault();
                            this.master.setLastUpdate(BAbsTime.now());
                            this.master.fireOutTrigger(BBoolean.TRUE);
                            this.debugMsg("Decode successful");
                        } else {
                            this.master.setFault("Input is not a valid JSON object");
                        }
                    } else {
                        this.master.setFault("Input is not valid JSON");
                    }
                }
                catch (Exception jsonException) {
                    this.master.setFault("JSON processing exception: " + jsonException);
                    if (!this.debugEnabled) break block12;
                    jsonException.printStackTrace();
                }
            }
        }
        if (this.master.getRemoveOldSlots()) {
            this.processor.removeOldSlots();
        }
        if (this.master.getSetOldPointsStale()) {
            this.processor.setOldPointsStale();
        }
    }

    public void abort() {
        this.processor.abort();
        this.interrupt();
    }

    private void debugMsg(String debugMessage) {
        if (this.debugEnabled) {
            log.finest(this.logIdent + debugMessage);
        }
    }
}

