/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonDecode;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.tools.json.jsonDecode.BDecodeBoolean;
import com.oss.ossEasyAPI.tools.json.jsonDecode.BDecodeNumeric;
import com.oss.ossEasyAPI.tools.json.jsonDecode.BDecodeString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.BFolder;

public class JsonDecodeProcessor {
    private boolean debugEnabled = false;
    private String logIdent = "";
    private volatile boolean abortTask = false;
    private boolean makePoints = false;
    private String pointPrefix = "";
    private boolean pinDecodeSlots = false;
    private BComponent decodeParent = null;
    private List<String> keyIgnoreList;
    private final ArrayList<String> keysAdded = new ArrayList();
    private static final Logger log = OssEasyApiLog.getLog();

    public static JsonElement getJson(String jsonText) {
        Gson gson = new Gson();
        JsonElement jsonRoot = null;
        try {
            jsonRoot = gson.fromJson(jsonText, JsonElement.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonRoot;
    }

    public void setConfig(boolean newMakePoints, String newPointPrefix, boolean newPinDecodeSlots, String newIgnoreListString) {
        this.makePoints = newMakePoints;
        this.pointPrefix = newPointPrefix;
        this.pinDecodeSlots = newPinDecodeSlots;
        this.keyIgnoreList = Arrays.asList(newIgnoreListString.split("\\s*,\\s*"));
    }

    public void setDebug(boolean newDebugEnabled, String newLogIdent) {
        this.debugEnabled = newDebugEnabled;
        this.logIdent = newLogIdent;
    }

    public void setDecodeParent(BComponent decodeRoot, String decodeFolder) {
        this.decodeParent = null;
        if (decodeFolder.isEmpty()) {
            this.decodeParent = decodeRoot;
        } else {
            String slotName = SlotPath.escape((String)decodeFolder);
            BValue existingProp = decodeRoot.get(slotName);
            if (existingProp != null && !(existingProp instanceof BFolder)) {
                decodeRoot.remove(slotName);
                existingProp = null;
            }
            if (existingProp == null) {
                decodeRoot.add(slotName, (BValue)new BFolder());
            }
            this.decodeParent = decodeRoot.get(slotName).asComponent();
        }
    }

    public List<String> getAddedKeys() {
        return this.keysAdded;
    }

    public void processJsonObject(JsonElement valuesElement) {
        JsonObject valuesObject = valuesElement.getAsJsonObject();
        Iterator<String> keySet = valuesObject.keySet().iterator();
        this.keysAdded.clear();
        while (keySet.hasNext()) {
            if (this.abortTask) {
                return;
            }
            String keyName = keySet.next();
            if (!this.checkIgnoreList(keyName)) continue;
            this.updateData(keyName, valuesObject.get(keyName));
        }
    }

    private boolean checkIgnoreList(String keyName) {
        return !this.keyIgnoreList.contains(keyName);
    }

    private void updateData(String keyName, JsonElement keyElement) {
        if (keyElement.isJsonPrimitive()) {
            JsonPrimitive primitive = keyElement.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                if (this.makePoints) {
                    this.addNumericPoint(keyName, primitive.getAsDouble());
                } else {
                    this.addSlot(keyName, (BValue)BDouble.make((double)primitive.getAsDouble()));
                }
            } else if (primitive.isBoolean()) {
                if (this.makePoints) {
                    this.addBooleanPoint(keyName, primitive.getAsBoolean());
                } else {
                    this.addSlot(keyName, (BValue)BBoolean.make((boolean)primitive.getAsBoolean()));
                }
            } else if (this.makePoints) {
                this.addStringPoint(keyName, primitive.getAsString());
            } else {
                this.addSlot(keyName, (BValue)BString.make((String)primitive.getAsString()));
            }
        } else if (this.makePoints) {
            this.addStringPoint(keyName, keyElement.toString());
        } else {
            this.addSlot(keyName, (BValue)BString.make((String)keyElement.toString()));
        }
    }

    private void addSlot(String keyName, BValue slotValue) {
        Property valueSlot;
        String slotName = SlotPath.escape((String)keyName);
        int slotFlags = 1;
        if (this.pinDecodeSlots) {
            slotFlags = 9;
        }
        if ((valueSlot = this.decodeParent.getProperty(slotName)) == null) {
            this.decodeParent.add(slotName, slotValue, slotFlags);
            this.debugMsg("Added '" + keyName + "' = " + slotValue);
        } else if (!(this.decodeParent.get(valueSlot) instanceof BControlPoint)) {
            this.decodeParent.set(valueSlot, slotValue);
            this.decodeParent.setFlags((Slot)valueSlot, slotFlags |= this.decodeParent.getFlags((Slot)valueSlot));
            this.debugMsg("Updated '" + keyName + "' = " + slotValue);
        } else {
            this.debugMsg("WARNING: Not overwriting slot '" + slotName + "'");
        }
        this.keysAdded.add(slotName);
    }

    private void addNumericPoint(String keyName, double newValue) {
        String slotName = SlotPath.escape((String)(this.pointPrefix + keyName));
        this.removePrimitiveSlot(this.decodeParent.getProperty(slotName));
        Property valueSlot = this.decodeParent.getProperty(slotName);
        if (valueSlot == null) {
            BDecodeNumeric numericPoint = new BDecodeNumeric(newValue);
            this.decodeParent.add(slotName, (BValue)numericPoint, 1);
            this.debugMsg("Added '" + keyName + "' = " + newValue);
        } else {
            BValue valuePoint = this.decodeParent.get(valueSlot);
            if (valuePoint instanceof BDecodeNumeric) {
                ((BDecodeNumeric)valuePoint).assignValue(newValue);
                this.debugMsg("Updated '" + keyName + "' = " + newValue);
            } else {
                this.debugMsg("WARNING: Could not update '" + keyName + "' - invalid type");
            }
        }
        this.keysAdded.add(slotName);
    }

    private void addBooleanPoint(String keyName, boolean newValue) {
        String slotName = SlotPath.escape((String)(this.pointPrefix + keyName));
        this.removePrimitiveSlot(this.decodeParent.getProperty(slotName));
        Property valueSlot = this.decodeParent.getProperty(slotName);
        if (valueSlot == null) {
            BDecodeBoolean booleanPoint = new BDecodeBoolean(newValue);
            this.decodeParent.add(slotName, (BValue)booleanPoint, 1);
            this.debugMsg("Added '" + keyName + "' = " + newValue);
        } else {
            BValue valuePoint = this.decodeParent.get(valueSlot);
            if (valuePoint instanceof BDecodeBoolean) {
                ((BDecodeBoolean)valuePoint).assignValue(newValue);
                this.debugMsg("Updated '" + keyName + "' = " + newValue);
            } else {
                this.debugMsg("WARNING: Could not update '" + keyName + "' - invalid type");
            }
        }
        this.keysAdded.add(slotName);
    }

    private void addStringPoint(String keyName, String newValue) {
        String slotName = SlotPath.escape((String)(this.pointPrefix + keyName));
        this.removePrimitiveSlot(this.decodeParent.getProperty(slotName));
        Property valueSlot = this.decodeParent.getProperty(slotName);
        if (valueSlot == null) {
            BDecodeString stringPoint = new BDecodeString(newValue);
            this.decodeParent.add(slotName, (BValue)stringPoint, 1);
            this.debugMsg("Added '" + keyName + "' = " + newValue);
        } else {
            BValue valuePoint = this.decodeParent.get(valueSlot);
            if (valuePoint instanceof BDecodeString) {
                ((BDecodeString)valuePoint).assignValue(newValue);
                this.debugMsg("Updated '" + keyName + "' = " + newValue);
            } else {
                this.debugMsg("WARNING: Could not update '" + keyName + "' - invalid type");
            }
        }
        this.keysAdded.add(slotName);
    }

    private void removePrimitiveSlot(Property valueSlot) {
        BValue slot;
        if (valueSlot != null && ((slot = this.decodeParent.get(valueSlot)) instanceof BDouble || slot instanceof BBoolean || slot instanceof BString)) {
            this.decodeParent.remove(valueSlot);
        }
    }

    public void removeOldSlots() {
        for (Property prop : this.decodeParent.getDynamicPropertiesArray()) {
            BValue slot;
            if (this.keysAdded.contains(prop.getName()) || !((slot = this.decodeParent.get(prop)) instanceof BDouble) && !(slot instanceof BBoolean) && !(slot instanceof BString)) continue;
            this.decodeParent.remove(prop);
            this.debugMsg("Removed '" + prop.getName() + "'");
        }
    }

    public void setOldPointsStale() {
        for (Property prop : this.decodeParent.getDynamicPropertiesArray()) {
            if (this.keysAdded.contains(prop.getName())) continue;
            BValue slot = this.decodeParent.get(prop);
            if (slot instanceof BDecodeNumeric) {
                ((BDecodeNumeric)slot).updateStatus(BStatus.stale);
                continue;
            }
            if (slot instanceof BDecodeBoolean) {
                ((BDecodeBoolean)slot).updateStatus(BStatus.stale);
                continue;
            }
            if (!(slot instanceof BDecodeString)) continue;
            ((BDecodeString)slot).updateStatus(BStatus.stale);
        }
    }

    public void abort() {
        this.abortTask = true;
    }

    private void debugMsg(String debugMessage) {
        if (this.debugEnabled) {
            log.finest(this.logIdent + debugMessage);
        }
    }
}

