/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonDecode;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.processing.DataTreeGenerator;
import com.oss.ossEasyAPI.thread.ApiThread;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="jsonIn", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="ignoreEmptyInput", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="decodeInput"), @NiagaraAction(name="clearDecode")})
@NiagaraTopic(name="outTrigger", eventType="BBoolean")
public final class BJsonTree
extends BComponent {
    public static final Property enabled = BJsonTree.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJsonTree.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BJsonTree.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property lastUpdate = BJsonTree.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property jsonIn = BJsonTree.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property ignoreEmptyInput = BJsonTree.newProperty((int)4, (boolean)true, null);
    public static final Property debugEnabled = BJsonTree.newProperty((int)4, (boolean)false, null);
    public static final Action decodeInput = BJsonTree.newAction((int)0, null);
    public static final Action clearDecode = BJsonTree.newAction((int)0, null);
    public static final Topic outTrigger = BJsonTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJsonTree.class);
    private JsonTreeGenerationTask decodeTask = null;
    private static final Logger log = OssEasyApiLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public String getJsonIn() {
        return this.getString(jsonIn);
    }

    public void setJsonIn(String v) {
        this.setString(jsonIn, v, null);
    }

    public boolean getIgnoreEmptyInput() {
        return this.getBoolean(ignoreEmptyInput);
    }

    public void setIgnoreEmptyInput(boolean v) {
        this.setBoolean(ignoreEmptyInput, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void decodeInput() {
        this.invoke(decodeInput, null, null);
    }

    public void clearDecode() {
        this.invoke(clearDecode, null, null);
    }

    public void fireOutTrigger(BBoolean event) {
        this.fire(outTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!OssEasyApiLicense.isLicensed()) {
            return;
        }
        if (property == jsonIn) {
            if (!this.getJsonIn().isEmpty() || !this.getIgnoreEmptyInput()) {
                this.startJsonProcessingTask();
            }
        } else if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doDecodeInput() {
        this.startJsonProcessingTask();
    }

    public void startJsonProcessingTask() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        if (this.decodeTask == null || !this.decodeTask.isAlive()) {
            this.decodeTask = new JsonTreeGenerationTask();
            if (!ApiThread.execute(this.decodeTask)) {
                this.setFault("Number of concurrent threads exceeded");
            }
        } else {
            this.debugMsg("Decode already in progress");
        }
    }

    public void doClearDecode() {
        this.remove("Data");
        this.debugMsg("Cleared decode");
    }

    public void clearFault() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        log.severe("[" + this.getName() + "] " + faultMessage);
    }

    private void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest("[" + this.getName() + "] " + debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }

    private class JsonTreeGenerationTask
    extends Thread {
        private JsonTreeGenerationTask() {
        }

        @Override
        public void run() {
            block9: {
                this.setName("OSS-JsonTreeGenerationTask-" + this.getName());
                String jsonText = BJsonTree.this.getJsonIn();
                if (jsonText.isEmpty() || jsonText.contentEquals("-")) {
                    if (BJsonTree.this.getIgnoreEmptyInput()) {
                        BJsonTree.this.debugMsg("Empty JSON input");
                    } else {
                        BJsonTree.this.setFault("Empty JSON input");
                    }
                    return;
                }
                try {
                    Gson gson = new Gson();
                    JsonElement inputJson = null;
                    try {
                        inputJson = gson.fromJson(jsonText, JsonElement.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (inputJson != null) {
                        DataTreeGenerator.generate(BJsonTree.this, inputJson);
                        BJsonTree.this.setLastUpdate(BAbsTime.now());
                        BJsonTree.this.clearFault();
                        BJsonTree.this.fireOutTrigger(BBoolean.TRUE);
                    } else {
                        BJsonTree.this.setFault("Input is not JSON");
                    }
                }
                catch (Exception jsonException) {
                    BJsonTree.this.setFault("JSON processing exception: " + jsonException);
                    if (!BJsonTree.this.getDebugEnabled()) break block9;
                    jsonException.printStackTrace();
                }
            }
        }
    }
}

