/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonDecode;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.thread.ApiThread;
import java.util.EnumSet;
import java.util.Set;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="out", type="String", defaultValue="", flags=73, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="jsonIn", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="pathExpression", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="processOnChange", type="boolean", defaultValue="true"), @NiagaraProperty(name="unwrapSingletonArray", type="boolean", defaultValue="true"), @NiagaraProperty(name="ignoreEmptyArrays", type="boolean", defaultValue="true"), @NiagaraProperty(name="clearOutputOnFault", type="boolean", defaultValue="true"), @NiagaraProperty(name="ignoreEmptyInput", type="boolean", defaultValue="true")})
@NiagaraAction(name="decodeInput")
@NiagaraTopics(value={@NiagaraTopic(name="outTrigger", eventType="BBoolean"), @NiagaraTopic(name="routeOut", eventType="BString")})
public final class BJsonPath
extends BComponent {
    public static final Property enabled = BJsonPath.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJsonPath.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BJsonPath.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property out = BJsonPath.newProperty((int)73, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property lastUpdate = BJsonPath.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property jsonIn = BJsonPath.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property pathExpression = BJsonPath.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property processOnChange = BJsonPath.newProperty((int)0, (boolean)true, null);
    public static final Property unwrapSingletonArray = BJsonPath.newProperty((int)0, (boolean)true, null);
    public static final Property ignoreEmptyArrays = BJsonPath.newProperty((int)0, (boolean)true, null);
    public static final Property clearOutputOnFault = BJsonPath.newProperty((int)0, (boolean)true, null);
    public static final Property ignoreEmptyInput = BJsonPath.newProperty((int)0, (boolean)true, null);
    public static final Action decodeInput = BJsonPath.newAction((int)0, null);
    public static final Topic outTrigger = BJsonPath.newTopic((int)0, null);
    public static final Topic routeOut = BJsonPath.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJsonPath.class);
    private JsonPathDecodeTask decodeTask = null;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public String getJsonIn() {
        return this.getString(jsonIn);
    }

    public void setJsonIn(String v) {
        this.setString(jsonIn, v, null);
    }

    public String getPathExpression() {
        return this.getString(pathExpression);
    }

    public void setPathExpression(String v) {
        this.setString(pathExpression, v, null);
    }

    public boolean getProcessOnChange() {
        return this.getBoolean(processOnChange);
    }

    public void setProcessOnChange(boolean v) {
        this.setBoolean(processOnChange, v, null);
    }

    public boolean getUnwrapSingletonArray() {
        return this.getBoolean(unwrapSingletonArray);
    }

    public void setUnwrapSingletonArray(boolean v) {
        this.setBoolean(unwrapSingletonArray, v, null);
    }

    public boolean getIgnoreEmptyArrays() {
        return this.getBoolean(ignoreEmptyArrays);
    }

    public void setIgnoreEmptyArrays(boolean v) {
        this.setBoolean(ignoreEmptyArrays, v, null);
    }

    public boolean getClearOutputOnFault() {
        return this.getBoolean(clearOutputOnFault);
    }

    public void setClearOutputOnFault(boolean v) {
        this.setBoolean(clearOutputOnFault, v, null);
    }

    public boolean getIgnoreEmptyInput() {
        return this.getBoolean(ignoreEmptyInput);
    }

    public void setIgnoreEmptyInput(boolean v) {
        this.setBoolean(ignoreEmptyInput, v, null);
    }

    public void decodeInput() {
        this.invoke(decodeInput, null, null);
    }

    public void fireOutTrigger(BBoolean event) {
        this.fire(outTrigger, (BValue)event, null);
    }

    public void fireRouteOut(BString event) {
        this.fire(routeOut, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
        Configuration.setDefaults(new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new GsonJsonProvider();
            private final MappingProvider mappingProvider = new GsonMappingProvider();

            @Override
            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            @Override
            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            @Override
            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!OssEasyApiLicense.isLicensed()) {
            return;
        }
        if (property == pathExpression || property == jsonIn) {
            if (!this.getJsonIn().isEmpty() || !this.getIgnoreEmptyInput()) {
                this.startJsonProcessingTask();
            }
        } else if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doDecodeInput() {
        this.startJsonProcessingTask();
    }

    public void startJsonProcessingTask() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        if (this.decodeTask == null || !this.decodeTask.isAlive()) {
            this.decodeTask = new JsonPathDecodeTask();
            if (!ApiThread.execute(this.decodeTask)) {
                this.setFault("Number of concurrent threads exceeded");
            }
        }
    }

    public void clearFault() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
        if (this.getClearOutputOnFault()) {
            this.setOut("");
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }

    private class JsonPathDecodeTask
    extends Thread {
        private JsonPathDecodeTask() {
        }

        @Override
        public void run() {
            this.setName("OSS-JsonPathDecodeTask-" + this.getName());
            if (BJsonPath.this.getPathExpression().isEmpty()) {
                BJsonPath.this.setFault("Path Expression is not set");
                return;
            }
            if (BJsonPath.this.getJsonIn().isEmpty() || BJsonPath.this.getJsonIn().contentEquals("-")) {
                if (!BJsonPath.this.getIgnoreEmptyInput()) {
                    BJsonPath.this.setFault("JSON input is not set");
                }
                return;
            }
            try {
                Gson gson = new Gson();
                JsonElement inputJson = null;
                try {
                    inputJson = gson.fromJson(BJsonPath.this.getJsonIn(), JsonElement.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inputJson == null) {
                    BJsonPath.this.setFault("Input is not valid JSON");
                    return;
                }
                Object outValue = null;
                JsonElement result = (JsonElement)JsonPath.parse(inputJson).read(BJsonPath.this.getPathExpression(), new Predicate[0]);
                if (result.isJsonPrimitive()) {
                    outValue = result.getAsString();
                } else if (result.isJsonArray()) {
                    JsonElement arrayItem;
                    JsonArray arrayResult = result.getAsJsonArray();
                    outValue = BJsonPath.this.getUnwrapSingletonArray() && arrayResult.size() == 1 ? ((arrayItem = arrayResult.get(0)).isJsonPrimitive() ? arrayItem.getAsString() : arrayItem.toString()) : (BJsonPath.this.getIgnoreEmptyArrays() && arrayResult.size() == 0 ? null : result.toString());
                } else {
                    outValue = result.toString();
                }
                if (outValue != null) {
                    BJsonPath.this.setOut((String)outValue);
                    BJsonPath.this.setLastUpdate(BAbsTime.now());
                    BJsonPath.this.clearFault();
                    BJsonPath.this.fireOutTrigger(BBoolean.TRUE);
                    BJsonPath.this.fireRouteOut(BString.make((String)outValue));
                }
            }
            catch (PathNotFoundException pathException) {
                BJsonPath.this.setFault("PathNotFound: " + pathException.getMessage());
            }
            catch (InvalidPathException pathException) {
                BJsonPath.this.setFault("InvalidPath: " + pathException.getMessage());
            }
            catch (Exception processException) {
                BJsonPath.this.setFault("Process Exception: " + processException);
                processException.printStackTrace();
            }
        }
    }
}

