/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonDecode;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.thread.ApiThread;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="out", type="String", defaultValue="", flags=9, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="jsonIn", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="keyName", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="processOnChange", type="boolean", defaultValue="true"), @NiagaraProperty(name="clearOutputOnFault", type="boolean", defaultValue="true"), @NiagaraProperty(name="ignoreEmptyInput", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="decodeInput"), @NiagaraAction(name="setKey", parameterType="BString", defaultValue="BString.DEFAULT")})
@NiagaraTopics(value={@NiagaraTopic(name="outTrigger", eventType="BBoolean"), @NiagaraTopic(name="routeOut", eventType="BString")})
public final class BJsonObjectSelect
extends BComponent {
    public static final Property enabled = BJsonObjectSelect.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJsonObjectSelect.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BJsonObjectSelect.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property out = BJsonObjectSelect.newProperty((int)9, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property lastUpdate = BJsonObjectSelect.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property jsonIn = BJsonObjectSelect.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property keyName = BJsonObjectSelect.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property processOnChange = BJsonObjectSelect.newProperty((int)0, (boolean)true, null);
    public static final Property clearOutputOnFault = BJsonObjectSelect.newProperty((int)0, (boolean)true, null);
    public static final Property ignoreEmptyInput = BJsonObjectSelect.newProperty((int)0, (boolean)true, null);
    public static final Action decodeInput = BJsonObjectSelect.newAction((int)0, null);
    public static final Action setKey = BJsonObjectSelect.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Topic outTrigger = BJsonObjectSelect.newTopic((int)0, null);
    public static final Topic routeOut = BJsonObjectSelect.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJsonObjectSelect.class);
    private JsonObjectDecodeTask decodeTask = null;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public String getJsonIn() {
        return this.getString(jsonIn);
    }

    public void setJsonIn(String v) {
        this.setString(jsonIn, v, null);
    }

    public String getKeyName() {
        return this.getString(keyName);
    }

    public void setKeyName(String v) {
        this.setString(keyName, v, null);
    }

    public boolean getProcessOnChange() {
        return this.getBoolean(processOnChange);
    }

    public void setProcessOnChange(boolean v) {
        this.setBoolean(processOnChange, v, null);
    }

    public boolean getClearOutputOnFault() {
        return this.getBoolean(clearOutputOnFault);
    }

    public void setClearOutputOnFault(boolean v) {
        this.setBoolean(clearOutputOnFault, v, null);
    }

    public boolean getIgnoreEmptyInput() {
        return this.getBoolean(ignoreEmptyInput);
    }

    public void setIgnoreEmptyInput(boolean v) {
        this.setBoolean(ignoreEmptyInput, v, null);
    }

    public void decodeInput() {
        this.invoke(decodeInput, null, null);
    }

    public void setKey(BString parameter) {
        this.invoke(setKey, (BValue)parameter, null);
    }

    public void fireOutTrigger(BBoolean event) {
        this.fire(outTrigger, (BValue)event, null);
    }

    public void fireRouteOut(BString event) {
        this.fire(routeOut, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!OssEasyApiLicense.isLicensed()) {
            return;
        }
        if (property == keyName || property == jsonIn) {
            if (!this.getJsonIn().isEmpty() || !this.getIgnoreEmptyInput()) {
                this.startJsonProcessingTask();
            }
        } else if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doDecodeInput() {
        this.startJsonProcessingTask();
    }

    public void doSetKey(BString newKeyName) {
        this.setKeyName(newKeyName.getString());
    }

    public void startJsonProcessingTask() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        if (this.decodeTask == null || !this.decodeTask.isAlive()) {
            this.decodeTask = new JsonObjectDecodeTask();
            if (!ApiThread.execute(this.decodeTask)) {
                this.setFault("Number of concurrent threads exceeded");
            }
        }
    }

    public void clearFault() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
        if (this.getClearOutputOnFault()) {
            this.setOut("");
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }

    private class JsonObjectDecodeTask
    extends Thread {
        private JsonObjectDecodeTask() {
        }

        @Override
        public void run() {
            this.setName("OSS-JsonObjectDecodeTask-" + this.getName());
            if (BJsonObjectSelect.this.getKeyName().isEmpty()) {
                BJsonObjectSelect.this.setFault("Key name is not set");
                return;
            }
            if (BJsonObjectSelect.this.getJsonIn().isEmpty() || BJsonObjectSelect.this.getJsonIn().contentEquals("-")) {
                if (!BJsonObjectSelect.this.getIgnoreEmptyInput()) {
                    BJsonObjectSelect.this.setFault("JSON input is not set");
                }
                return;
            }
            try {
                Gson gson = new Gson();
                JsonElement inputJson = null;
                try {
                    inputJson = gson.fromJson(BJsonObjectSelect.this.getJsonIn(), JsonElement.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inputJson != null) {
                    if (inputJson.isJsonObject()) {
                        JsonElement jsonValue = inputJson.getAsJsonObject().get(BJsonObjectSelect.this.getKeyName());
                        if (jsonValue != null) {
                            String outValue = null;
                            outValue = jsonValue.isJsonPrimitive() ? jsonValue.getAsString() : jsonValue.toString();
                            BJsonObjectSelect.this.setOut(outValue);
                            BJsonObjectSelect.this.setLastUpdate(BAbsTime.now());
                            BJsonObjectSelect.this.clearFault();
                            BJsonObjectSelect.this.fireOutTrigger(BBoolean.TRUE);
                            BJsonObjectSelect.this.fireRouteOut(BString.make((String)outValue));
                        } else {
                            BJsonObjectSelect.this.setFault("Input does not contain key: " + BJsonObjectSelect.this.getKeyName());
                        }
                    } else {
                        BJsonObjectSelect.this.setFault("Input is not a JSON object");
                    }
                } else {
                    BJsonObjectSelect.this.setFault("Input is not valid JSON");
                }
            }
            catch (Exception processException) {
                BJsonObjectSelect.this.setFault("Process Exception: " + processException);
                processException.printStackTrace();
            }
        }
    }
}

