/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonDecode;

import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.thread.ApiThread;
import com.oss.ossEasyAPI.tools.json.jsonDecode.JsonDemuxTask;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="jsonIn", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="keyIgnoreList", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="decodeFolder", type="String", defaultValue=""), @NiagaraProperty(name="createPoints", type="boolean", defaultValue="false"), @NiagaraProperty(name="pointPrefix", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="pinDecodeSlots", type="boolean", defaultValue="true"), @NiagaraProperty(name="removeOldSlots", type="boolean", defaultValue="false"), @NiagaraProperty(name="setOldPointsStale", type="boolean", defaultValue="false"), @NiagaraProperty(name="ignoreEmptyInput", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="decodeInput"), @NiagaraAction(name="abortDecodeTask", flags=4), @NiagaraAction(name="deleteDecodeSlots")})
@NiagaraTopic(name="outTrigger", eventType="BBoolean")
public final class BJsonDemux
extends BComponent {
    public static final Property enabled = BJsonDemux.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJsonDemux.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BJsonDemux.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property lastUpdate = BJsonDemux.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property jsonIn = BJsonDemux.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property keyIgnoreList = BJsonDemux.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property decodeFolder = BJsonDemux.newProperty((int)0, (String)"", null);
    public static final Property createPoints = BJsonDemux.newProperty((int)0, (boolean)false, null);
    public static final Property pointPrefix = BJsonDemux.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    public static final Property pinDecodeSlots = BJsonDemux.newProperty((int)0, (boolean)true, null);
    public static final Property removeOldSlots = BJsonDemux.newProperty((int)0, (boolean)false, null);
    public static final Property setOldPointsStale = BJsonDemux.newProperty((int)0, (boolean)false, null);
    public static final Property ignoreEmptyInput = BJsonDemux.newProperty((int)4, (boolean)true, null);
    public static final Property debugEnabled = BJsonDemux.newProperty((int)4, (boolean)false, null);
    public static final Action decodeInput = BJsonDemux.newAction((int)0, null);
    public static final Action abortDecodeTask = BJsonDemux.newAction((int)4, null);
    public static final Action deleteDecodeSlots = BJsonDemux.newAction((int)0, null);
    public static final Topic outTrigger = BJsonDemux.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJsonDemux.class);
    private JsonDemuxTask decodeTask = null;
    private static final Logger log = OssEasyApiLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public String getJsonIn() {
        return this.getString(jsonIn);
    }

    public void setJsonIn(String v) {
        this.setString(jsonIn, v, null);
    }

    public String getKeyIgnoreList() {
        return this.getString(keyIgnoreList);
    }

    public void setKeyIgnoreList(String v) {
        this.setString(keyIgnoreList, v, null);
    }

    public String getDecodeFolder() {
        return this.getString(decodeFolder);
    }

    public void setDecodeFolder(String v) {
        this.setString(decodeFolder, v, null);
    }

    public boolean getCreatePoints() {
        return this.getBoolean(createPoints);
    }

    public void setCreatePoints(boolean v) {
        this.setBoolean(createPoints, v, null);
    }

    public BFormat getPointPrefix() {
        return (BFormat)this.get(pointPrefix);
    }

    public void setPointPrefix(BFormat v) {
        this.set(pointPrefix, (BValue)v, null);
    }

    public boolean getPinDecodeSlots() {
        return this.getBoolean(pinDecodeSlots);
    }

    public void setPinDecodeSlots(boolean v) {
        this.setBoolean(pinDecodeSlots, v, null);
    }

    public boolean getRemoveOldSlots() {
        return this.getBoolean(removeOldSlots);
    }

    public void setRemoveOldSlots(boolean v) {
        this.setBoolean(removeOldSlots, v, null);
    }

    public boolean getSetOldPointsStale() {
        return this.getBoolean(setOldPointsStale);
    }

    public void setSetOldPointsStale(boolean v) {
        this.setBoolean(setOldPointsStale, v, null);
    }

    public boolean getIgnoreEmptyInput() {
        return this.getBoolean(ignoreEmptyInput);
    }

    public void setIgnoreEmptyInput(boolean v) {
        this.setBoolean(ignoreEmptyInput, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void decodeInput() {
        this.invoke(decodeInput, null, null);
    }

    public void abortDecodeTask() {
        this.invoke(abortDecodeTask, null, null);
    }

    public void deleteDecodeSlots() {
        this.invoke(deleteDecodeSlots, null, null);
    }

    public void fireOutTrigger(BBoolean event) {
        this.fire(outTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void stopped() {
        this.stopJsonProcessingTask();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!OssEasyApiLicense.isLicensed()) {
            return;
        }
        if (property == jsonIn) {
            if (!this.getJsonIn().isEmpty() || !this.getIgnoreEmptyInput()) {
                this.startJsonProcessingTask();
            }
        } else if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.stopJsonProcessingTask();
            }
        }
    }

    public void doDecodeInput() {
        this.startJsonProcessingTask();
    }

    public void doAbortDecodeTask() {
        this.stopJsonProcessingTask();
    }

    public void doDeleteDecodeSlots() {
        BValue child;
        BValue slot;
        for (Property prop : this.getDynamicPropertiesArray()) {
            slot = this.get(prop);
            if (!(slot instanceof BDouble) && !(slot instanceof BBoolean) && !(slot instanceof BString)) continue;
            this.remove(prop);
        }
        if (!this.getDecodeFolder().isEmpty() && (child = this.get(this.getDecodeFolder())) instanceof BFolder) {
            BFolder subFolder = (BFolder)child;
            for (Property prop : subFolder.getDynamicPropertiesArray()) {
                slot = subFolder.get(prop);
                if (!(slot instanceof BDouble) && !(slot instanceof BBoolean) && !(slot instanceof BString)) continue;
                subFolder.remove(prop);
            }
        }
        this.debugMsg("Cleared decode");
    }

    public void startJsonProcessingTask() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        if (this.decodeTask == null || !this.decodeTask.isAlive()) {
            this.decodeTask = new JsonDemuxTask(this);
            if (!ApiThread.execute(this.decodeTask)) {
                this.setFault("Number of concurrent threads exceeded");
            }
        } else {
            this.debugMsg("Decode already in progress");
        }
    }

    public void stopJsonProcessingTask() {
        if (this.decodeTask != null) {
            this.decodeTask.abort();
            this.decodeTask = null;
            this.debugMsg("Aborted decode task");
        }
    }

    public void clearFault() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        log.severe("[" + this.getName() + "] " + faultMessage);
    }

    private void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest("[" + this.getName() + "] " + debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }
}

