/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.json.jsonBuilder;

import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.thread.ApiThread;
import com.oss.ossEasyAPI.tools.json.jsonBuilder.BJsonArrayFolder;
import com.oss.ossEasyAPI.tools.json.jsonBuilder.BJsonFolder;
import com.oss.ossEasyAPI.tools.json.jsonBuilder.BJsonObjectFolder;
import com.oss.ossEasyAPI.tools.json.jsonBuilder.BJsonPrimitive;
import com.oss.ossEasyAPI.tools.json.jsonBuilder.BuilderNode;
import java.io.StringWriter;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="out", type="String", defaultValue="", flags=9, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="numericPrecision", type="int", defaultValue="3")})
@NiagaraAction(name="generate")
@NiagaraTopic(name="updatedTrigger", eventType="BBoolean")
public final class BJsonBuilder
extends BComponent
implements BuilderNode {
    public static final Property enabled = BJsonBuilder.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJsonBuilder.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BJsonBuilder.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property out = BJsonBuilder.newProperty((int)9, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property lastUpdate = BJsonBuilder.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property numericPrecision = BJsonBuilder.newProperty((int)0, (int)3, null);
    public static final Action generate = BJsonBuilder.newAction((int)0, null);
    public static final Topic updatedTrigger = BJsonBuilder.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BJsonBuilder.class);
    private JsonObjectBuilderTask builderTask = null;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public int getNumericPrecision() {
        return this.getInt(numericPrecision);
    }

    public void setNumericPrecision(int v) {
        this.setInt(numericPrecision, v, null);
    }

    public void generate() {
        this.invoke(generate, null, null);
    }

    public void fireUpdatedTrigger(BBoolean event) {
        this.fire(updatedTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!OssEasyApiLicense.isLicensed()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doGenerate() {
        this.generateJson();
    }

    @Override
    public void generateJson() {
        this.startJsonBuilderTask();
    }

    public void startJsonBuilderTask() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        if (this.builderTask == null || !this.builderTask.isAlive()) {
            this.builderTask = new JsonObjectBuilderTask();
            if (!ApiThread.execute(this.builderTask)) {
                this.setFault("Number of concurrent threads exceeded");
            }
        }
    }

    public void clearFault() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }

    private class JsonObjectBuilderTask
    extends Thread {
        private volatile boolean cancelGeneration = false;

        private JsonObjectBuilderTask() {
        }

        @Override
        public void run() {
            this.setName("OSS-JsonObjectBuilderTask-" + this.getName());
            try {
                StringWriter jsonText = new StringWriter(1000);
                BJsonFolder[] jsonRootArray = (BJsonFolder[])BJsonBuilder.this.getChildren(BJsonFolder.class);
                if (jsonRootArray.length > 0) {
                    if (jsonRootArray.length > 1) {
                        OssEasyApiLog.getLog().warning("[" + this.getName() + "] Multiple root folders");
                    }
                    this.processJsonFolder(jsonText, jsonRootArray[0]);
                } else {
                    BJsonBuilder.this.setFault("No root JSON folder");
                }
                BJsonBuilder.this.setOut(jsonText.toString());
                BJsonBuilder.this.setLastUpdate(BAbsTime.now());
                BJsonBuilder.this.fireUpdatedTrigger(BBoolean.TRUE);
                BJsonBuilder.this.clearFault();
            }
            catch (Exception processException) {
                BJsonBuilder.this.setFault("Exception: " + processException);
                processException.printStackTrace();
            }
        }

        public void processJsonFolder(StringWriter jsonText, BFolder parentFolder) {
            boolean buildArray = false;
            String folderSuffix = "";
            if (parentFolder instanceof BJsonObjectFolder) {
                jsonText.append("{");
                folderSuffix = "}";
            } else if (parentFolder instanceof BJsonArrayFolder) {
                jsonText.append("[");
                folderSuffix = "]";
                buildArray = true;
            }
            boolean firstElement = true;
            for (Property prop : parentFolder.getDynamicPropertiesArray()) {
                if (this.cancelGeneration) {
                    return;
                }
                try {
                    BValue propObject = BJsonBuilder.this.get(prop);
                    String jsonElementPrefix = firstElement ? "" : ",";
                    if (!buildArray) {
                        jsonElementPrefix = jsonElementPrefix + "\"" + prop.getName() + "\":";
                    }
                    if (propObject instanceof BFolder) {
                        jsonText.append(jsonElementPrefix);
                        this.processJsonFolder(jsonText, (BFolder)propObject);
                        firstElement = false;
                        continue;
                    }
                    String jsonElementContent = "";
                    if (propObject instanceof BJsonPrimitive) {
                        jsonElementContent = ((BJsonPrimitive)propObject).getJsonContent();
                    } else if (propObject instanceof BString) {
                        jsonElementContent = this.makeJsonString(((BString)propObject).getString());
                    } else if (propObject instanceof BDouble) {
                        BDouble inputNumeric = (BDouble)propObject;
                        BFacets numericFacet = BFacets.makeNumeric((int)BJsonBuilder.this.getNumericPrecision());
                        jsonElementContent = inputNumeric.toString((Context)numericFacet);
                    } else if (propObject instanceof BBoolean) {
                        jsonElementContent = propObject.toString();
                    } else if (propObject instanceof BEnum) {
                        jsonElementContent = String.valueOf(((BEnum)propObject).getOrdinal());
                    } else if (propObject instanceof BControlPoint) {
                        BStringWritable writable;
                        if (((BControlPoint)propObject).getStatus().isNull()) {
                            jsonElementContent = "null";
                        } else if (propObject instanceof BStringWritable) {
                            writable = (BStringWritable)propObject;
                            jsonElementContent = this.makeJsonString(writable.getOut().valueToString((Context)writable.getFacets()));
                        } else if (propObject instanceof BNumericWritable) {
                            writable = (BNumericWritable)propObject;
                            jsonElementContent = writable.getOut().valueToString((Context)writable.getFacets());
                        } else if (propObject instanceof BBooleanWritable) {
                            writable = (BBooleanWritable)propObject;
                            jsonElementContent = Boolean.toString(writable.getBoolean());
                        } else if (propObject instanceof BEnumWritable) {
                            writable = (BEnumWritable)propObject;
                            jsonElementContent = Integer.toString(writable.getEnum().getOrdinal());
                        }
                    }
                    if (jsonElementContent.isEmpty()) continue;
                    jsonText.append(jsonElementPrefix);
                    jsonText.append(jsonElementContent);
                    firstElement = false;
                }
                catch (Exception slotException) {
                    OssEasyApiLog.getLog().warning("[" + this.getName() + "] Slot '" + prop.getName() + "' exception: " + slotException);
                }
            }
            jsonText.append(folderSuffix);
        }

        public String makeJsonString(String textValue) {
            return "\"" + textValue.replace("\"", "\\\"") + "\"";
        }

        public void doAbort() {
            this.cancelGeneration = true;
        }
    }
}

