/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.general;

import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enable", type="boolean", defaultValue="true", flags=256), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="stringInput", type="String", defaultValue="", flags=320), @NiagaraProperty(name="numericInput", type="double", defaultValue="0.0", flags=320), @NiagaraProperty(name="booleanInput", type="boolean", defaultValue="false", flags=320), @NiagaraProperty(name="booleanMode", type="BEnum", defaultValue="BDynamicEnum.make( 1, BEnumRange.make( new int[]{ 0, 1, 2, 3 }, new String[]{ \"Ignore\", \"False_To_True\", \"True_To_False\", \"Any_Change\" } ) )"), @NiagaraProperty(name="triggerDelay", type="long", defaultValue="100L", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="lastTrigger", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65601, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnable", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="sendTrigger")
@NiagaraTopic(name="outputTrigger", eventType="BBoolean", flags=8)
public final class BTrigger
extends BComponent {
    public static final Property enable = BTrigger.newProperty((int)256, (boolean)true, null);
    public static final Property status = BTrigger.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BTrigger.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property stringInput = BTrigger.newProperty((int)320, (String)"", null);
    public static final Property numericInput = BTrigger.newProperty((int)320, (double)0.0, null);
    public static final Property booleanInput = BTrigger.newProperty((int)320, (boolean)false, null);
    public static final Property booleanMode = BTrigger.newProperty((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3}, (String[])new String[]{"Ignore", "False_To_True", "True_To_False", "Any_Change"})), null);
    public static final Property triggerDelay = BTrigger.newProperty((int)0, (long)100L, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property lastTrigger = BTrigger.newProperty((int)65601, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnable = BTrigger.newProperty((int)4, (boolean)false, null);
    public static final Action sendTrigger = BTrigger.newAction((int)0, null);
    public static final Topic outputTrigger = BTrigger.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BTrigger.class);
    private boolean lastBooleanState = false;

    public boolean getEnable() {
        return this.getBoolean(enable);
    }

    public void setEnable(boolean v) {
        this.setBoolean(enable, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getStringInput() {
        return this.getString(stringInput);
    }

    public void setStringInput(String v) {
        this.setString(stringInput, v, null);
    }

    public double getNumericInput() {
        return this.getDouble(numericInput);
    }

    public void setNumericInput(double v) {
        this.setDouble(numericInput, v, null);
    }

    public boolean getBooleanInput() {
        return this.getBoolean(booleanInput);
    }

    public void setBooleanInput(boolean v) {
        this.setBoolean(booleanInput, v, null);
    }

    public BEnum getBooleanMode() {
        return (BEnum)this.get(booleanMode);
    }

    public void setBooleanMode(BEnum v) {
        this.set(booleanMode, (BValue)v, null);
    }

    public long getTriggerDelay() {
        return this.getLong(triggerDelay);
    }

    public void setTriggerDelay(long v) {
        this.setLong(triggerDelay, v, null);
    }

    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    public void setLastTrigger(BAbsTime v) {
        this.set(lastTrigger, (BValue)v, null);
    }

    public boolean getDebugEnable() {
        return this.getBoolean(debugEnable);
    }

    public void setDebugEnable(boolean v) {
        this.setBoolean(debugEnable, v, null);
    }

    public void sendTrigger() {
        this.invoke(sendTrigger, null, null);
    }

    public void fireOutputTrigger(BBoolean event) {
        this.fire(outputTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.lastBooleanState = false;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == stringInput || property == numericInput) {
            this.scheduleTrigger();
        } else if (property == booleanInput) {
            if (this.getBooleanMode().getOrdinal() == 1) {
                if (this.getBooleanInput() && !this.lastBooleanState) {
                    this.scheduleTrigger();
                }
            } else if (this.getBooleanMode().getOrdinal() == 2) {
                if (!this.getBooleanInput() && this.lastBooleanState) {
                    this.scheduleTrigger();
                }
            } else if (this.getBooleanMode().getOrdinal() == 3 && this.getBooleanInput() != this.lastBooleanState) {
                this.scheduleTrigger();
            }
        }
        this.lastBooleanState = this.getBooleanInput();
    }

    public void doSendTrigger() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnable()) {
            this.fireOutputTrigger(BBoolean.TRUE);
            this.setLastTrigger(BAbsTime.now());
            this.debugMsg("Trigger fired");
        } else {
            this.debugMsg("Trigger disabled");
        }
    }

    public void scheduleTrigger() {
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)this.getTriggerDelay()), (Action)sendTrigger, null);
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
    }

    public void debugMsg(String messageText) {
        if (this.getDebugEnable()) {
            OssEasyApiLog.getLog().finer("[" + this.getName() + "] " + messageText);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }
}

