/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.tools.general;

import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import com.oss.ossEasyAPI.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="inputFilePath", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="out", type="String", defaultValue="", flags=73, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)"), @Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)")}), @NiagaraProperty(name="fileSize", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="lastUpdateTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=68)})
@NiagaraAction(name="update")
@NiagaraTopic(name="updateComplete", eventType="BBoolean")
public class BFileToString
extends BComponent {
    public static final Property status = BFileToString.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BFileToString.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property inputFilePath = BFileToString.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property out = BFileToString.newProperty((int)73, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true))));
    public static final Property fileSize = BFileToString.newProperty((int)65, (int)0, null);
    public static final Property lastUpdateTime = BFileToString.newProperty((int)65, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnabled = BFileToString.newProperty((int)68, (boolean)false, null);
    public static final Action update = BFileToString.newAction((int)0, null);
    public static final Topic updateComplete = BFileToString.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BFileToString.class);

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getInputFilePath() {
        return (BOrd)this.get(inputFilePath);
    }

    public void setInputFilePath(BOrd v) {
        this.set(inputFilePath, (BValue)v, null);
    }

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public int getFileSize() {
        return this.getInt(fileSize);
    }

    public void setFileSize(int v) {
        this.setInt(fileSize, v, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime v) {
        this.set(lastUpdateTime, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void fireUpdateComplete(BBoolean event) {
        this.fire(updateComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    public void changed(Property prop, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == inputFilePath) {
            this.doUpdate();
        }
    }

    public void doUpdate() {
        block5: {
            if (!OssEasyApiLicense.isLicensed()) {
                this.setFault("ossEasyAPI is not licensed");
                return;
            }
            File filePath = FileUtils.getFile(this.getInputFilePath());
            this.debugMsg("FileToString: " + filePath);
            if (this.checkFilePath(filePath)) {
                return;
            }
            try {
                String fileLine;
                BufferedReader reader = new BufferedReader(new FileReader(filePath));
                StringBuilder fileText = new StringBuilder();
                while ((fileLine = reader.readLine()) != null) {
                    fileText.append(fileLine);
                    fileText.append("\n");
                }
                reader.close();
                this.setOut(fileText.toString());
                this.setFileSize(fileText.length());
                this.setLastUpdateTime(BAbsTime.now());
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
                this.fireUpdateComplete(BBoolean.TRUE);
                this.debugMsg("File length = " + fileText.length());
            }
            catch (Exception fileException) {
                this.setFault("File exception:" + fileException);
                if (!this.getDebugEnabled()) break block5;
                fileException.printStackTrace();
            }
        }
    }

    private boolean checkFilePath(File localPath) {
        if (localPath == null) {
            this.setFault("File path invalid");
            return true;
        }
        if (!localPath.exists()) {
            this.setFault("File does not exist: '" + localPath + "'");
            return true;
        }
        if (!localPath.canRead()) {
            this.setFault("File not readable:  '" + localPath + "'");
            return true;
        }
        if (!localPath.isFile()) {
            this.setFault("File not valid:  '" + localPath + "'");
            return true;
        }
        return false;
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssEasyApiLog.getLog().severe("[" + this.getName() + "] " + faultMessage);
    }

    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            OssEasyApiLog.getLog().finer("[" + this.getName() + "] " + debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }
}

