/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.request;

import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class HttpRequest {
    private String requestApiUrl;
    private String requestHttpMethod;
    private HashMap<String, String> headerFields = null;
    private String writeBody = null;
    private int connectTimeout = 30000;
    private int readTimeout = 30000;
    private int maxResponseSize = 1000000;
    private boolean removeNewlines = false;
    private boolean requestSuccess = false;
    private boolean connectionFailure = false;
    private int responseCode = 0;
    private long requestTime = 0L;
    private String responseBody = "";
    private String responseError = "";
    private String faultMessage = "Unknown request fault";
    private String redirectLocation = null;
    private Map<String, List<String>> responseHeaders = null;
    private boolean debugEnabled = false;
    private String debugIdent = "";
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int DEFAULT_MAX_RESPONSE_SIZE = 1000000;
    private static final Logger log = OssEasyApiLog.getLog();

    public HttpRequest(String newApiUrl, String newHttpMethod, HashMap<String, String> newHeaderFields, String newWriteBody, int newConnectTimeout, int newReadTimeout, int newMaxResponseSize) {
        this.requestApiUrl = newApiUrl;
        this.requestHttpMethod = newHttpMethod;
        this.headerFields = newHeaderFields;
        this.writeBody = newWriteBody;
        this.connectTimeout = newConnectTimeout;
        this.readTimeout = newReadTimeout;
        this.maxResponseSize = newMaxResponseSize;
    }

    public HttpRequest(String newApiUrl, String newHttpMethod, HashMap<String, String> newHeaderFields, String newWriteBody) {
        this.requestApiUrl = newApiUrl;
        this.requestHttpMethod = newHttpMethod;
        this.headerFields = newHeaderFields;
        this.writeBody = newWriteBody;
    }

    public HttpRequest(String newApiUrl, String newHttpMethod, HashMap<String, String> newHeaderFields) {
        this.requestApiUrl = newApiUrl;
        this.requestHttpMethod = newHttpMethod;
        this.headerFields = newHeaderFields;
    }

    public HttpRequest(String newApiUrl, String newHttpMethod) {
        this.requestApiUrl = newApiUrl;
        this.requestHttpMethod = newHttpMethod;
    }

    public boolean sendRequest() {
        block23: {
            this.requestSuccess = false;
            this.connectionFailure = false;
            this.responseCode = 0;
            this.requestTime = 0L;
            this.responseBody = "";
            this.responseError = "";
            this.faultMessage = "unknown";
            this.redirectLocation = null;
            try {
                this.dbgMsg("Sending request: " + this.requestApiUrl);
                URL requestUrl = new URL(this.requestApiUrl);
                HttpURLConnection reqCon = (HttpURLConnection)requestUrl.openConnection();
                reqCon.setDoInput(true);
                reqCon.setConnectTimeout(this.connectTimeout);
                reqCon.setReadTimeout(this.readTimeout);
                reqCon.setInstanceFollowRedirects(true);
                reqCon.setRequestMethod(this.requestHttpMethod);
                if (this.headerFields != null) {
                    for (String fieldName : this.headerFields.keySet()) {
                        reqCon.setRequestProperty(fieldName, this.headerFields.get(fieldName));
                    }
                }
                if (this.writeBody == null) {
                    reqCon.setDoOutput(false);
                } else {
                    this.dbgMsg("Request write size = " + this.writeBody.length());
                    reqCon.setDoOutput(true);
                    reqCon.setRequestProperty("Content-Length", String.valueOf(this.writeBody.length()));
                    DataOutputStream conOutput = new DataOutputStream(reqCon.getOutputStream());
                    conOutput.write(this.writeBody.getBytes());
                }
                this.responseCode = reqCon.getResponseCode();
                if (this.responseCode < 0) {
                    this.faultMessage = "Invalid HTTP response";
                    this.responseCode = 0;
                } else {
                    InputStream inputStrm;
                    this.requestTime = System.currentTimeMillis();
                    this.dbgMsg("Request response code: " + this.responseCode + " = " + reqCon.getResponseMessage());
                    this.responseHeaders = new HashMap<String, List<String>>(reqCon.getHeaderFields());
                    long contentLength = 0L;
                    if (this.responseCode < 400) {
                        inputStrm = reqCon.getInputStream();
                        try {
                            contentLength = Long.parseLong(reqCon.getHeaderField("Content-Length"));
                            this.dbgMsg("Request response content length = " + contentLength);
                        }
                        catch (Exception exception) {}
                    } else {
                        inputStrm = reqCon.getErrorStream();
                    }
                    if (this.responseCode >= 300 && this.responseCode < 400) {
                        this.redirectLocation = reqCon.getHeaderField("Location");
                    }
                    StringBuilder responseStr = new StringBuilder();
                    boolean maxExceeded = false;
                    if (inputStrm != null) {
                        int inputChar;
                        if (reqCon.getContentEncoding() != null && reqCon.getContentEncoding().equalsIgnoreCase("gzip")) {
                            inputStrm = new GZIPInputStream(inputStrm);
                        }
                        BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStrm));
                        long charCount = 0L;
                        while ((inputChar = inputReader.read()) >= 0) {
                            ++charCount;
                            if (this.removeNewlines && (inputChar == 10 || inputChar == 13)) continue;
                            responseStr.append((char)(inputChar & 0xFF));
                            if (contentLength != 0L && charCount >= contentLength) break;
                            if (charCount < (long)this.maxResponseSize) continue;
                            maxExceeded = true;
                            break;
                        }
                        inputReader.close();
                    }
                    this.dbgMsg("Request response size = " + responseStr.length());
                    if (maxExceeded) {
                        this.faultMessage = "Maximum response size exceeded (" + this.maxResponseSize + ")";
                    } else if (this.responseCode < 400) {
                        this.dbgMsg("Request success");
                        this.responseBody = responseStr.toString();
                        this.requestSuccess = true;
                    } else {
                        this.responseError = responseStr.toString();
                        this.faultMessage = "Request failed: " + this.responseCode + " - " + reqCon.getResponseMessage();
                    }
                }
            }
            catch (SocketTimeoutException requestException) {
                this.faultMessage = "Connection timeout: " + requestException.getMessage();
                this.connectionFailure = true;
            }
            catch (SocketException requestException) {
                this.faultMessage = "Connection failed: " + requestException.getMessage();
                this.connectionFailure = true;
            }
            catch (UnknownHostException requestException) {
                this.faultMessage = "Connection failed: Unknown host: " + requestException.getMessage();
                this.connectionFailure = true;
            }
            catch (Exception requestException) {
                this.faultMessage = "Connection exception: " + requestException.getMessage();
                if (!this.debugEnabled) break block23;
                requestException.printStackTrace();
            }
        }
        return this.requestSuccess;
    }

    public boolean getRequestSuccess() {
        return this.requestSuccess;
    }

    public boolean getConnectionFailure() {
        return this.connectionFailure;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getResponseError() {
        return this.responseError;
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setApiUrl(String newApiUrl) {
        this.requestApiUrl = newApiUrl;
    }

    public void setHttpMethod(String newHttpMethod) {
        this.requestHttpMethod = newHttpMethod;
    }

    public void setHeaderFields(HashMap<String, String> newHeaderFields) {
        this.headerFields = newHeaderFields;
    }

    public void setWriteBody(String newWriteBody) {
        this.writeBody = newWriteBody;
    }

    public void setConnectTimeout(int newConnectTimeout) {
        this.connectTimeout = newConnectTimeout;
    }

    public void setReadTimeout(int newReadTimeout) {
        this.readTimeout = newReadTimeout;
    }

    public void setMaxResponseSize(int newMaxResponseSize) {
        this.maxResponseSize = newMaxResponseSize;
    }

    public void setRemoveNewlines(boolean newRemoveNewlines) {
        this.removeNewlines = newRemoveNewlines;
    }

    public void setDebugEnabled(boolean newDebugEnabled) {
        this.debugEnabled = newDebugEnabled;
    }

    public void setDebugIdent(String newDebugIdent) {
        this.debugIdent = "[" + newDebugIdent + "] ";
    }

    public void dbgMsg(String debugMessage) {
        if (this.debugEnabled) {
            log.finest(this.debugIdent + debugMessage);
        }
    }
}

