/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.processing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.util.BFolder;

public class DataTreeGenerator {
    public static final String ROOT_NODE_NAME = "Data";
    private static final Logger log = OssEasyApiLog.getLog();

    public static void generate(BComponent component, JsonElement rootJson) {
        try {
            BFolder rootFolder = DataTreeGenerator.createFolder(component, ROOT_NODE_NAME);
            if (rootFolder != null) {
                DataTreeGenerator.traverseJsonNode((BComponent)rootFolder, rootJson);
            }
        }
        catch (Exception generateException) {
            log.severe("DataTree: Exception for '" + component.getSlotPath().toString() + "': " + generateException);
            generateException.printStackTrace();
        }
    }

    private static void traverseJsonNode(BComponent component, JsonElement nodeJson) {
        if (component == null || nodeJson == null) {
            return;
        }
        if (nodeJson.isJsonObject()) {
            DataTreeGenerator.traverseJsonObject(component, nodeJson.getAsJsonObject());
        } else if (nodeJson.isJsonArray()) {
            DataTreeGenerator.traverseJsonArray(component, nodeJson.getAsJsonArray());
        } else {
            log.severe("Invalid JSON element found in: " + component.getSlotPath());
        }
    }

    private static void traverseJsonObject(BComponent component, JsonObject nodeJson) {
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (String jsonKey : nodeJson.keySet()) {
            BFolder newFolder;
            String componentName = SlotPath.escape((String)jsonKey);
            propertyNameSet.add(componentName);
            JsonElement objItem = nodeJson.get(jsonKey);
            if (objItem.isJsonPrimitive()) {
                DataTreeGenerator.createProperty(component, componentName, objItem.getAsString());
                continue;
            }
            if (objItem.isJsonObject()) {
                newFolder = DataTreeGenerator.createFolder(component, componentName);
                if (newFolder == null) continue;
                DataTreeGenerator.traverseJsonObject((BComponent)newFolder, objItem.getAsJsonObject());
                continue;
            }
            if (objItem.isJsonArray()) {
                newFolder = DataTreeGenerator.createFolder(component, componentName);
                if (newFolder == null) continue;
                DataTreeGenerator.traverseJsonArray((BComponent)newFolder, objItem.getAsJsonArray());
                continue;
            }
            if (objItem.isJsonNull()) {
                DataTreeGenerator.createProperty(component, componentName, null);
                continue;
            }
            log.severe("Invalid JSON element found in: " + component.getSlotPath());
        }
        DataTreeGenerator.removeProperties(component, propertyNameSet);
        DataTreeGenerator.sortProperties(component);
    }

    private static void traverseJsonArray(BComponent component, JsonArray nodeJson) {
        HashSet<String> propertyNameSet = new HashSet<String>();
        Iterator<JsonElement> jsonArray = nodeJson.iterator();
        int arrayIndex = 0;
        while (jsonArray.hasNext()) {
            String itemName = "Idx" + arrayIndex;
            propertyNameSet.add(itemName);
            JsonElement arrayItem = jsonArray.next();
            if (arrayItem.isJsonPrimitive()) {
                DataTreeGenerator.createProperty(component, itemName, arrayItem.getAsString());
            } else {
                BFolder newFolder = DataTreeGenerator.createFolder(component, itemName);
                if (newFolder != null) {
                    DataTreeGenerator.traverseJsonNode((BComponent)newFolder, arrayItem);
                }
            }
            ++arrayIndex;
        }
        DataTreeGenerator.removeProperties(component, propertyNameSet);
    }

    private static BFolder createFolder(BComponent component, String folderName) {
        BFolder folderResult = null;
        try {
            BValue childNode = component.get(folderName);
            if (childNode == null) {
                BFolder newFolder = new BFolder();
                component.add(folderName, (BValue)newFolder, 65537);
                folderResult = newFolder;
            } else if (childNode instanceof BFolder) {
                folderResult = (BFolder)childNode;
            } else {
                component.remove(folderName);
                BFolder newFolder = new BFolder();
                component.add(folderName, (BValue)newFolder, 65537);
                folderResult = newFolder;
            }
        }
        catch (Exception addException) {
            log.severe("DataTree: Exception while adding folder '" + folderName + "': " + addException);
            addException.printStackTrace();
        }
        return folderResult;
    }

    private static void createProperty(BComponent component, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            propertyValue = "null";
        }
        try {
            BValue childNode = component.get(propertyName);
            if (childNode == null) {
                component.add(propertyName, (BValue)BString.make((String)propertyValue), 65545);
            } else if (childNode instanceof BString) {
                component.set(propertyName, (BValue)BString.make((String)propertyValue));
            } else {
                component.remove(propertyName);
                component.add(propertyName, (BValue)BString.make((String)propertyValue), 65545);
            }
        }
        catch (Exception addException) {
            log.severe("DataTree: Exception while adding property '" + propertyName + "': " + addException);
            addException.printStackTrace();
        }
    }

    private static void removeProperties(BComponent component, Set<String> propertyNameSet) {
        for (Property child : component.getPropertiesArray()) {
            if (propertyNameSet.contains(child.getName())) continue;
            try {
                component.remove(child.getName());
            }
            catch (Exception removeException) {
                log.severe("DataTree: Exception while removing property '" + child.getName() + "': " + removeException);
                removeException.printStackTrace();
            }
        }
    }

    private static void sortProperties(BComponent component) {
        try {
            Property[] propertyList = component.getDynamicPropertiesArray();
            if (propertyList != null && propertyList.length > 0) {
                Arrays.sort(propertyList, new Comparator<Property>(){

                    @Override
                    public int compare(Property a, Property b) {
                        return a.getName().compareTo(b.getName());
                    }
                });
                component.reorder(propertyList);
            }
        }
        catch (Exception sortException) {
            log.severe("DataTree: Exception while sorting properties: " + sortException);
            sortException.printStackTrace();
        }
    }
}

