/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.legacy;

import com.oss.ossEasyAPI.legacy.BAPIAuthType;
import com.oss.ossEasyAPI.legacy.BOssEasyAPI;
import com.oss.ossEasyAPI.legacy.BSelectParseType;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Base64;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class HttpMessages {
    private String url;
    private BUsernameAndPassword creds;
    private BOssEasyAPI HttpComponentMaster;

    public HttpMessages(String url, BUsernameAndPassword creds, BOssEasyAPI HttpComponentMaster) {
        this.url = url.trim();
        this.creds = creds;
        this.HttpComponentMaster = HttpComponentMaster;
    }

    protected JSONArray sendRequest() {
        String errorResponseMessage = "Error unknown";
        try {
            String line;
            String basicAuthCred;
            byte[] basicAuthArray;
            String userpass;
            String pass;
            String user;
            try {
                if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.GETWithParam)) {
                    this.url = this.AddURL(this.url, this.HttpComponentMaster.getParamProperty());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            URL address = new URL(this.url);
            HttpURLConnection connection = (HttpURLConnection)address.openConnection();
            if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.StandardGET)) {
                connection.setRequestMethod("GET");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setDoOutput(false);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.GETWithBasicAuth)) {
                user = this.creds.getUsername();
                pass = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return HttpMessages.this.creds.getPassword().getValue();
                    }
                });
                userpass = user + ":" + pass;
                basicAuthArray = Base64.getEncoder().encode(userpass.getBytes(StandardCharsets.UTF_8));
                basicAuthCred = new String(basicAuthArray);
                connection.setRequestMethod("GET");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setRequestProperty("Authorization", "Basic " + basicAuthCred);
                connection.setDoOutput(false);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.GETWithBearerToken)) {
                connection.setRequestMethod("GET");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setRequestProperty("Authorization", "Bearer " + this.HttpComponentMaster.getBearerToken());
                connection.setDoOutput(false);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.GETWithParam)) {
                connection.setRequestMethod("GET");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setDoOutput(false);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.StandardPOST)) {
                connection.setRequestMethod("POST");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setDoOutput(true);
                this.AddBody(connection);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.POSTWithBasicAuth)) {
                user = this.creds.getUsername();
                pass = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return HttpMessages.this.creds.getPassword().getValue();
                    }
                });
                userpass = user + ":" + pass;
                basicAuthArray = Base64.getEncoder().encode(userpass.getBytes(StandardCharsets.UTF_8));
                basicAuthCred = new String(basicAuthArray);
                connection.setRequestMethod("POST");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setRequestProperty("Authorization", "Basic " + basicAuthCred);
                connection.setDoOutput(true);
                this.AddBody(connection);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.POSTWithBearerToken)) {
                connection.setRequestMethod("POST");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setRequestProperty("Authorization", "Bearer " + this.HttpComponentMaster.getBearerToken());
                connection.setDoOutput(true);
                this.AddBody(connection);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.StandardPUT)) {
                connection.setRequestMethod("PUT");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setDoOutput(true);
                this.AddBody(connection);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.PUTWithBasicAuth)) {
                user = this.creds.getUsername();
                pass = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return HttpMessages.this.creds.getPassword().getValue();
                    }
                });
                userpass = user + ":" + pass;
                basicAuthArray = Base64.getEncoder().encode(userpass.getBytes(StandardCharsets.UTF_8));
                basicAuthCred = new String(basicAuthArray);
                connection.setRequestMethod("PUT");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setRequestProperty("Authorization", "Basic " + basicAuthCred);
                connection.setDoOutput(true);
                this.AddBody(connection);
            } else if (this.HttpComponentMaster.getRequestType().equals((Object)BAPIAuthType.PUTWithBearerToken)) {
                connection.setRequestMethod("PUT");
                connection = this.AddHeader(this.HttpComponentMaster.getHeaderProperty(), connection);
                connection.setRequestProperty("Authorization", "Bearer " + this.HttpComponentMaster.getBearerToken());
                connection.setDoOutput(true);
                this.AddBody(connection);
            }
            this.HttpComponentMaster.setOutString("Connection in progress");
            this.HttpComponentMaster.debug("Sending request");
            int responseCode = connection.getResponseCode();
            this.HttpComponentMaster.setResponseCode(responseCode);
            errorResponseMessage = "Error: " + responseCode + " - " + connection.getResponseMessage();
            if (responseCode == 200 || responseCode == 201 || responseCode == 202) {
                this.HttpComponentMaster.debug("Request success");
                BufferedReader inStrm = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder results = new StringBuilder();
                while ((line = inStrm.readLine()) != null) {
                    results.append(line);
                }
                inStrm.close();
                int SubStringLength = 25000;
                this.HttpComponentMaster.setOutString(results.length() > SubStringLength ? results.toString().substring(0, SubStringLength) : results.toString());
                this.HttpComponentMaster.setLastUpdate(BAbsTime.now());
                JSONArray jsonResp = this.processResponse(results.toString());
                this.HttpComponentMaster.setErrorFlag(false);
                if (jsonResp != null) {
                    this.HttpComponentMaster.setJsonString(jsonResp.toString());
                }
                return jsonResp;
            }
            if (responseCode == 204) {
                this.HttpComponentMaster.setOutString("");
                this.HttpComponentMaster.setLastUpdate(BAbsTime.now());
                this.HttpComponentMaster.setErrorFlag(false);
                this.HttpComponentMaster.setJsonString("");
                this.HttpComponentMaster.debug("Request returned no content (204)");
                return null;
            }
            this.HttpComponentMaster.setOutString(errorResponseMessage);
            this.HttpComponentMaster.setErrorFlag(true);
            this.HttpComponentMaster.error(errorResponseMessage);
            if (connection.getErrorStream() != null) {
                BufferedReader errStrm = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                StringBuilder errBody = new StringBuilder();
                while ((line = errStrm.readLine()) != null) {
                    errBody.append(line);
                }
                errStrm.close();
                this.HttpComponentMaster.debugExtra("Error response: " + errBody.toString());
            }
            return null;
        }
        catch (MalformedURLException urlEx) {
            urlEx.printStackTrace();
            errorResponseMessage = "Connection Failed: Malformed URL Exception";
        }
        catch (SSLException sslEx) {
            sslEx.printStackTrace();
            errorResponseMessage = "Connection Failed: SSL Exception";
        }
        catch (UnknownHostException hostEx) {
            hostEx.printStackTrace();
            errorResponseMessage = "Connection Failed: Unknown Host Exception";
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            errorResponseMessage = "Connection Failed: IO Exception";
        }
        catch (IllegalArgumentException argEx) {
            argEx.printStackTrace();
            errorResponseMessage = "Connection Failed: Invalid Characters in URL";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errorResponseMessage = "Unknown Exception: " + ex;
        }
        this.HttpComponentMaster.setOutString(errorResponseMessage);
        this.HttpComponentMaster.setErrorFlag(true);
        this.HttpComponentMaster.error(errorResponseMessage);
        return null;
    }

    public JSONArray processResponse(String response) {
        if (this.HttpComponentMaster.getDataType().equals((Object)BSelectParseType.Type_Detect)) {
            JSONArray respArr = this.processXMLandHTML(response);
            if (respArr != null) {
                return respArr;
            }
            respArr = this.processJSONinHtml(response);
            if (respArr != null) {
                return respArr;
            }
            respArr = this.processJSON(response);
            if (respArr != null) {
                return respArr;
            }
            return null;
        }
        if (this.HttpComponentMaster.getDataType().equals((Object)BSelectParseType.Type_XML) || this.HttpComponentMaster.getDataType().equals((Object)BSelectParseType.Type_HTML)) {
            JSONArray respArr = this.processXMLandHTML(response);
            return respArr;
        }
        if (this.HttpComponentMaster.getDataType().equals((Object)BSelectParseType.Type_JSONinHTML)) {
            JSONArray respArr = this.processJSONinHtml(response);
            return respArr;
        }
        if (this.HttpComponentMaster.getDataType().equals((Object)BSelectParseType.Type_JSON)) {
            JSONArray respArr = this.processJSON(response);
            return respArr;
        }
        return null;
    }

    private JSONArray processXMLandHTML(String response) {
        if (!(response.contains("<") || response.contains("</") || response.contains(">"))) {
            this.CheckAndSetDataType(BSelectParseType.Type_Detect);
            return null;
        }
        try {
            JSONObject responseAsJson = XML.toJSONObject(response);
            JSONArray respArr = new JSONArray();
            respArr.put(responseAsJson);
            if (response.toLowerCase().contains("<html")) {
                this.CheckAndSetDataType(BSelectParseType.Type_HTML);
            } else {
                this.CheckAndSetDataType(BSelectParseType.Type_XML);
            }
            return respArr;
        }
        catch (Exception e) {
            this.CheckAndSetDataType(BSelectParseType.Type_Detect);
            return null;
        }
    }

    private JSONArray processJSONinHtml(String response) {
        if (!response.toLowerCase().contains("<html")) {
            this.CheckAndSetDataType(BSelectParseType.Type_Detect);
            return null;
        }
        int indexOfOpeningBrace = response.indexOf(123);
        int indexOfClosingBrace = response.lastIndexOf(125) + 1;
        if (indexOfOpeningBrace != -1 && indexOfClosingBrace != -1) {
            if (indexOfOpeningBrace > 0 && response.charAt(indexOfOpeningBrace - 1) == '[') {
                String jsonArray = response.substring(--indexOfOpeningBrace, ++indexOfClosingBrace);
                JSONArray respArr = new JSONArray(jsonArray);
                this.CheckAndSetDataType(BSelectParseType.Type_JSONinHTML);
                return respArr;
            }
            try {
                String json = response.substring(indexOfOpeningBrace, indexOfClosingBrace);
                JSONObject respObj = new JSONObject(json);
                JSONArray respArr = new JSONArray();
                respArr.put(respObj);
                this.CheckAndSetDataType(BSelectParseType.Type_JSONinHTML);
                return respArr;
            }
            catch (JSONException je) {
                je.printStackTrace();
            }
        }
        this.CheckAndSetDataType(BSelectParseType.Type_Detect);
        return null;
    }

    private JSONArray processJSON(String response) {
        try {
            JSONObject o = new JSONObject(response);
            JSONArray a = new JSONArray();
            a.put(o);
            this.CheckAndSetDataType(BSelectParseType.Type_JSON);
            return a;
        }
        catch (JSONException je) {
            try {
                JSONArray a = new JSONArray(response);
                this.CheckAndSetDataType(BSelectParseType.Type_JSON);
                return a;
            }
            catch (JSONException je2) {
                this.CheckAndSetDataType(BSelectParseType.Type_Detect);
                return null;
            }
        }
    }

    private void CheckAndSetDataType(BSelectParseType x) {
        if (!this.HttpComponentMaster.getDataType().equals((Object)x)) {
            this.HttpComponentMaster.setDataType(x);
        }
    }

    private HttpsURLConnection AddHeader(String x, HttpsURLConnection con) {
        System.out.print(x);
        String[] Lines = this.SplitHeader(x);
        int IndexOfcolon = 0;
        String Key = "";
        String Value = "";
        for (String L : Lines) {
            IndexOfcolon = L.indexOf(":");
            if (IndexOfcolon <= 0) continue;
            Key = L.substring(0, IndexOfcolon);
            Value = L.substring(IndexOfcolon + 1, L.length());
            try {
                con.setRequestProperty(Key, Value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return con;
    }

    private HttpURLConnection AddHeader(String x, HttpURLConnection con) {
        String[] Lines = this.SplitHeader(x);
        int IndexOfcolon = 0;
        String Key = "";
        String Value = "";
        for (String L : Lines) {
            IndexOfcolon = L.indexOf(":");
            if (IndexOfcolon <= 0) continue;
            Key = L.substring(0, IndexOfcolon);
            Value = L.substring(IndexOfcolon + 1, L.length());
            try {
                con.setRequestProperty(Key, Value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return con;
    }

    private String AddURL(String URL2, String x) {
        if (x.isEmpty()) {
            return URL2;
        }
        String[] Lines = this.SplitHeader(x);
        int IndexOfcolon = 0;
        String Key = "";
        String Value = "";
        StringBuilder OutString = new StringBuilder();
        OutString.append(URL2);
        OutString.append('?');
        for (String L : Lines) {
            L = L.replaceAll("\\s+", "");
            IndexOfcolon = L.indexOf(":");
            Key = L.substring(0, IndexOfcolon);
            Value = L.substring(IndexOfcolon + 1);
            OutString.append(Key);
            OutString.append('=');
            OutString.append(Value);
            OutString.append("&");
        }
        OutString.deleteCharAt(OutString.length() - 1);
        return OutString.toString();
    }

    private String[] SplitHeader(String x) {
        String[] Lines = x.split("\\r?\\n");
        return Lines;
    }

    private void AddBody(HttpURLConnection Connection) {
        try {
            DataOutputStream wr = new DataOutputStream(Connection.getOutputStream());
            wr.write(this.HttpComponentMaster.getBodyProperty().getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

