/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.legacy;

import com.oss.ossEasyAPI.legacy.BAPIAuthType;
import com.oss.ossEasyAPI.legacy.BSelectParseType;
import com.oss.ossEasyAPI.legacy.HttpMessages;
import com.tridium.util.EscUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.license.FeatureLicenseExpiredException;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.license.LicenseManager;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;
import org.json.JSONArray;
import org.json.JSONObject;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="url", type="BString", flags=8, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="apiEndpoint", type="BString", flags=8, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="RequestType", type="BAPIAuthType", flags=8, defaultValue="StandardGET"), @NiagaraProperty(name="ParamProperty", type="BString", flags=12, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)"), @Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="HeaderProperty", type="BString", flags=12, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)"), @Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="BodyProperty", type="BString", flags=12, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)"), @Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="credentials", type="BUsernameAndPassword", flags=12, defaultValue="new BUsernameAndPassword()"), @NiagaraProperty(name="bearerToken", type="BString", flags=12, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="DataType", type="BSelectParseType", flags=8, defaultValue="Type_Detect"), @NiagaraProperty(name="AutomaticUpdate", type="BBoolean", flags=8, defaultValue="BBoolean.make(false)"), @NiagaraProperty(name="UpdatePeriod", type="BRelTime", flags=12, defaultValue="BRelTime.make(60000)"), @NiagaraProperty(name="LastUpdate", type="BAbsTime", flags=1, defaultValue="BAbsTime.NULL"), @NiagaraProperty(name="responseCode", type="int", flags=1, defaultValue="0"), @NiagaraProperty(name="OutString", type="BString", flags=9, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="jsonString", type="BString", flags=5, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="ErrorFlag", type="BBoolean", flags=9, defaultValue="BBoolean.make(false)"), @NiagaraProperty(name="OrigNav", type="BString", flags=5, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="OrigSource", type="BString", flags=5, defaultValue="BString.make(\"\")"), @NiagaraProperty(name="OrigTarget", type="BString", flags=5, defaultValue="BString.make(\"\")")})
@NiagaraTopic(name="PassThrough")
@NiagaraActions(value={@NiagaraAction(name="getData"), @NiagaraAction(name="hiddenAction", flags=4), @NiagaraAction(name="hiddenActionLicence", flags=4)})
public class BOssEasyAPI
extends BComponent {
    public static final Property url = BOssEasyAPI.newProperty((int)8, (BValue)BString.make((String)""), null);
    public static final Property apiEndpoint = BOssEasyAPI.newProperty((int)8, (BValue)BString.make((String)""), null);
    public static final Property RequestType = BOssEasyAPI.newProperty((int)8, (BValue)BAPIAuthType.StandardGET, null);
    public static final Property ParamProperty = BOssEasyAPI.newProperty((int)12, (BValue)BString.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60))));
    public static final Property HeaderProperty = BOssEasyAPI.newProperty((int)12, (BValue)BString.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60))));
    public static final Property BodyProperty = BOssEasyAPI.newProperty((int)12, (BValue)BString.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60))));
    public static final Property credentials = BOssEasyAPI.newProperty((int)12, (BValue)new BUsernameAndPassword(), null);
    public static final Property bearerToken = BOssEasyAPI.newProperty((int)12, (BValue)BString.make((String)""), null);
    public static final Property DataType = BOssEasyAPI.newProperty((int)8, (BValue)BSelectParseType.Type_Detect, null);
    public static final Property AutomaticUpdate = BOssEasyAPI.newProperty((int)8, (boolean)BBoolean.make((boolean)false).getBoolean(), null);
    public static final Property UpdatePeriod = BOssEasyAPI.newProperty((int)12, (BValue)BRelTime.make((long)60000L), null);
    public static final Property LastUpdate = BOssEasyAPI.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property responseCode = BOssEasyAPI.newProperty((int)1, (int)0, null);
    public static final Property OutString = BOssEasyAPI.newProperty((int)9, (BValue)BString.make((String)""), null);
    public static final Property jsonString = BOssEasyAPI.newProperty((int)5, (BValue)BString.make((String)""), null);
    public static final Property ErrorFlag = BOssEasyAPI.newProperty((int)9, (boolean)BBoolean.make((boolean)false).getBoolean(), null);
    public static final Property OrigNav = BOssEasyAPI.newProperty((int)5, (BValue)BString.make((String)""), null);
    public static final Property OrigSource = BOssEasyAPI.newProperty((int)5, (BValue)BString.make((String)""), null);
    public static final Property OrigTarget = BOssEasyAPI.newProperty((int)5, (BValue)BString.make((String)""), null);
    public static final Action getData = BOssEasyAPI.newAction((int)0, null);
    public static final Action hiddenAction = BOssEasyAPI.newAction((int)4, null);
    public static final Action hiddenActionLicence = BOssEasyAPI.newAction((int)4, null);
    public static final Topic PassThrough = BOssEasyAPI.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssEasyAPI.class);
    private boolean gettingMessage = false;
    private int FolderIncrement = 0;
    private int VariableIncrement = 0;
    private Clock.Ticket Bob;
    private Clock.Ticket Bob2;
    private BRelation[] WeAreFamily;
    private ArrayList<String> ALinkToThePastSource = new ArrayList();
    private ArrayList<String> ALinkToThePastTarget = new ArrayList();
    private ArrayList<String> ALinkToThePastOrd = new ArrayList();
    Thread requestThread = null;
    boolean isLicensedFlag = false;
    boolean initalLicenceCheck = false;
    private static final Logger log = Logger.getLogger("ossEasyApi");
    private static final String LICENSE_VENDOR = "OneSightSolutions";
    private static final String LICENSE_FEATURE = "ossEasyAPI";

    public String getUrl() {
        return this.getString(url);
    }

    public void setUrl(String v) {
        this.setString(url, v, null);
    }

    public String getApiEndpoint() {
        return this.getString(apiEndpoint);
    }

    public void setApiEndpoint(String v) {
        this.setString(apiEndpoint, v, null);
    }

    public BAPIAuthType getRequestType() {
        return (BAPIAuthType)this.get(RequestType);
    }

    public void setRequestType(BAPIAuthType v) {
        this.set(RequestType, (BValue)v, null);
    }

    public String getParamProperty() {
        return this.getString(ParamProperty);
    }

    public void setParamProperty(String v) {
        this.setString(ParamProperty, v, null);
    }

    public String getHeaderProperty() {
        return this.getString(HeaderProperty);
    }

    public void setHeaderProperty(String v) {
        this.setString(HeaderProperty, v, null);
    }

    public String getBodyProperty() {
        return this.getString(BodyProperty);
    }

    public void setBodyProperty(String v) {
        this.setString(BodyProperty, v, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public String getBearerToken() {
        return this.getString(bearerToken);
    }

    public void setBearerToken(String v) {
        this.setString(bearerToken, v, null);
    }

    public BSelectParseType getDataType() {
        return (BSelectParseType)this.get(DataType);
    }

    public void setDataType(BSelectParseType v) {
        this.set(DataType, (BValue)v, null);
    }

    public boolean getAutomaticUpdate() {
        return this.getBoolean(AutomaticUpdate);
    }

    public void setAutomaticUpdate(boolean v) {
        this.setBoolean(AutomaticUpdate, v, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(UpdatePeriod);
    }

    public void setUpdatePeriod(BRelTime v) {
        this.set(UpdatePeriod, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(LastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(LastUpdate, (BValue)v, null);
    }

    public int getResponseCode() {
        return this.getInt(responseCode);
    }

    public void setResponseCode(int v) {
        this.setInt(responseCode, v, null);
    }

    public String getOutString() {
        return this.getString(OutString);
    }

    public void setOutString(String v) {
        this.setString(OutString, v, null);
    }

    public String getJsonString() {
        return this.getString(jsonString);
    }

    public void setJsonString(String v) {
        this.setString(jsonString, v, null);
    }

    public boolean getErrorFlag() {
        return this.getBoolean(ErrorFlag);
    }

    public void setErrorFlag(boolean v) {
        this.setBoolean(ErrorFlag, v, null);
    }

    public String getOrigNav() {
        return this.getString(OrigNav);
    }

    public void setOrigNav(String v) {
        this.setString(OrigNav, v, null);
    }

    public String getOrigSource() {
        return this.getString(OrigSource);
    }

    public void setOrigSource(String v) {
        this.setString(OrigSource, v, null);
    }

    public String getOrigTarget() {
        return this.getString(OrigTarget);
    }

    public void setOrigTarget(String v) {
        this.setString(OrigTarget, v, null);
    }

    public void getData() {
        this.invoke(getData, null, null);
    }

    public void hiddenAction() {
        this.invoke(hiddenAction, null, null);
    }

    public void hiddenActionLicence() {
        this.invoke(hiddenActionLicence, null, null);
    }

    public void firePassThrough(BValue event) {
        this.fire(PassThrough, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.SetUpClockSchedule(true);
        this.SetUpClockScheduleLicence(true);
        if (!this.initalLicenceCheck) {
            this.isLicensedFlag = this.isLicensed();
            this.initalLicenceCheck = true;
        }
    }

    private boolean isLicensed() {
        LicenseManager manager = Sys.getLicenseManager();
        try {
            Feature feature = manager.checkFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            return true;
        }
        catch (FeatureLicenseExpiredException expired) {
            this.setOutString("Component license has expired");
            log.severe("ossEasyAPI license has expired");
            return false;
        }
        catch (FeatureNotLicensedException notLicensed) {
            this.setOutString("Component not licensed for this host");
            log.severe("ossEasyAPI not licensed");
            return false;
        }
        catch (LicenseDatabaseException databaseExcep) {
            this.setOutString("License database exception - Please contact OSS");
            log.severe("ossEasyAPI license fault");
            return false;
        }
    }

    public void doHiddenAction() {
        if (this.getAutomaticUpdate()) {
            this.doGetData();
        }
    }

    public void doHiddenActionLicence() {
        this.isLicensedFlag = this.isLicensed();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(AutomaticUpdate)) {
            if (this.getAutomaticUpdate()) {
                this.setFlags((Slot)UpdatePeriod, 8);
                this.SetUpClockSchedule(true);
            } else {
                this.setFlags((Slot)UpdatePeriod, 12);
                this.SetUpClockSchedule(false);
            }
        }
        if (property.equals(UpdatePeriod)) {
            if (this.getUpdatePeriod().getMillis() < 1000L) {
                this.setUpdatePeriod(BRelTime.make((long)1000L));
            }
            this.SetUpClockSchedule(true);
        }
        if (property.equals(RequestType)) {
            if (this.getRequestType().equals((Object)BAPIAuthType.StandardGET)) {
                this.setFlags((Slot)BodyProperty, 12);
                this.setFlags((Slot)credentials, 12);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.GETWithBasicAuth)) {
                this.setFlags((Slot)BodyProperty, 12);
                this.setFlags((Slot)credentials, 8);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.GETWithBearerToken)) {
                this.setFlags((Slot)BodyProperty, 12);
                this.setFlags((Slot)credentials, 12);
                this.setFlags((Slot)bearerToken, 8);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.GETWithParam)) {
                this.setFlags((Slot)BodyProperty, 12);
                this.setFlags((Slot)ParamProperty, 8);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)credentials, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.StandardPOST)) {
                this.setFlags((Slot)HeaderProperty, 8);
                this.setFlags((Slot)BodyProperty, 8);
                this.setFlags((Slot)credentials, 12);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.POSTWithBasicAuth)) {
                this.setFlags((Slot)HeaderProperty, 8);
                this.setFlags((Slot)BodyProperty, 8);
                this.setFlags((Slot)credentials, 8);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.POSTWithBearerToken)) {
                this.setFlags((Slot)HeaderProperty, 8);
                this.setFlags((Slot)BodyProperty, 8);
                this.setFlags((Slot)credentials, 12);
                this.setFlags((Slot)bearerToken, 8);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.StandardPUT)) {
                this.setFlags((Slot)HeaderProperty, 8);
                this.setFlags((Slot)BodyProperty, 8);
                this.setFlags((Slot)credentials, 12);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.PUTWithBasicAuth)) {
                this.setFlags((Slot)HeaderProperty, 8);
                this.setFlags((Slot)BodyProperty, 8);
                this.setFlags((Slot)credentials, 8);
                this.setFlags((Slot)bearerToken, 12);
                this.setFlags((Slot)ParamProperty, 12);
            }
            if (this.getRequestType().equals((Object)BAPIAuthType.PUTWithBearerToken)) {
                this.setFlags((Slot)HeaderProperty, 8);
                this.setFlags((Slot)BodyProperty, 8);
                this.setFlags((Slot)credentials, 12);
                this.setFlags((Slot)bearerToken, 8);
                this.setFlags((Slot)ParamProperty, 12);
            }
        }
    }

    public void doGetData() {
        if (!this.isLicensedFlag) {
            this.setOutString("Error: component not licenced");
            log.severe("ossEasyAPI not licensed");
            return;
        }
        if (!this.gettingMessage) {
            this.gettingMessage = true;
            Runnable requestRunnable = () -> {
                HttpMessages msg = new HttpMessages(this.getUrl().replaceAll("\\s+", "") + this.getApiEndpoint(), this.getCredentials(), this);
                this.setOutString("Getting Data");
                this.setJsonString("");
                JSONArray returnedObj = msg.sendRequest();
                this.CreateFileStructure(returnedObj);
            };
            if (this.requestThread == null) {
                this.requestThread = new Thread(requestRunnable);
            }
            if (this.requestThread.isAlive()) {
                return;
            }
            this.requestThread.start();
            this.requestThread = null;
            this.gettingMessage = false;
        } else {
            this.setOutString("Connection attempt already in progress");
            this.debug("Connection attempt already in progress");
        }
    }

    private void CreateFileStructure(JSONArray x) {
        if (x == null) {
            return;
        }
        String BaseStr = this.getNavOrd().toString();
        String CurrentFolder = this.CreateFolder(BaseStr, "Master");
        this.WeAreFamily = null;
        this.getCompositeLinks();
        this.NukeComp();
        this.CheckJSONTypesChildArray(x, CurrentFolder);
        this.FolderIncrement = 0;
        this.VariableIncrement = 0;
        this.setCompositeLinks();
        this.firePassThrough((BValue)BString.make((String)"Trigger"));
    }

    private boolean isFolder(BOrd ord) {
        try {
            ord.resolve();
            return true;
        }
        catch (UnresolvedException ure) {
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void CheckJSONTypesChildObject(JSONObject x, String key, String CurrentFolder) {
        switch (this.CheckJSONTypesCheckChild(x.get(key))) {
            case 1: {
                CurrentFolder = this.CreateFolder(CurrentFolder, key.toString());
                JSONObject y = x.getJSONObject(key);
                Iterator<String> keysObj = y.keys();
                while (keysObj.hasNext()) {
                    String keyInObj = keysObj.next();
                    this.CheckJSONTypesChildObject(y, keyInObj, CurrentFolder);
                }
                break;
            }
            case 2: {
                CurrentFolder = this.CreateFolder(CurrentFolder, key.toString());
                this.CheckJSONTypesChildArray(x.getJSONArray(key), CurrentFolder);
                break;
            }
            case 3: {
                this.CreateStringPoint(CurrentFolder, key, x.get(key).toString());
                break;
            }
        }
    }

    private void CheckJSONTypesChildArray(JSONArray x, String CurrentFolder) {
        for (int i = 0; i < x.length(); ++i) {
            String CurrentFolderTemp = CurrentFolder;
            if (this.CheckJSONTypesCheckChild(x.get(i)) != 3) {
                if (x.length() != 1) {
                    CurrentFolderTemp = this.CreateFolder(CurrentFolder, "Idx" + Integer.toString(i));
                }
            } else {
                this.CreateStringPoint(CurrentFolder, null, x.get(i).toString());
                continue;
            }
            if (this.CheckJSONTypesCheckChild(x.get(i)) == 2) {
                this.CheckJSONTypesChildArray(x.getJSONArray(i), CurrentFolderTemp);
                continue;
            }
            JSONObject y = x.getJSONObject(i);
            Iterator<String> keysObj = y.keys();
            while (keysObj.hasNext()) {
                String keyInObj = keysObj.next();
                this.CheckJSONTypesChildObject(y, keyInObj, CurrentFolderTemp);
            }
        }
    }

    private int CheckJSONTypesCheckChild(Object x) {
        if (x instanceof JSONObject) {
            return 1;
        }
        if (x instanceof JSONArray) {
            return 2;
        }
        return 3;
    }

    private String CreateFolder(String CurrentOrd, String FolderName) {
        if (FolderName == null) {
            ++this.FolderIncrement;
            FolderName = "Folder" + Integer.toString(this.FolderIncrement);
        }
        FolderName = this.CreateValidName(FolderName);
        if (!this.isFolder(BOrd.make((String)(CurrentOrd + "/" + FolderName)))) {
            BOrd.make((String)CurrentOrd).get().asComponent().add(FolderName, (BValue)BTypeSpec.make((Type)BFolder.TYPE).getInstance());
        }
        return CurrentOrd + "/" + FolderName;
    }

    private void CreateStringPoint(String CurrentPath, String PointName, String Value) {
        if (PointName == null) {
            ++this.VariableIncrement;
            PointName = "Var" + Integer.toString(this.VariableIncrement);
        }
        PointName = this.CreateValidName(PointName);
        if (!this.isFolder(BOrd.make((String)(CurrentPath + "/" + PointName)))) {
            BOrd.make((String)CurrentPath).get().asComponent().add(PointName, (BValue)BString.make((String)Value), 9);
        }
    }

    private String CreateValidName(String Input) {
        if (!SlotPath.isValidName((String)Input)) {
            String NewName = EscUtil.slot.escape(Input);
            return NewName;
        }
        return Input;
    }

    private void SetUpClockSchedule(Boolean x) {
        block5: {
            try {
                if (x.booleanValue()) {
                    try {
                        this.Bob.cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.Bob = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod().abs(), (Action)hiddenAction, null);
                    break block5;
                }
                this.Bob.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void SetUpClockScheduleLicence(Boolean x) {
        block5: {
            try {
                if (x.booleanValue()) {
                    try {
                        this.Bob2.cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.Bob2 = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)3600000L), (Action)hiddenActionLicence, null);
                    break block5;
                }
                this.Bob2.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getCompositeLinks() {
        this.ALinkToThePastOrd = this.retrieveFromSlot(this.getOrigNav());
        this.ALinkToThePastTarget = this.retrieveFromSlot(this.getOrigTarget());
        this.ALinkToThePastSource = this.retrieveFromSlot(this.getOrigSource());
        for (Slot Comp : this.getSlotsArray()) {
            try {
                BLink[] Temp;
                if (!Flags.isComposite((BComplex)this, (Slot)Comp) || !Comp.asProperty().getType().is(BString.TYPE)) continue;
                for (BLink Test : Temp = this.getLinks(Comp)) {
                    this.ALinkToThePastSource.add(Test.getSourceSlot().getName());
                    this.ALinkToThePastTarget.add(Test.getTargetSlot().getName());
                    this.ALinkToThePastOrd.add(Test.getSourceComponent().getNavOrd().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setOrigNav(this.setTempToSlot(this.ALinkToThePastOrd));
        this.setOrigSource(this.setTempToSlot(this.ALinkToThePastSource));
        this.setOrigTarget(this.setTempToSlot(this.ALinkToThePastTarget));
    }

    private void setCompositeLinks() {
        ArrayList<BComponent> ALinkToThePastComp = new ArrayList<BComponent>();
        ArrayList<String> TempSlot = new ArrayList<String>();
        ArrayList<String> TempTarget = new ArrayList<String>();
        ArrayList<String> TempOrd = new ArrayList<String>();
        this.ALinkToThePastOrd = this.retrieveFromSlot(this.getOrigNav());
        this.ALinkToThePastTarget = this.retrieveFromSlot(this.getOrigTarget());
        this.ALinkToThePastSource = this.retrieveFromSlot(this.getOrigSource());
        for (int i = 0; i < this.ALinkToThePastOrd.size(); ++i) {
            try {
                ALinkToThePastComp.add(BOrd.make((String)this.ALinkToThePastOrd.get(i)).resolve().getComponent());
                try {
                    BOrd.make((String)(((BComponent)ALinkToThePastComp.get(i)).getNavOrd() + "/" + this.ALinkToThePastSource.get(i))).resolve();
                    BLink Zelda = new BLink(((BComponent)ALinkToThePastComp.get(i)).getHandleOrd(), this.ALinkToThePastSource.get(i), this.ALinkToThePastTarget.get(i), true);
                    String Name = "LinkLink" + i;
                    this.add(Name, (BValue)Zelda);
                }
                catch (Exception e) {
                    TempSlot.add(this.ALinkToThePastSource.get(i));
                    TempTarget.add(this.ALinkToThePastTarget.get(i));
                    TempOrd.add(this.ALinkToThePastOrd.get(i));
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ALinkToThePastOrd = TempOrd;
        this.ALinkToThePastSource = TempSlot;
        this.ALinkToThePastTarget = TempTarget;
        this.setOrigNav(this.setTempToSlot(this.ALinkToThePastOrd));
        this.setOrigSource(this.setTempToSlot(this.ALinkToThePastSource));
        this.setOrigTarget(this.setTempToSlot(this.ALinkToThePastTarget));
    }

    private String setTempToSlot(ArrayList<String> In) {
        if (In.isEmpty()) {
            return "";
        }
        StringBuilder StrBui = new StringBuilder();
        for (String x : In) {
            StrBui.append(x);
            StrBui.append(",");
        }
        return StrBui.toString();
    }

    private ArrayList<String> retrieveFromSlot(String In) {
        if (In.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] Strs = In.split(",");
        ArrayList<String> Out = new ArrayList<String>();
        for (String x : Strs) {
            Out.add(x);
        }
        return Out;
    }

    private void NukeComp() {
        String BaseStr = this.getNavOrd().toString() + "/Master";
        if (!this.isFolder(BOrd.make((String)BaseStr))) {
            return;
        }
        BOrd.make((String)BaseStr).get().asComponent().removeAll();
    }

    public void error(String errorMessage) {
        log.fine("[" + this.getName() + "]: " + errorMessage);
    }

    public void debug(String debugMessage) {
        log.finer("[" + this.getName() + "]: " + debugMessage);
    }

    public void debugExtra(String debugMessage) {
        log.finest("[" + this.getName() + "]: " + debugMessage);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/cloud-icon.png");
    }
}

