/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.alarm.BApiAlarm;
import com.oss.ossEasyAPI.api.ApiRequestPool;
import com.oss.ossEasyAPI.api.ApiRequestTask;
import com.oss.ossEasyAPI.api.BHttpAuthType;
import com.oss.ossEasyAPI.api.BHttpRequestHeader;
import com.oss.ossEasyAPI.api.BHttpRequestMethod;
import com.oss.ossEasyAPI.api.BHttpResponseHeader;
import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.util.logging.Logger;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="alarm", type="BApiAlarm", defaultValue="new BApiAlarm()"), @NiagaraProperty(name="currentState", type="String", defaultValue="Idle", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="apiUrl", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="httpMethod", type="BHttpRequestMethod", defaultValue="BHttpRequestMethod.get"), @NiagaraProperty(name="authorisation", type="BHttpAuthType", defaultValue="BHttpAuthType.none"), @NiagaraProperty(name="credentials", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=4), @NiagaraProperty(name="bearerToken", type="String", defaultValue="", flags=4, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="httpHeader", type="BHttpRequestHeader", defaultValue="new BHttpRequestHeader()"), @NiagaraProperty(name="httpBody", type="String", defaultValue="", flags=4, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)"), @Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="automaticUpdate", type="boolean", defaultValue="false"), @NiagaraProperty(name="updatePeriod", type="BRelTime", defaultValue="BRelTime.make( 600000 )", flags=4), @NiagaraProperty(name="useThreadPool", type="boolean", defaultValue="false"), @NiagaraProperty(name="clearOutputOnFault", type="boolean", defaultValue="true"), @NiagaraProperty(name="generateDataTree", type="boolean", defaultValue="true"), @NiagaraProperty(name="startupDelayMax", type="int", defaultValue="100", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="connectTimeout", type="int", defaultValue="30000", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="readTimeout", type="int", defaultValue="30000", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="maxResponseSize", type="int", defaultValue="1000000", flags=4, facets={@Facet(name="BFacets.UNITS", value="BUnit.make( \"bytes\", \"bytes\", BDimension.NULL )")}), @NiagaraProperty(name="removeLineEnds", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="multilineResults", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="requestSuccess", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="lastRequestSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="responseCode", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="responseHeader", type="BHttpResponseHeader", defaultValue="new BHttpResponseHeader()", flags=1), @NiagaraProperty(name="responseBody", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="responseJson", type="String", flags=9, defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="responseError", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="sendRequest"), @NiagaraAction(name="startRequestTask", flags=4), @NiagaraAction(name="stopRequestTask", flags=4)})
@NiagaraTopics(value={@NiagaraTopic(name="successTrigger", eventType="BBoolean"), @NiagaraTopic(name="failureTrigger", eventType="BBoolean"), @NiagaraTopic(name="routeJson", eventType="BString")})
public class BOssEasyApiRequest
extends BComponent {
    public static final Property enabled = BOssEasyApiRequest.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssEasyApiRequest.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssEasyApiRequest.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property alarm = BOssEasyApiRequest.newProperty((int)0, (BValue)new BApiAlarm(), null);
    public static final Property currentState = BOssEasyApiRequest.newProperty((int)65, (String)"Idle", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property apiUrl = BOssEasyApiRequest.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property httpMethod = BOssEasyApiRequest.newProperty((int)0, (BValue)BHttpRequestMethod.get, null);
    public static final Property authorisation = BOssEasyApiRequest.newProperty((int)0, (BValue)BHttpAuthType.none, null);
    public static final Property credentials = BOssEasyApiRequest.newProperty((int)4, (BValue)new BUsernameAndPassword(), null);
    public static final Property bearerToken = BOssEasyApiRequest.newProperty((int)4, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property httpHeader = BOssEasyApiRequest.newProperty((int)0, (BValue)new BHttpRequestHeader(), null);
    public static final Property httpBody = BOssEasyApiRequest.newProperty((int)4, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60))));
    public static final Property automaticUpdate = BOssEasyApiRequest.newProperty((int)0, (boolean)false, null);
    public static final Property updatePeriod = BOssEasyApiRequest.newProperty((int)4, (BValue)BRelTime.make((long)600000L), null);
    public static final Property useThreadPool = BOssEasyApiRequest.newProperty((int)0, (boolean)false, null);
    public static final Property clearOutputOnFault = BOssEasyApiRequest.newProperty((int)0, (boolean)true, null);
    public static final Property generateDataTree = BOssEasyApiRequest.newProperty((int)0, (boolean)true, null);
    public static final Property startupDelayMax = BOssEasyApiRequest.newProperty((int)4, (int)100, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property connectTimeout = BOssEasyApiRequest.newProperty((int)4, (int)30000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property readTimeout = BOssEasyApiRequest.newProperty((int)4, (int)30000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property maxResponseSize = BOssEasyApiRequest.newProperty((int)4, (int)1000000, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL)));
    public static final Property removeLineEnds = BOssEasyApiRequest.newProperty((int)4, (boolean)false, null);
    public static final Property multilineResults = BOssEasyApiRequest.newProperty((int)4, (boolean)false, null);
    public static final Property requestSuccess = BOssEasyApiRequest.newProperty((int)1, (boolean)false, null);
    public static final Property lastRequestSuccess = BOssEasyApiRequest.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property responseCode = BOssEasyApiRequest.newProperty((int)1, (int)0, null);
    public static final Property responseHeader = BOssEasyApiRequest.newProperty((int)1, (BValue)new BHttpResponseHeader(), null);
    public static final Property responseBody = BOssEasyApiRequest.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property responseJson = BOssEasyApiRequest.newProperty((int)9, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property responseError = BOssEasyApiRequest.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property debugEnabled = BOssEasyApiRequest.newProperty((int)4, (boolean)false, null);
    public static final Action sendRequest = BOssEasyApiRequest.newAction((int)0, null);
    public static final Action startRequestTask = BOssEasyApiRequest.newAction((int)4, null);
    public static final Action stopRequestTask = BOssEasyApiRequest.newAction((int)4, null);
    public static final Topic successTrigger = BOssEasyApiRequest.newTopic((int)0, null);
    public static final Topic failureTrigger = BOssEasyApiRequest.newTopic((int)0, null);
    public static final Topic routeJson = BOssEasyApiRequest.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssEasyApiRequest.class);
    private ApiRequestTask requestTask = null;
    private String lastFaultMessage = "";
    private static final Logger log = OssEasyApiLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BApiAlarm getAlarm() {
        return (BApiAlarm)this.get(alarm);
    }

    public void setAlarm(BApiAlarm v) {
        this.set(alarm, (BValue)v, null);
    }

    public String getCurrentState() {
        return this.getString(currentState);
    }

    public void setCurrentState(String v) {
        this.setString(currentState, v, null);
    }

    public String getApiUrl() {
        return this.getString(apiUrl);
    }

    public void setApiUrl(String v) {
        this.setString(apiUrl, v, null);
    }

    public BHttpRequestMethod getHttpMethod() {
        return (BHttpRequestMethod)this.get(httpMethod);
    }

    public void setHttpMethod(BHttpRequestMethod v) {
        this.set(httpMethod, (BValue)v, null);
    }

    public BHttpAuthType getAuthorisation() {
        return (BHttpAuthType)this.get(authorisation);
    }

    public void setAuthorisation(BHttpAuthType v) {
        this.set(authorisation, (BValue)v, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public String getBearerToken() {
        return this.getString(bearerToken);
    }

    public void setBearerToken(String v) {
        this.setString(bearerToken, v, null);
    }

    public BHttpRequestHeader getHttpHeader() {
        return (BHttpRequestHeader)this.get(httpHeader);
    }

    public void setHttpHeader(BHttpRequestHeader v) {
        this.set(httpHeader, (BValue)v, null);
    }

    public String getHttpBody() {
        return this.getString(httpBody);
    }

    public void setHttpBody(String v) {
        this.setString(httpBody, v, null);
    }

    public boolean getAutomaticUpdate() {
        return this.getBoolean(automaticUpdate);
    }

    public void setAutomaticUpdate(boolean v) {
        this.setBoolean(automaticUpdate, v, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    public boolean getUseThreadPool() {
        return this.getBoolean(useThreadPool);
    }

    public void setUseThreadPool(boolean v) {
        this.setBoolean(useThreadPool, v, null);
    }

    public boolean getClearOutputOnFault() {
        return this.getBoolean(clearOutputOnFault);
    }

    public void setClearOutputOnFault(boolean v) {
        this.setBoolean(clearOutputOnFault, v, null);
    }

    public boolean getGenerateDataTree() {
        return this.getBoolean(generateDataTree);
    }

    public void setGenerateDataTree(boolean v) {
        this.setBoolean(generateDataTree, v, null);
    }

    public int getStartupDelayMax() {
        return this.getInt(startupDelayMax);
    }

    public void setStartupDelayMax(int v) {
        this.setInt(startupDelayMax, v, null);
    }

    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    public int getReadTimeout() {
        return this.getInt(readTimeout);
    }

    public void setReadTimeout(int v) {
        this.setInt(readTimeout, v, null);
    }

    public int getMaxResponseSize() {
        return this.getInt(maxResponseSize);
    }

    public void setMaxResponseSize(int v) {
        this.setInt(maxResponseSize, v, null);
    }

    public boolean getRemoveLineEnds() {
        return this.getBoolean(removeLineEnds);
    }

    public void setRemoveLineEnds(boolean v) {
        this.setBoolean(removeLineEnds, v, null);
    }

    public boolean getMultilineResults() {
        return this.getBoolean(multilineResults);
    }

    public void setMultilineResults(boolean v) {
        this.setBoolean(multilineResults, v, null);
    }

    public boolean getRequestSuccess() {
        return this.getBoolean(requestSuccess);
    }

    public void setRequestSuccess(boolean v) {
        this.setBoolean(requestSuccess, v, null);
    }

    public BAbsTime getLastRequestSuccess() {
        return (BAbsTime)this.get(lastRequestSuccess);
    }

    public void setLastRequestSuccess(BAbsTime v) {
        this.set(lastRequestSuccess, (BValue)v, null);
    }

    public int getResponseCode() {
        return this.getInt(responseCode);
    }

    public void setResponseCode(int v) {
        this.setInt(responseCode, v, null);
    }

    public BHttpResponseHeader getResponseHeader() {
        return (BHttpResponseHeader)this.get(responseHeader);
    }

    public void setResponseHeader(BHttpResponseHeader v) {
        this.set(responseHeader, (BValue)v, null);
    }

    public String getResponseBody() {
        return this.getString(responseBody);
    }

    public void setResponseBody(String v) {
        this.setString(responseBody, v, null);
    }

    public String getResponseJson() {
        return this.getString(responseJson);
    }

    public void setResponseJson(String v) {
        this.setString(responseJson, v, null);
    }

    public String getResponseError() {
        return this.getString(responseError);
    }

    public void setResponseError(String v) {
        this.setString(responseError, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void sendRequest() {
        this.invoke(sendRequest, null, null);
    }

    public void startRequestTask() {
        this.invoke(startRequestTask, null, null);
    }

    public void stopRequestTask() {
        this.invoke(stopRequestTask, null, null);
    }

    public void fireSuccessTrigger(BBoolean event) {
        this.fire(successTrigger, (BValue)event, null);
    }

    public void fireFailureTrigger(BBoolean event) {
        this.fire(failureTrigger, (BValue)event, null);
    }

    public void fireRouteJson(BString event) {
        this.fire(routeJson, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssEasyApiLicense.checkLicense()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
            if (Sys.atSteadyState()) {
                this.requestTaskStart();
            }
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
        this.setCurrentState("Idle");
        this.lastFaultMessage = "";
    }

    public void stopped() {
        this.requestTaskStop();
    }

    public void atSteadyState() {
        this.requestTaskStart();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                this.requestTaskStart();
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.requestTaskStop();
            }
        } else if (property == httpMethod) {
            if (this.getHttpMethod().hasWriteData()) {
                this.setFlags((Slot)httpBody, 0);
            } else {
                this.setFlags((Slot)httpBody, 4);
            }
        } else if (property == authorisation) {
            if (this.getAuthorisation().isBasic()) {
                this.setFlags((Slot)credentials, 0);
                this.setFlags((Slot)bearerToken, 4);
            } else if (this.getAuthorisation().isToken()) {
                this.setFlags((Slot)credentials, 4);
                this.setFlags((Slot)bearerToken, 0);
            } else {
                this.setFlags((Slot)credentials, 4);
                this.setFlags((Slot)bearerToken, 4);
            }
        } else if (property == automaticUpdate) {
            if (this.getAutomaticUpdate()) {
                this.setFlags((Slot)updatePeriod, 0);
            } else {
                this.setFlags((Slot)updatePeriod, 4);
            }
            this.initiateRequest();
        } else if (property == updatePeriod) {
            if (this.getAutomaticUpdate()) {
                this.setFlags((Slot)updatePeriod, 0);
                this.initiateRequest();
            } else {
                this.setFlags((Slot)updatePeriod, 4);
            }
        } else if (property == useThreadPool) {
            if (this.getUseThreadPool()) {
                this.requestTaskStop();
            } else {
                this.requestTaskStart();
            }
        } else if (property == multilineResults) {
            if (this.getMultilineResults()) {
                this.setFacets((Slot)responseBody, BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
                this.setFacets((Slot)responseJson, BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
                this.setFacets((Slot)responseError, BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
            } else {
                this.setFacets((Slot)responseBody, BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)false)));
                this.setFacets((Slot)responseJson, BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)false)));
                this.setFacets((Slot)responseError, BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)false)));
            }
        }
    }

    public void doSendRequest() {
        this.initiateRequest();
    }

    public void doStartRequestTask() {
        this.requestTaskStart();
    }

    public void doStopRequestTask() {
        this.requestTaskStop();
    }

    public void requestTaskStart() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            log.fine("[" + this.getName() + "] Disabled");
            return;
        }
        if (this.getUseThreadPool()) {
            return;
        }
        if (this.requestTask == null || !this.requestTask.isAlive()) {
            this.requestTask = new ApiRequestTask(this);
            this.requestTask.start();
        } else {
            log.fine("[" + this.getName() + "] Request task already running");
        }
    }

    public void requestTaskStop() {
        if (this.requestTask != null) {
            this.requestTask.abort();
            this.requestTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateRequest() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            log.fine("[" + this.getName() + "] Disabled");
            return;
        }
        if (this.getUseThreadPool()) {
            ApiRequestPool.execute(this);
        } else if (this.requestTask != null) {
            ApiRequestTask apiRequestTask = this.requestTask;
            synchronized (apiRequestTask) {
                this.requestTask.notifyAll();
            }
        }
    }

    public void clearFault() {
        if (this.getStatus().isFault()) {
            this.getAlarm().dispatch(BSourceState.normal);
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
        this.lastFaultMessage = "";
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.setCurrentState("Fault @ " + BAbsTime.now());
        this.setRequestSuccess(false);
        if (!faultMessage.contentEquals(this.lastFaultMessage) || this.getDebugEnabled()) {
            log.severe("[" + this.getName() + "] " + faultMessage);
            this.lastFaultMessage = faultMessage;
        }
        this.getAlarm().dispatch(BSourceState.fault);
        if (this.getClearOutputOnFault()) {
            this.setResponseBody("");
            this.setResponseJson("");
        }
    }

    public void dbgMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest("[" + this.getName() + "] " + debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/cloud-icon.png");
    }
}

