/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.api.BHttpResponseCookies;
import com.oss.ossEasyAPI.utils.BajaUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="responseCookies", type="BHttpResponseCookies", defaultValue="new BHttpResponseCookies()", flags=1)
public class BHttpResponseHeader
extends BComponent {
    public static final Property responseCookies = BHttpResponseHeader.newProperty((int)1, (BValue)new BHttpResponseCookies(), null);
    public static final Type TYPE = Sys.loadType(BHttpResponseHeader.class);
    private final LinkedList<String> slotsAdded = new LinkedList();

    public BHttpResponseCookies getResponseCookies() {
        return (BHttpResponseCookies)this.get(responseCookies);
    }

    public void setResponseCookies(BHttpResponseCookies v) {
        this.set(responseCookies, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void process(Map<String, List<String>> responseHeaders) {
        try {
            this.slotsAdded.clear();
            this.getResponseCookies().clear();
            for (String headerKey : responseHeaders.keySet()) {
                if (headerKey == null) continue;
                if (headerKey.equalsIgnoreCase("Set-Cookie")) {
                    this.getResponseCookies().addCookie(responseHeaders.get(headerKey));
                    continue;
                }
                this.addHeader(headerKey, responseHeaders.get(headerKey));
            }
            this.removeOldSlots();
            this.getResponseCookies().removeOldSlots();
        }
        catch (Exception responseHeaderException) {
            responseHeaderException.printStackTrace();
        }
    }

    public void addHeader(String entryName, List<String> entryValueList) {
        String primarySlotName = BajaUtils.sanitiseSlotName(entryName);
        int entryCount = 1;
        for (String headerValue : entryValueList) {
            String entrySlotName = entryCount == 1 ? primarySlotName : primarySlotName + entryCount;
            BString slotValue = BString.make((String)headerValue);
            Property valueSlot = this.getProperty(entrySlotName);
            if (valueSlot == null) {
                valueSlot = this.add(entrySlotName, (BValue)slotValue, 1);
            } else {
                this.set(valueSlot, (BValue)slotValue);
                this.setFlags((Slot)valueSlot, 1);
            }
            this.setFacets((Slot)valueSlot, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
            this.slotsAdded.add(entrySlotName);
            ++entryCount;
        }
    }

    public void removeOldSlots() {
        for (Property prop : this.getDynamicPropertiesArray()) {
            if (this.slotsAdded.contains(prop.getName()) || !(this.get(prop) instanceof BString)) continue;
            this.remove(prop);
        }
    }
}

